package ${packageName}

import android.content.Context
import androidx.room.Room
import androidx.test.core.app.ApplicationProvider
import androidx.test.espresso.matcher.ViewMatchers.assertThat
import androidx.test.ext.junit.runners.AndroidJUnit4
import ${packageName}.database.AppDatabase
import ${packageName}.database.${object1Name}
import ${packageName}.database.${object1DaoClassName}
import ${packageName}.database..getOrAwaitValue
import org.hamcrest.CoreMatchers.equalTo
import org.junit.After
import org.junit.Before
import org.junit.Test
import org.junit.runner.RunWith
import java.io.IOException


@RunWith(AndroidJUnit4::class)
class Simple${object1Name}ReadWriteTest {
    private lateinit var ${object1DaoVarName}: ${object1DaoClassName}
    private lateinit var db: AppDatabase

    @Before
    fun createDb() {
        val context = ApplicationProvider.getApplicationContext<Context>()
        db = Room.inMemoryDatabaseBuilder(context, AppDatabase::class.java).build()
        ${object1DaoVarName} = db.${object1DaoVarName}()
    }

    @After
    @Throws(IOException::class)
    fun closeDb() {
        db.close()
    }

    @Test
    @Throws(Exception::class)
    fun write${object1Name}AndReadInList() {
        val ${object1VarName} = ${object1Name}(1)

        ${object1DaoVarName}.insert(${object1VarName})
        val all${object1Name} = ${object1DaoVarName}.getAll()
        assertThat(all${object1Name}.get(0), equalTo(${object1VarName}))
    }
	
	@Test
    @Throws(Exception::class)
    fun clear${object1Name}List() {
        val ${object1VarName} = ${object1Name}(1)

        ${object1DaoVarName}.insert(${object1VarName})
        var all${object1Name} = ${object1DaoVarName}.getAll()
        assertThat(all${object1Name}.get(0), equalTo(${object1VarName}))
		
		${object1DaoVarName}.deleteAll()
		all${object1Name} = ${object1DaoVarName}.getAll()
		
		assert(all${object1Name}.isEmpty())
    }
	
	@Test
    @Throws(Exception::class)
    fun count${object1Name}() {
        val ${object1VarName} = ${object1Name}(1)

        ${object1DaoVarName}.insert(${object1VarName})
        var nbreOf${object1Name} = ${object1DaoVarName}.getRowCount()
        assertThat(nbreOf${object1Name}, equalTo(Integer(1)))
		
		val ${object1VarName}Bis = ${object1Name}(2)

        ${object1DaoVarName}.insert(${object1VarName}Bis)
        nbreOf${object1Name} = ${object1DaoVarName}.getRowCount()
        assertThat(nbreOf${object1Name}, equalTo(Integer(2)))
		
		${object1DaoVarName}.deleteAll()
		nbreOf${object1Name} = ${object1DaoVarName}.getRowCount()
        assertThat(nbreOf${object1Name}, equalTo(Integer(0)))
    }
	
	
    @Test
    @Throws(Exception::class)
    fun addMultiple${object1Name}() {
        val ${object1VarName} = ${object1Name}(1)

		${object1DaoVarName}.insertAll(${object1VarName})
        var nbreOf${object1Name} =  ${object1DaoVarName}.getRowCount()
        assertThat(nbreOf${object1Name}, equalTo(Integer(1)))

        var retreived${object1Name} =  ${object1DaoVarName}.loadAllByIds(arrayOf(Integer(1)))
        assertThat(retreived${object1Name}.get(0), equalTo(${object1VarName}))

        val ${object1VarName}2 = ${object1Name}(2)
        val ${object1VarName}3 = ${object1Name}(3)
        val ${object1VarName}4 = ${object1Name}(4)
		${object1DaoVarName}.insertAll(${object1VarName}2, ${object1VarName}3, ${object1VarName}4)

        nbreOf${object1Name} =  ${object1DaoVarName}.getRowCount()
        assertThat(nbreOf${object1Name}, equalTo(Integer(4)))

        retreived${object1Name} =  ${object1DaoVarName}.loadAllByIds(arrayOf(Integer(3)))
        assertThat(retreived${object1Name}.get(0), equalTo(${object1VarName}3))

        val ${object1VarName}5 = ${object1Name}(5)
        val ${object1VarName}6 = ${object1Name}(6)
        val ${object1VarName}7 = ${object1Name}(7)
        val ${object1VarName}8 = ${object1Name}(8)
		${object1DaoVarName}.insertAll( *arrayOf(${object1VarName}5, ${object1VarName}6, ${object1VarName}7, ${object1VarName}8) )

        nbreOf${object1Name} =  ${object1DaoVarName}.getRowCount()
        assertThat(nbreOf${object1Name}, equalTo(Integer(8)))

        retreived${object1Name} =  ${object1DaoVarName}.loadAllByIds(arrayOf(Integer(8)))
        assertThat(retreived${object1Name}.get(0), equalTo(${object1VarName}8))


        val ${object1VarName}9 = ${object1Name}(9)
        val ${object1VarName}10 = ${object1Name}(10)
		${object1DaoVarName}.insertAll( *listOf(${object1VarName}9, ${object1VarName}10).toTypedArray() )

        nbreOf${object1Name} =  ${object1DaoVarName}.getRowCount()
        assertThat(nbreOf${object1Name}, equalTo(Integer(10)))

        retreived${object1Name} =  ${object1DaoVarName}.loadAllByIds(arrayOf(Integer(9)))
        assertThat(retreived${object1Name}.get(0), equalTo(${object1VarName}9))
    }

    @Test
    @Throws(Exception::class)
    fun getFirst() {
        val ${object1VarName} = ${object1Name}(1)
		${object1DaoVarName}.insert(${object1VarName})

        val ${object1VarName}2 = ${object1Name}(2)
		${object1DaoVarName}.insert(${object1VarName}2)

        val retreived${object1Name} =  ${object1DaoVarName}.getFirst${object1Name}()
        assertThat(retreived${object1Name}, equalTo(${object1VarName}))
    }
	
	<#if daoTransationExample>
	@Test
    @Throws(Exception::class)
    fun updateAll() {
        val ${object1VarName} = ${object1Name}(1)
        val ${object1VarName}2 = ${object1Name}(2)
        val ${object1VarName}3 = ${object1Name}(3)
        val ${object1VarName}4 = ${object1Name}(4)
		${object1DaoVarName}.insertAll(${object1VarName}, ${object1VarName}2, ${object1VarName}3, ${object1VarName}4)

		var retreived${object1Name} =  ${object1DaoVarName}.loadAllByIds(arrayOf(Integer(2)))
        assertThat(retreived${object1Name}.get(0), equalTo(${object1VarName}2))

        val ${object1VarName}5 = ${object1Name}(5)
        val ${object1VarName}6 = ${object1Name}(6)
        val ${object1VarName}7 = ${object1Name}(7)
        val ${object1VarName}8 = ${object1Name}(8)
		// Update all replace the previous database content
        ${object1DaoVarName}.updateData(listOf(${object1VarName}5, ${object1VarName}6, ${object1VarName}7, ${object1VarName}8) as List<${object1Name}> )

		retreived${object1Name} = ${object1DaoVarName}.getAll()
        assertThat(retreived${object1Name}.get(0), equalTo(${object1VarName}5))
    }
	</#if>

	<#if daoOptimizedSelectQueryExample>
	@Test
    @Throws(Exception::class)
    fun getMinimal() {
        val ${object1VarName} = ${object1Name}(1)
        ${object1DaoVarName}.insert(${object1VarName})

        val retreived${object1Name} = ${object1DaoVarName}.get${object1Name}Minimal()
        assertThat(retreived${object1Name}.get(0).${object1Field1ColumnName}, equalTo(${object1VarName}.${object1Field1Name}))
    }
	</#if>
}