package ${packageName}.database


import androidx.room.Entity
import androidx.room.PrimaryKey
import androidx.room.ForeignKey
import androidx.room.ForeignKey.CASCADE;

// Example of indexing
@Entity(indices = arrayOf(Index(value = ["last_name", "address"])))
data class User(
    @PrimaryKey val id: Int,
    val firstName: String?,
    val address: String?,
    @ColumnInfo(name = "last_name") val lastName: String?,
    @Ignore val picture: Bitmap?
)


// Example of uniq key
@Entity(indices = arrayOf(Index(value = ["first_name", "last_name"], unique = true)))
data class User(
    @PrimaryKey val id: Int,
    @ColumnInfo(name = "first_name") val firstName: String?,
    @ColumnInfo(name = "last_name") val lastName: String?,
    @Ignore var picture: Bitmap?
)



// Example of ForeignKey usage
// Consider a User and a Pet class. The Pet has an owner, which is a user id referenced as foreign key.

@Entity(tableName = "pets",
        foreignKeys = arrayOf(
            ForeignKey(entity = User::class,
                       parentColumns = arrayOf("userId"),
                       childColumns = arrayOf("owner"),
					   onDelete = CASCADE)))
data class Pet(@PrimaryKey val petId: String,
              val name: String,
              val owner: String)
			  
			  
class UserAndAllPets {
	@Embedded
	var user: User? = null

	@Relation(parentColumn = “userId”,
		entityColumn = “owner”)
	var pets: List<Pet> = ArrayList()
}

// => in DAO :
// @Transaction
// @Query(“SELECT * FROM Users”)
// List<UserAndAllPets> getUsers();