package ${packageName}.database

import androidx.lifecycle.LiveData
import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Transaction
import java.util.Date

import java.util.List

@Dao
interface ${object1DaoClassName}<#if useGenericDAO>:BaseDao<${object1Name}></#if> {
    @Query("SELECT * FROM ${object1EntityTableName}")
    fun getAll(): List<${object1Name}>

	@Query("SELECT * FROM ${object1EntityTableName}") // ORDER BY id DESC
    fun getAllSync(): LiveData<List<${object1Name}>>
	
	@Query("SELECT * FROM ${object1EntityTableName} WHERE ${object1Field1ColumnName} IN (:itemIds)")
	fun loadAllByIds(itemIds: Array<Integer>): List<${object1Name}>
	
	@Query("SELECT * FROM ${object1EntityTableName} LIMIT 1")
    fun getFirst${object1Name}(): ${object1Name}
	
	@Query("SELECT COUNT(*) FROM ${object1EntityTableName}")
	fun getRowCount(): Integer
	
	@Query("SELECT COUNT(*) FROM ${object1EntityTableName}")
	fun getRowCountSync(): LiveData<Integer>

<#if includeDateTypeConverter>
// Example using Date
//     @Query("SELECT * FROM ${object1EntityTableName} WHERE date_field BETWEEN :from AND :to")
//    fun find${object1Name}BetweenDates(from: Date, to: Date): List<${object1Name}>
</#if>

<#if !useGenericDAO>
	@Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(obj: ${object1Name}): Long // can return void
	
	@Insert
    fun insertAll(vararg ${object1EntityTableName}s: ${object1Name})

    @Update
    fun update(vararg list: ${object1Name}): Int

	@Delete
    fun delete(${object1EntityTableName}: ${object1Name})
	
    @Delete
    fun delete(vararg list: ${object1Name}): Int
</#if>

    @Query("DELETE FROM ${object1EntityTableName}")
    fun deleteAll(): Int
	
<#if daoTransationExample>
	// Example of Transaction
	@Transaction
    open fun updateData(${object1EntityTableName}: List<${object1Name}>) {
        deleteAll()
		insertAll(*${object1EntityTableName}.toArray() as Array<${object1Name}>)
    }
</#if>
	
<#if daoOptimizedSelectQueryExample>
	// Example of optimized selection (get only the needed columns)
	@Query("SELECT ${object1Field1ColumnName} FROM ${object1EntityTableName}")
    fun get${object1Name}Minimal(): List<${object1Name}Minimal>
</#if>
	
<#if handleLiveDataDistinct>
	// Example of LiveData triggering only when needed (and not everytime one item of the ${object1EntityTableName} table is updated)
	@Query("SELECT * FROM ${object1EntityTableName} WHERE ${object1Field1ColumnName} = :id")
	abstract fun get${object1Name}ById(id: ${object1Field1Type}): LiveData<${object1Name}>
	
	fun getDistinct${object1Name}ById(id: ${object1Field1Type}): 
		LiveData<${object1Name}> = get${object1Name}ById(id).getDistinct()
</#if>
	
	<#if handleFlowDistinct>
	@Query("SELECT * FROM ${object1EntityTableName} WHERE name = :name")
    abstract fun get${object1Name}(name: String): Flow<${object1Name}>
	
	fun get${object1Name}DistinctUntilChanged(name:String) = get${object1Name}(name).distinctUntilChanged()
	</#if>
	
}