package ${packageName}.database;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import java.util.Date;

import java.util.List;

@Dao
public interface  ${object1DaoClassName}<#if useGenericDAO> extends BaseDao<${object1Name}></#if> {
    @Query("SELECT * FROM ${object1EntityTableName}")
    List<${object1Name}> getAll();

    @Query("SELECT * FROM ${object1EntityTableName}") // ORDER BY id DESC
    LiveData<List<${object1Name}>> getAllSync();
	
    @Query("SELECT * FROM ${object1EntityTableName} WHERE ${object1Field1ColumnName} IN (:itemIds)")
    List<${object1Name}> loadAllByIds(List<Integer> itemIds);
	
    @Query("SELECT * FROM ${object1EntityTableName} LIMIT 1")
    ${object1Name} getFirst${object1Name}();
	
    @Query("SELECT COUNT(*) FROM ${object1EntityTableName}")
    int getRowCount();
	
    @Query("SELECT COUNT(*) FROM ${object1EntityTableName}")
    LiveData<Integer> getRowCountSync();

<#if includeDateTypeConverter>
// Example using Date
//     @Query("SELECT * FROM ${object1EntityTableName} WHERE date_field BETWEEN :from AND :to")
//    List<${object1Name}> find${object1Name}BetweenDates(Date from, Date to);
</#if>

<#if !useGenericDAO>
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    Long insert(${object1Name} obj); // can return void
	
    @Insert
    int insertAll(List<${object1Name}> ${object1EntityTableName}s)

    @Update
    int update(List<${object1Name}> list);

    @Delete
    void delete(${object1Name} ${object1EntityTableName})
	
    @Delete
    int delete(List<${object1Name}> list);
</#if>

    @Query("DELETE FROM ${object1EntityTableName}")
    int deleteAll();
	
<#if daoTransationExample>
    // Example of Transaction
    @Transaction
    void updateData(List<${object1Name}> ${object1EntityTableName}) {
        deleteAll();
        insertAll(${object1EntityTableName})
    }
</#if>
	
<#if daoOptimizedSelectQueryExample>
    // Example of optimized selection (get only the needed columns)
    @Query("SELECT ${object1Field1ColumnName} FROM ${object1EntityTableName}")
    List<${object1Name}Minimal> get${object1Name}Minimal();
</#if>
	
<#if handleLiveDataDistinct>
    // Example of LiveData triggering only when needed (and not everytime one item of the ${object1EntityTableName} table is updated)
    @Query("SELECT * FROM ${object1EntityTableName} WHERE ${object1Field1ColumnName} = :id")
    LiveData<${object1Name}> get${object1Name}ById(${object1Field1Type} id);
	
    LiveData<${object1Name}> getDistinct${object1Name}ById(${object1Field1Type} id) {
        return get${object1Name}ById(id).getDistinct();
    }
</#if>
	
<#if handleFlowDistinct>
    @Query("SELECT * FROM ${object1EntityTableName} WHERE name = :name")
    Flow<${object1Name}> get${object1Name}(name: String);
	
    Flow<${object1Name}> get${object1Name}DistinctUntilChanged(String name) {
        return get${object1Name}(name).distinctUntilChanged();
    }
</#if>
	
}