package ${packageName}.database

import androidx.room.Delete
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Update

interface BaseDao<T> {

    /**
     * Insert an object in the database.
     *
     * @param obj the object to be inserted.
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(obj: T): Long // can return void

    /**
     * Insert an array of objects in the database.
     *
     * @param list the objects to be inserted.
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertAll(vararg list: T): List<Long?>? // Can return void, List<Long>, long[] or Long[]

    /**
     * Update an object list of the database.
     *
     * @param list of objects to be updated
     */
    @Update
    fun update(vararg list: T): Int

    /**
     * Delete an object list in the database
     *
     * @param list of objects to be deleted
     */
    @Delete
    fun delete(vararg list: T): Int
}