package ${packageName}.database;

import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Update;

import java.util.List;

public interface BaseDao<T> {

    /**
     * Insert an object in the database.
     *
     * @param obj the object to be inserted.
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insert(T obj); // can return void

    /**
     * Insert an array of objects in the database.
     *
     * @param list the objects to be inserted.
     */
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    List<Long> insertAll(T... list); // Can return void, List<Long>, long[] or Long[]

    /**
     * Update an object list of the database.
     *
     * @param list of objects to be updated
     */
    @Update
    int update(T... list); // can return int (the number of item updated)

    /**
     * Delete an object list in the database
     *
     * @param list of objects to be deleted
     */
    @Delete
    int delete(T... list); // can return int (the number of item updated)
}
