package ${packageName}.database

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
<#if includeDateTypeConverter>
import androidx.room.TypeConverters
</#if>
<#if prepopulateDatabase && prepopulateDatabaseType == 'prepopulateDdbFromFile'>
import java.io.File
</#if>
<#if includeMigrationExamples>
import androidx.room.migration.Migration
import androidx.sqlite.db.SupportSQLiteDatabase
</#if>

// Source of some optimization : https://medium.com/androiddevelopers/7-pro-tips-for-room-fbadea4bfbd1

@Database(entities = arrayOf(${object1Name}::class), version = 1)
<#if includeDateTypeConverter>
	@TypeConverters(Converters::class)
</#if>
abstract class AppDatabase : RoomDatabase() {
    abstract fun ${object1DaoVarName}(): ${object1DaoClassName}
	
	// Example of usage : AppDatabase.getInstance(applicationContext).${object1DaoVarName}().insert(${object1Name}())
	
	companion object : SingletonHolder<AppDatabase, Context>({
	
<#if includeMigrationExamples>
	val MIGRATION_1_2 = object : Migration(1, 2) {
		override fun migrate(database: SupportSQLiteDatabase) {
			database.execSQL("CREATE TABLE `table_name2` (`id` INTEGER, `name` TEXT, " +
					"PRIMARY KEY(`id`))")
		}
	}

	val MIGRATION_2_3 = object : Migration(2, 3) {
		override fun migrate(database: SupportSQLiteDatabase) {
			database.execSQL("ALTER TABLE `table_name2` ADD COLUMN pub_year INTEGER")
		}
	}
</#if>
	
<#if databaseType == 'dbFile'>
        Room.databaseBuilder(
            it.applicationContext,
            AppDatabase::class.java, "${databaseFileName}"
        )
		<#if prepopulateDatabase && prepopulateDatabaseType == 'prepopulateDdbFromAsset'>
		.createFromAsset("${prepopulateDatabaseFromAssetPath}")
		<#elseif prepopulateDatabase && prepopulateDatabaseType == 'prepopulateDdbFromFile'>
		.createFromFile(File("${prepopulateDatabaseFromFilePath}"))
		</#if>
		<#if includeMigrationExamples>
		.addMigrations(MIGRATION_1_2, MIGRATION_2_3)
		</#if>
		// Delete the database in case of upgrade :
		// .fallbackToDestructiveMigrationFrom()
		// .allowMainThreadQueries() // Not recommended
            .build()
<#else>
        Room.inMemoryDatabaseBuilder(
            it.applicationContext,
            AppDatabase::class.java
        )
		// Delete the database in case of upgrade :
		// .fallbackToDestructiveMigrationFrom()
		// .allowMainThreadQueries() // Not recommended
		.build()
</#if>
    })
}