package ${packageName}.database;

import android.content.Context;

import androidx.room.Database;
import androidx.room.Room;
import androidx.room.RoomDatabase;
<#if includeDateTypeConverter>
import androidx.room.TypeConverters;
</#if>
<#if prepopulateDatabase && prepopulateDatabaseType == 'prepopulateDdbFromFile'>
import java.io.File;
</#if>
<#if includeMigrationExamples>
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
</#if>

// Source of some optimization : https://medium.com/androiddevelopers/7-pro-tips-for-room-fbadea4bfbd1

@Database(entities = {${object1Name}.class}, version = 1)
<#if includeDateTypeConverter>
	@TypeConverters(Converters.class)
</#if>
public abstract class AppDatabase extends RoomDatabase {
    private static AppDatabase INSTANCE;

    public abstract ${object1DaoClassName} ${object1DaoVarName}();
	
	// Example of usage : AppDatabase.getInstance(this).${object1DaoVarName}().insert(${object1Name}())
	
	
	
	public static AppDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
<#if databaseType == 'dbFile'>
            INSTANCE =
                    Room.databaseBuilder(context.getApplicationContext(), AppDatabase.class, "${databaseFileName}")
                            <#if prepopulateDatabase && prepopulateDatabaseType == 'prepopulateDdbFromAsset'>
				.createFromAsset("${prepopulateDatabaseFromAssetPath}")
				<#elseif prepopulateDatabase && prepopulateDatabaseType == 'prepopulateDdbFromFile'>
				.createFromFile(File("${prepopulateDatabaseFromFilePath}"))
				</#if>
				<#if includeMigrationExamples>
				.addMigrations(MIGRATION_1_2, MIGRATION_2_3)
				</#if>
			    // Delete the database in case of upgrade :
				// .fallbackToDestructiveMigrationFrom()
				// .allowMainThreadQueries() // Not recommended
				.build();
<#else>
				Room.inMemoryDatabaseBuilder(context.getApplicationContext(), AppDatabase.class)
			    // Delete the database in case of upgrade :
				// .fallbackToDestructiveMigrationFrom()
				// .allowMainThreadQueries() // Not recommended
				.build();
</#if>
        }
        return INSTANCE;
	}
}