<#if generateKotlin>
	apply plugin: 'kotlin-kapt'
</#if>


dependencies {

	implementation "androidx.room:room-runtime:${r"${rootProject.ext.roomVersion}"}"

	annotationProcessor "androidx.room:room-compiler:${r"${rootProject.ext.roomVersion}"}"
	
<#if generateKotlin>
	kapt "androidx.room:room-compiler:${r"${rootProject.ext.roomVersion}"}"
	
	<#if includeKotlinExtensions>
	  // optional - Kotlin Extensions and Coroutines support for Room
	  implementation "androidx.room:room-ktx:${r"${rootProject.ext.roomVersion}"}"
	</#if>
</#if>


<#if includeRxJavaSupport>
  // optional - RxJava support for Room
  implementation "androidx.room:room-rxjava2:${r"${rootProject.ext.roomVersion}"}"
</#if>

<#if includeGuavaSupport>
	// optional - Guava support for Room, including Optional and ListenableFuture
	implementation "androidx.room:room-guava:${r"${rootProject.ext.roomVersion}"}"
</#if>

	// Test helpers
	testImplementation "androidx.room:room-testing:${r"${rootProject.ext.roomVersion}"}"
}

<#if includeExportSchema>
android {
	defaultConfig {
		<#if true>
        javaCompileOptions {
            annotationProcessorOptions {
                arguments = ["room.schemaLocation": "$projectDir/schemas".toString()]
            }
        }
		</#if>
		<#if false>
		kapt {
            arguments {
                arg("room.schemaLocation", "$projectDir/schemas")
            }
        }
		</#if>
	}
}
</#if>