<?xml version="1.0"?>
<#import "root://activities/common/kotlin_macros.ftl" as kt>

<recipe>

    <@kt.addAllKotlinDependencies />
	
    <merge from="app_build.gradle.ftl" to="${escapeXmlAttribute(projectOut)}/build.gradle" />
    <merge from="project_build.gradle.ftl" to="build.gradle" />
			 
				 
	<#if generateDatabaseClass>
		<instantiate from="src/app_package/AppDatabase.${ktOrJavaExt}.ftl" to="${escapeXmlAttribute(srcOut)}/database/AppDatabase.${ktOrJavaExt}" />
	</#if>
	
	<instantiate from="src/app_package/Entity.${ktOrJavaExt}.ftl" to="${escapeXmlAttribute(srcOut)}/database/${object1Name}.${ktOrJavaExt}" />

	<#if daoOptimizedSelectQueryExample>
		<instantiate from="src/app_package/EntityMinimal.${ktOrJavaExt}.ftl" to="${escapeXmlAttribute(srcOut)}/database/${object1Name}Minimal.${ktOrJavaExt}" />
	</#if>
		
	<instantiate from="src/app_package/DAO.${ktOrJavaExt}.ftl" to="${escapeXmlAttribute(srcOut)}/database/${object1DaoClassName}.${ktOrJavaExt}" />
	
	<#if includeDateTypeConverter>
		<instantiate from="src/app_package/Converters.${ktOrJavaExt}.ftl" to="${escapeXmlAttribute(srcOut)}/database/Converters.${ktOrJavaExt}" />
	</#if>
	
	<#if useGenericDAO>
		<instantiate from="src/app_package/BaseDao.${ktOrJavaExt}.ftl" to="${escapeXmlAttribute(srcOut)}/database/BaseDao.${ktOrJavaExt}" />
	</#if>
	
	<#if generateKotlin>
		<instantiate from="src/app_package/SingletonHolder.${ktOrJavaExt}.ftl" to="${escapeXmlAttribute(srcOut)}/database/SingletonHolder.${ktOrJavaExt}" />
		<instantiate from="src/app_package/LiveDataExtension.${ktOrJavaExt}.ftl" to="${escapeXmlAttribute(srcOut)}/database/LiveDataExtension.${ktOrJavaExt}" />
	</#if>
	
	<#if includeTestExamples>
		<instantiate from="src/app_package/SimpleEntityReadWriteTest.${ktOrJavaExt}.ftl" to="${escapeXmlAttribute(testOut)}/Simple${object1Name}ReadWriteTest.${ktOrJavaExt}" />
	</#if>
	
</recipe>