import com.andreapivetta.kolor.green
import com.fazecast.jSerialComm.SerialPort
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.runBlocking
import java.time.LocalDateTime
import java.time.format.DateTimeFormatter

fun String.decodeHexToAscii(): String {
    if(isEmpty()) return "EMPTY"
    //require(length % 2 == 0) { "Must have an even length" }
    if (length % 2 != 0) { "Must have an even length" }
    return chunked(2)
        .map { it.toInt(16).toByte() }
        .toByteArray()
        .toString(Charsets.ISO_8859_1)  // Or whichever encoding your input uses
}

data class ExpectedResult(val challengeName: String, val id: String? = null, val idAscii: String? = null, val pid: String? = null, val pidAscii: String? = null, val pidWiegan: String? = null )

//val challengeDescription = mapOf(
//    "COM10" to "Read UUID",
//    "COM16" to "Read Dictionnary Key",
//    "COM11" to "Read Random Key",
//    "COM5" to "Read secret in block",
//    "COM6" to "Desfire UUID",
//    "COM7" to "Desfire default keys",
//    "COM8" to "Desfire random keys",
//    "COM9" to "Desfire proximity check"
//)

val expected = mapOf(
    "COM23" to ExpectedResult(challengeName = "Level 0 : 125k", id = "81005C9E37"), //pidWiegan = "245231"
    "COM25" to ExpectedResult(challengeName = "Level 1 : Read UUID", id = "803E02CAAF9D04"), // Verisure bleu // Verisure rose : 803E02DA7680044849505F
    "COM30" to ExpectedResult(challengeName = "Level 2 : Read UUID", idAscii = "HIP_"),
    "COM28" to ExpectedResult(challengeName = "Level 3 : Read Default Key", idAscii = "SecSea"),
    "COM27" to ExpectedResult(challengeName = "Level 4 : Read Dictionnary Key", idAscii = "DicoRu"),
    "COM15" to ExpectedResult(challengeName = "Level 5 : Read Random Key", id = "1122334455"),
    "COM29" to ExpectedResult(challengeName = "Level 6 : Desfire UUID", id = "40947A2256F80"), // Desfire UID
    "COM26" to ExpectedResult(challengeName = "Level 7 : Desfire PID", pid = "12CF8F340"), // Desfire PID
    "COM24" to ExpectedResult(challengeName = "Level 8 : Desfire PID proximity check", pid = "12CF8F340") // Desfire PID

//    "COM7" to ExpectedResult(challengeName = "TEST ", pid = "C2EC024ED5"),
//    "COM12" to ExpectedResult(challengeName = "TEST", pid = "C2EC024ED5"),
)
// val connexions: Map<String, SerialPort> = mapOf()

const val ENCODER_COM_PORT = "COM16"
const val DEBUG_MODE = false

val formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")

fun main(args: Array<String>): Unit = runBlocking {

    println("Program arguments: ${args.joinToString()}")

    // Try adding program arguments via Run/Debug configuration.
    // Learn more about running applications: https://www.jetbrains.com/help/idea/running-applications.html.
    if (DEBUG_MODE) println("Program arguments: ${args.joinToString()}")

    val serialPortList = SerialPort.getCommPorts()
    if (DEBUG_MODE) println("Ports list:")
//    if (DEBUG_MODE) serialPortList.forEach { println(it.descriptivePortName) }
//    if (DEBUG_MODE) serialPortList.forEach { println(it.portDescription) }
//    if (DEBUG_MODE) serialPortList.forEach { println(it.portLocation) }
    if (DEBUG_MODE) serialPortList.forEach { println(it.systemPortName) }

    var idRead = ""

    if (serialPortList.isNotEmpty()) {

        serialPortList.forEach { comPort ->

            if (DEBUG_MODE) println("Loop : ${comPort.systemPortName}")

            if(ENCODER_COM_PORT == comPort.systemPortName) {

                println("Bypass the encoder COM port")

            } else {
                launch { // launch a new coroutine and keep a reference to its Job
                    //val comPort = serialPortList[0]
                    delay(100L)
                    println("Using : ${comPort.systemPortName}")

                    comPort.openPort()
                    try {
                        while (true) {
                            delay(100L)
                            while (comPort.bytesAvailable() == 0) delay(20L)
                            val readBuffer = ByteArray(comPort.bytesAvailable())
                            val numRead = comPort.readBytes(readBuffer, readBuffer.size.toLong())
                            if (DEBUG_MODE) println("${comPort.systemPortName} Read $numRead char(s)/ ${numRead/2} byte(s) ?")
                            if (DEBUG_MODE) println("${comPort.systemPortName} Read ${readBuffer.decodeToString()}") // - ${ readBuffer.decodeToString().toLong().toHex() }

                            idRead = "$idRead${readBuffer.decodeToString()}"
                            if (idRead.contains("\n")) {
                                idRead = idRead.trim()

                                // Remove non-alphanumeric characters
                                val re = Regex("[^A-Za-z0-9 ]")
                                idRead = re.replace(idRead, "") // works

                                val idAscii = try { if(idRead.isNotEmpty()) idRead.decodeHexToAscii() else ""} catch (nfe: NumberFormatException){
                                    ""
                                }
                                val privateId = try {
                                    idRead.toLong().toHex()
                                } catch (nfe: NumberFormatException){
                                    ""
                                }
                                val privateIdWiegan = try {
                                    (privateId.toInt(16) shr 1).toString(16)
                                } catch (nfe: NumberFormatException){
                                    ""
                                }
                                val privateIdAscii = try {if(idRead.isNotEmpty()) idRead.toLong().toHex().decodeHexToAscii() else ""} catch (nfe: NumberFormatException){
                                    ""
                                }

                                val current = LocalDateTime.now()
                                val message = "${expected[comPort.systemPortName]?.challengeName} [${comPort.systemPortName}] ID : $idRead ID_ASCII ($idAscii) | PID: $privateId ($privateIdAscii) [$privateIdWiegan]"
                                if(
                                    expected[comPort.systemPortName]?.id == idRead
                                    || expected[comPort.systemPortName]?.idAscii == idAscii
                                    || expected[comPort.systemPortName]?.pid == privateId
                                    || expected[comPort.systemPortName]?.pidAscii == privateIdAscii
                                    || expected[comPort.systemPortName]?.pidWiegan == privateIdWiegan
                                ) {
                                    println("${current.format(formatter)}: $message GREAT".green())
                                } else {
                                    println("${current.format(formatter)}: $message")
                                }

                                idRead = ""
                            }
                        }
                    } catch (e: Exception) {
                        e.printStackTrace()
                    }
                    comPort.closePort()
                }
            }


        }
    } else {
        println("No serial port found")
    }
}