fun String.decodeHex(): ByteArray {
    check(length % 2 == 0) { "Must have an even length" }

    return chunked(2)
        .map { it.toInt(16).toByte() }
        .toByteArray()
}

fun ByteArray.toHex(): String = joinToString(separator = "") { eachByte -> "%02x".format(eachByte) }

fun Long.toHex(): String {
    var value = this
    var r: Long
    var hex = ""
    val hexch = arrayOf('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F')
    while (value > 0) {
        r = value % 16
        hex = "${hexch[r.toInt()]}$hex"
        value /= 16
    }
    return hex
}