# Install NFCGate and required module for relay attack with the Nexus 5X

[NFCGate](https://github.com/nfcgate/nfcgate) is an application using **two phones** (at least one Nexus 5X) and a **server** (server.py, could be started on one of the two phones) that can relay the communication between a tag and a reader (aka Relay Attack).


In order to use all functionality of the NFCGate App, the NFCGate XPosed module needs to be installed, so the **phone need to be rooted**, also, NFCGate only works with a **limited list of compatible phones**, so **use the Nexus 5X for the tag role**.

## Requirements

* [Android SDK Platform tool](https://developer.android.com/tools/releases/platform-tools), Official android tools, required for **adb** and **fastboot** android command utilities, (tested with Platform tool release 34.0.1 (March 2023)).
* [Google Drivers](https://developer.android.com/studio/run/win-usb?hl=fr), required **to communicate** with phone with **adb** and **fastboot**. 
* [TWRP](https://twrp.me/), custom recovery menu, required for the method **used to install Magisk** (tested with [TWRP release 3.7.0](https://twrp.me/lg/lgnexus5x.html))
* [Magisk](https://github.com/topjohnwu/Magisk), required for **root access** and **to install XPosed**, (tested with [release v26.1](https://github.com/topjohnwu/Magisk/releases/tag/v26.1), should work with higher versions),
* **Zygisk**, required **to install LSXposed**, activate it from **Magisk settings**.
* [LSposed](https://github.com/LSPosed/LSPosed), required to install NFCGate Module, (tested with [LSPosed release v1.8.6](https://github.com/LSPosed/LSPosed/releases/tag/v1.8.6)).
* [NFC Gate](https://github.com/nfcgate/nfcgate), (tested with [NFCGate release v2.2.0](https://github.com/nfcgate/nfcgate/releases/tag/v2.2.0), should work with higher versions),
* **NFC Gate Module**, shows up automaticaly in LSposed when NFC Gate is installed, you have to **enable it in the menu**.
* [NFC Gate Server](https://github.com/nfcgate/server), required, should run on a server of directly on one of the phones through **termux**.
* [Termux](https://f-droid.org/fr/packages/com.termux/), required for running **python server directly on the phone**.
* [Termux Widget](https://f-droid.org/fr/packages/com.termux.widget/), required to add a nice icon for running the **python server** from the phone.

## 1) Install phone drivers for adb / fastboot

* [Google Drivers](https://developer.android.com/studio/run/win-usb?hl=fr)

Driver installation is touchy:
  * The phone change of usb device whether it is in normal debug mode (adb) or in bootloader mode (fastboot),
  * You need to install the driver for **normal mode**,
  * You need to **reinstall** the driver **once in the bootloader mode**,
  * You need to select the driver manually in the device manager [Official driver installation tutorial](https://developer.android.com/studio/run/oem-usb?hl=en#InstallingDriver) 


![Unrecognized Android device](img/triangleDevice.png)
![Provided disk](img/providedDisk.png)
![Google driver](img/googleDriver.png)
![Select Android Bootloader Interface](img/AndroidBootloaderInterface.png)


## 2) Reboot in bootloader mode, unlock and flash TWRP

(If the phone is already rooted with magisk, you can skip this step).

In normal mode, use **adb** :

```
.\adb.exe reboot bootloader
```

In bootloader mode, use **fastboot**.

First unlock the device to get **DEVICE STATE - unlocked**:

[Official Locking/Unlocking tutorial](https://source.android.com/docs/core/architecture/bootloader/locking_unlocking?hl=en)

```
.\fastboot.exe flashing unlock
```

Then you can flash the custom recovery: 

 [Official TWRP instructions for Nexus 5X](https://twrp.me/lg/lgnexus5x.html)

*replace twrp.img with the correct filename*

```
.\fastboot.exe flash recovery twrp.img
```

## 3) Install magisk

Install magisk using Custom Recovery (deprecated, but ok for Nexus 5X)

Download magisk apk from github: [Magisk](https://github.com/topjohnwu/Magisk)

[Official Magisk install instructions](https://topjohnwu.github.io/Magisk/install.html#custom-recovery)

Boot into recovery mode:

```
.\adb.exe reboot recovery
```
**Note: the firmware may sometimes erase the custom recovery so you may have to reinstall TWRP**.

[XDA Instructions for installing Magisk with TWRP](https://www.xda-developers.com/how-to-install-magisk/)

## 4) Enable Zygisk, Install LSPosed

Once Zygisk is enabled from the **Magisk Settings menu**, you can **install from storage** from **Magisk Module menu**.

Download LSposed apk from github then install it: [LSposed](https://github.com/LSPosed/LSPosed).


## 5) Install NFCGate

Get the NFCGate apk from github then install it: [NFC Gate](https://github.com/nfcgate/nfcgate)

## 6) Install the Server (required only on a single phone).

For running the python server, you need termux on the phone. The recommended way is to download the apk from F-Droid website (F-Droid app is not required):

 * [Termux](https://f-droid.org/fr/packages/com.termux/),
 * [Termux Widget](https://f-droid.org/fr/packages/com.termux.widget/).

Termux is a linux terminal. You also need to install python to be able to run the NFCGate python server.

Inside termux, run :
```
pkg install python
```

```
pkg install iproute2
```