// Source: https://gist.github.com/fs0c131y/a3dbf8db1f1ed79ea5dbc178463c430c

/*
 * get_sqlcipher_password.js
 * Copyright (c) 2019 Elliot Alderson <fs0c131y@protonmail.com>
 *
 * Frida.re JS functions to get SQLCipher database passwords.
 *
 * Example usage:
 * # frida -U -f in.gov.uidai.mAadhaarPlus -l get_sqlcipher_password.js --no-pause
 *
 */
'use strict;'

function getSQLCipherPassword() {

	var SQLiteOpenHelper = Java.use('net.sqlcipher.database.SQLiteOpenHelper');
	SQLiteOpenHelper.getWritableDatabase.overload('java.lang.String').implementation = function (password) {
		console.log("[+] password = " + password);

		return this.getWritableDatabase.overload('java.lang.String').apply(this, arguments);
	}
	
	//SQLiteDatabase getWritableDatabase(byte[] bArr) {
		

	var CipheredSQLiteDatabase = Java.use("net.sqlcipher.database.SQLiteDatabase");
	console.log("[+] Hooked: " + CipheredSQLiteDatabase);
	CipheredSQLiteDatabase.openOrCreateDatabase.overload("java.lang.String", "java.lang.String", "net.sqlcipher.database.SQLiteDatabase$CursorFactory", "net.sqlcipher.database.SQLiteDatabaseHook").implementation = function(path, password, factory, hook) {
		console.log("[+] PASSWORD FOUND: " + password.join(""));
		var db = this.openOrCreateDatabase(path, password, factory, hook);
		return db;
	};

}

Java.perform(function () {

	getSQLCipherPassword();

});