/*  Android TODO: Describe
    by Tristan SALAUN
	
    Run with:
    frida -U -f [APP_ID] -l NAME_OF_THE_SCRIPT.js --no-pause
*/

function toHexString(byteArray) {
    return '[0x' + Array.from(byteArray, function (byte) {
        return ('0' + (byte & 0xFF).toString(16)).slice(-2);
    }).join(' 0x') + ']'
}
function toAsciiString(byteArray) {
    return Array.from(byteArray, function (byte) {
        return String.fromCharCode(byte);
    }).join('')
}
// Source : https://ackcent.com/recovering-sqlcipher-encrypted-data-with-frida/
function dumpDb(File, db, path) {
    var file = File.$new(path + ".plaintext");
    file.delete();
    db.rawExecSQL("ATTACH DATABASE '" + path + ".plaintext' AS plaintext KEY '';SELECT sqlcipher_export('plaintext');DETACH DATABASE plaintext;");
    send(JSON.stringify({
        type: 'sqlcipher',
        timestamp: Date.now(),
        sub_type: 'Database dump',
        value: `adb shell su -c cat /${path}.plaintext > dumpedDatabase.db`
    }));
}

Java.perform(function () {
    //console.log('');
    //console.log('======');
    //console.log('[#] Hook of net.sqlcipher.database.SQLiteOpenHelper [#]');
    //console.log('======');
    // **************************************************

    var File = Java.use("java.io.File");

    try {
        Java.use('net.sqlcipher.database.SQLiteOpenHelper').getReadableDatabase.overload('java.lang.String').implementation = function (str) {
            //console.log("net.sqlcipher.database.SQLiteOpenHelper.getReadableDatabase");
            //console.log("str: " + str);

            // Return type: SQLiteDatabase
            const returnValue = this.getReadableDatabase.apply(this, arguments);
            //console.log('net.sqlcipher.database.SQLiteOpenHelper.getReadableDatabase return value: ' + returnValue);

            send(JSON.stringify({
                type: 'sqlcipher',
                timestamp: Date.now(),
                sub_type: 'SQLiteOpenHelper.getReadableDatabase(String)' + returnValue.getPath(),
                value: toHexString(str)
            }));

            dumpDb(File, returnValue, returnValue.getPath());
            
            return returnValue;
        };
    } catch (err) {
        //console.log('[-] net.sqlcipher.database.SQLiteOpenHelper.getReadableDatabase pinner not found');
        //console.log(err);
    }

    try {
        Java.use('net.sqlcipher.database.SQLiteOpenHelper').getWritableDatabase.overload('java.lang.String').implementation = function (str) {
            //console.log("net.sqlcipher.database.SQLiteOpenHelper.getWritableDatabase");
            //console.log("str: " + str);

            // Return type: SQLiteDatabase
            const returnValue = this.getWritableDatabase.apply(this, arguments);
            //console.log('net.sqlcipher.database.SQLiteOpenHelper.getWritableDatabase return value: ' + returnValue);
            
            send(JSON.stringify({
                type: 'sqlcipher',
                timestamp: Date.now(),
                sub_type: 'SQLiteOpenHelper.getWritableDatabase(String)' + returnValue.getPath(),
                value: toHexString(str)
            }));

            dumpDb(File, returnValue, returnValue.getPath());

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] net.sqlcipher.database.SQLiteOpenHelper.getWritableDatabase pinner not found');
        //console.log(err);
    }

    try {
        Java.use('net.sqlcipher.database.SQLiteOpenHelper').getReadableDatabase.overload('[C').implementation = function (cArr) {
            console.log("net.sqlcipher.database.SQLiteOpenHelper.getReadableDatabase");
            console.log("cArr: " + cArr);

            // Return type: SQLiteDatabase
            const returnValue = this.getReadableDatabase.apply(this, arguments);
            //console.log('net.sqlcipher.database.SQLiteOpenHelper.getReadableDatabase return value: ' + returnValue);
            
            send(JSON.stringify({
                type: 'sqlcipher',
                timestamp: Date.now(),
                sub_type: 'SQLiteOpenHelper.getReadableDatabase(char[])' + returnValue.getPath(),
                value: toHexString(str)
            }));

            dumpDb(File, returnValue, returnValue.getPath());

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] net.sqlcipher.database.SQLiteOpenHelper.getReadableDatabase pinner not found');
        //console.log(err);
    }

    try {
        Java.use('net.sqlcipher.database.SQLiteOpenHelper').getWritableDatabase.overload('[C').implementation = function (cArr) {
            //console.log("net.sqlcipher.database.SQLiteOpenHelper.getWritableDatabase");
            //console.log("cArr: " + cArr);

            // Return type: SQLiteDatabase
            const returnValue = this.getWritableDatabase.apply(this, arguments);
            //console.log('net.sqlcipher.database.SQLiteOpenHelper.getWritableDatabase return value: ' + returnValue);

            send(JSON.stringify({
                type: 'sqlcipher',
                timestamp: Date.now(),
                sub_type: 'SQLiteOpenHelper.getWritableDatabase(char[])' + returnValue.getPath(),
                value: toHexString(str)
            }));

            dumpDb(File, returnValue, returnValue.getPath());

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] net.sqlcipher.database.SQLiteOpenHelper.getWritableDatabase pinner not found');
        //console.log(err);
    }

    try {
        Java.use('net.sqlcipher.database.SQLiteOpenHelper').getReadableDatabase.overload('[B').implementation = function (bArr) {
            //console.log("net.sqlcipher.database.SQLiteOpenHelper.getReadableDatabase");
            //console.log("bArr: " + toHexString(bArr));

            // Return type: SQLiteDatabase
            const returnValue = this.getReadableDatabase.apply(this, arguments);
            //console.log('net.sqlcipher.database.SQLiteOpenHelper.getReadableDatabase return value: ' + returnValue);

            send(JSON.stringify({
                type: 'sqlcipher',
                timestamp: Date.now(),
                sub_type: 'SQLiteOpenHelper.getReadableDatabase(byte[])' + returnValue.getPath(),
                value: toHexString(str)
            }));
            
            dumpDb(File, returnValue, returnValue.getPath());

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] net.sqlcipher.database.SQLiteOpenHelper.getReadableDatabase pinner not found');
        //console.log(err);
    }

    try {
        Java.use('net.sqlcipher.database.SQLiteOpenHelper').getWritableDatabase.overload('[B').implementation = function (bArr) {
            //console.log("net.sqlcipher.database.SQLiteOpenHelper.getWritableDatabase");
            //console.log("bArr: " + toHexString(bArr));

            // Return type: SQLiteDatabase
            const returnValue = this.getWritableDatabase.apply(this, arguments);
            //console.log('net.sqlcipher.database.SQLiteOpenHelper.getWritableDatabase return value: ' + returnValue);

            send(JSON.stringify({
                type: 'sqlcipher',
                timestamp: Date.now(),
                sub_type: 'SQLiteOpenHelper.getWritableDatabase(byte[]) ' + returnValue.getPath(),
                value: toHexString(bArr)
            }));

            dumpDb(File, returnValue, returnValue.getPath());

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] net.sqlcipher.database.SQLiteOpenHelper.getWritableDatabase pinner not found');
        //console.log(err);
    }

    send(JSON.stringify({
        type: 'internal',
        timestamp: Date.now(),
        sub_type: 'scriptLoaded',
        value: 'observer_sqlcipher.js'
    }));

});
