// Source: https://codeshare.frida.re/@leolashkevych/android-deep-link-observer/

Java.perform(function() {
    var Intent = Java.use("android.content.Intent");
    Intent.getData.implementation = function() {
        var action = this.getAction() !== null ? this.getAction().toString() : false;
        if (action) {
            let resultValue = '';
            resultValue += "[*] Intent.getData() was called\n";
            resultValue += "[*] Activity: " + this.getComponent().getClassName() + "\n";
            resultValue += "[*] Action: " + action + "\n";
            var uri = this.getData();
            if (uri !== null) {
                resultValue += "\n[*] Data\n";
                uri.getScheme() && (resultValue += "- Scheme:\t" + uri.getScheme() + "://\n");
                uri.getHost() && (resultValue += "- Host:\t\t/" + uri.getHost() + "\n");
                uri.getQuery() && (resultValue += "- Params:\t" + uri.getQuery() + "\n");
                uri.getFragment() && (resultValue += "- Fragment:\t" + uri.getFragment() + "\n");
            } else {
                resultValue += "[-] No data supplied.";
            }
            send(JSON.stringify({
                type: 'deepLink',
                timestamp: Date.now(),
                sub_type: 'action',
                value: resultValue
            }));
        }
        return this.getData();
    }

    send(JSON.stringify({
        type: 'internal',
        timestamp: Date.now(),
        sub_type: 'scriptLoaded',
        value: 'observer_deep_link.js'
    }));
});