// node hostMulti.js -l /d/frida_scripts/fridaScript.js -U -f com.ercom.cryptobox.release
// node hostMulti.js -l /d/projets/FridaScripts/bypass_root.js -l /d/projets/FridaScripts/bypass_ssl_pinning.js -U -f com.saloncentric.app
// node hostMulti.js -l /d/projets/FridaScripts/bypass_ssl_pinning.js -U -f com.saloncentric.app
// node hostMulti.js -l /d/projets/FridaScripts/bypass_ssl_pinning.js -l /d/projets/FridaScripts/bypass_root.js -U -f com.saloncentric.app

const frida = require('frida');
const { Command } = require('commander');
const program = new Command();
var treeify = require('treeify');


// Setting the version of your CLI tool
program.version('1.0.0');


function collect(value, previous) {
    return previous.concat([value]);
}

// Defining options
program
    .requiredOption('-f, --target <string>', 'specify the target package')
    .option('-l, --scriptList <value>', 'script to launch', collect, [])
    .option('-U, --useUSBDevice', 'use usb device')

// Parse the command line arguments
program.parse(process.argv);

// If no command is given, display help
if (!process.argv.slice(2).length) {
    program.outputHelp();
}

// Accessing the parsed options
const options = program.opts();

if (options.target) {
    console.log(`The target is ${options.target}.`);
}

if (options.scriptList.length > 0) console.log(options.scriptList);

if (options.useUSBDevice) {
    console.log(`Use USB device.`);
} else {
    console.log(`Use REMOTE device.`);
}


let messagesTree = {}; 

async function main(target, scripts) {
    const targetApp = target; // 'com.example.myapp'; // Replace with your target app's package name

    try {
        // Handle the -U parameter
        //const device = await options.useUSBDevice ? frida.getUsbDevice() : frida.getRemoteDevice();
        const device = await frida.getUsbDevice();
        console.log(`Device used: ${device.name}`);
        const pid = await device.spawn([targetApp]);
        console.log(`PID found: ${pid}`);
        const session = await device.attach(pid);
        console.log(`Session attached to the PID.`);

        //const scripts = ['script1.js', 'script2.js']; // Add your script files here
        let concatenatedScript = '';

        for (const scriptFile of scripts) {
            //await loadScript(session, scriptFile);
            //await loadScript(session, scriptFile);
            
            const scriptCode = await readScriptFile(scriptFile);
            concatenatedScript += scriptCode + '\n';

            /*
            const script = await session.createScript(scriptCode);
            script.message.connect(onMessage);
            await script.load();
            console.log(`Script ${scriptFile} ${script}`);
            */
        }

        console.log(`Script concatenation done.`);

        const script = await session.createScript(concatenatedScript);
        script.message.connect(onMessage);
        await script.load();
        //console.log(`Script ${scriptFile} ${script}`);
        console.log('Scripts loaded. Resuming application...');
        
        await device.resume(pid);
        console.log('Resumed');

    } catch (error) {
        console.error(`Error: ${error.message}`);
    }
}

async function loadScript(session, scriptFile) {
    
    console.log(`Script loading ${scriptFile}`);

    const scriptCode = await readScriptFile(scriptFile);
    const script = await session.createScript(scriptCode);
    script.message.connect(onMessage);
    await script.load();
    console.log(`Script loaded ${scriptFile}`);   
    
    await new Promise((resolve) => {
        script.message.connect(function onScriptLoaded(message) {
            //console.log(`Message payload ${message.payload}`);

            var filename = scriptFile.replace(/^.*[\\/]/, '')
            const obj = JSON.parse(message.payload);

            if (message.type === 'send' && obj.type === 'scriptLoaded' && obj.script === filename) {
                //console.log(`${scriptFile} loaded.`);
                script.message.disconnect(onScriptLoaded); // Disconnect this handler
                resolve();
            }
        });
    });
}

function onMessage(message, data) {
    if (message.type === 'send') {
        //console.log(`Received message: ${message.payload}`);

        const obj = JSON.parse(message.payload);
        
        //console.log(`Type: ${obj.type}, SubType: ${obj.sub_type}, Value: ${obj.value}`);
        handleMessage(obj);

    } else if (message.type === 'error') {
        console.error(`Error: ${message.stack}`);
    }
}

function handleMessage(jsonMessage){
    
    if(!messagesTree.hasOwnProperty(jsonMessage.type)){
        //console.log(`Missing key ${jsonMessage.type}`)
        messagesTree[jsonMessage.type] = {};
    }

    if(!messagesTree[jsonMessage.type].hasOwnProperty(jsonMessage.sub_type)){
        //console.log(`Missing key ${jsonMessage.sub_type}`)
        messagesTree[jsonMessage.type][jsonMessage.sub_type] = {};
    }
    
    if(!messagesTree[jsonMessage.type][jsonMessage.sub_type].hasOwnProperty(jsonMessage.value)){
        //console.log(`Missing key ${jsonMessage.value}`)
        messagesTree[jsonMessage.type][jsonMessage.sub_type][jsonMessage.value] = 0;
    }
    
    messagesTree[jsonMessage.type][jsonMessage.sub_type][jsonMessage.value] = messagesTree[jsonMessage.type][jsonMessage.sub_type][jsonMessage.value] + 1;
    console.log(treeify.asTree(messagesTree, true));
}

async function readScriptFile(filename) {
    const fs = require('fs').promises;
    try {
        const data = await fs.readFile(filename, 'utf8');
        return data;
    } catch (error) {
        console.error(`Error reading script file: ${error}`);
        process.exit(1);
    }
}

main(options.target, options.scriptList).catch(error => {
    console.error(error);
    process.exit(1);
});
