/*  Android TODO: Describe
	by Tristan SALAUN
	
	Run with:
	frida -U -f [APP_ID] -l NAME_OF_THE_SCRIPT.js --no-pause
*/

 function toHexString(byteArray) {
	// var byteArrayTruncated = Array.from(byteArray).slice(255);
	return '(' + byteArray.length + ')' + '[0x' + Array.from(byteArray, function(byte) {
		return ('0' + (byte & 0xFF).toString(16)).slice(-2);
	}).join(' ') + ']'
}
function toAsciiString(byteArray) {
    return "";
	/*return Array.from(byteArray, function(byte) {
		return String.fromCharCode(byte);
	}).join('')
	*/
    /*
	var result = [];
	
    for (var i = 0; i < Math.min(byteArray.length, 255); ++i) {
        result.push(String.fromCharCode( // hex2ascii part
            parseInt(
                ('0' + (byteArray[i] & 0xFF).toString(16)).slice(-2), // binary2hex part
                16
            )
        ));
    }
    return result.join('');
    */
}


Java.perform(function() {
    //console.log('');
    //console.log('======');
    //console.log('[#] Hook of javax.crypto.Cipher [#]');
    //console.log('======');
    
    Java.use('javax.crypto.spec.SecretKeySpec').$init.overload('[B', 'java.lang.String').implementation = function(key, spec) {
        console.log("javax.crypto.spec.SecretKeySpec: KEY: " + toHexString(key) + " | " + toAsciiString(key));
        return this.$init(key, spec);
    };

    // **************************************************

    // ----- doFinal -----
    try {
        Java.use('javax.crypto.Cipher').doFinal.overload('java.nio.ByteBuffer', 'java.nio.ByteBuffer').implementation = function(arg0, arg1) {
            //console.log("javax.crypto.Cipher.doFinal " + this);
            //console.log("input: " + arg0);
            //console.log("output: " + arg1);
            // Return type: kotlin.Int
            const returnValue = this.doFinal.apply(this, arguments);
            //console.log('Cipher.doFinal return value: ' + returnValue);

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.doFinal output: ${arg0},\output: ${arg1}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.doFinal pinner not found');
        //console.log(err);
    }

    // ----- doFinal (1)-----
    try {
        Java.use('javax.crypto.Cipher').doFinal.overload('[B', 'int').implementation = function(arg0, arg1) {
            //console.log("javax.crypto.Cipher.doFinal (1)" + this);
            //console.log("output: " + toHexString(arg0) + " | " + toAsciiString(arg0));
            //console.log("outputOffset: " + arg1);
            // Return type: kotlin.Int
            const returnValue = this.doFinal.apply(this, arguments);
            //console.log('Cipher.doFinal (1) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.doFinal output: ${toHexString(arg0)},\outputOffset: ${arg1}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.doFinal pinner (1) not found');
        //console.log(err);
    }

    // ----- doFinal (2)-----
    try {
        Java.use('javax.crypto.Cipher').doFinal.overload('[B', 'int', 'int', '[B').implementation = function(arg0, arg1, arg2, arg3) {
            //console.log("javax.crypto.Cipher.doFinal (2)" + this);
            //console.log("input: " + toHexString(arg0) + " | " + toAsciiString(arg0));
            //console.log("inputOffset: " + arg1);
            //console.log("inputLen: " + arg2);
            //console.log("output: " + toHexString(arg3) + " | " + toAsciiString(arg3));
            // Return type: kotlin.Int
            const returnValue = this.doFinal.apply(this, arguments);
            //console.log('Cipher.doFinal (2) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.doFinal input: ${toHexString(arg0)},\ninputOffset: ${arg1}, inputLen: ${arg2}\noutput: ${toHexString(arg3)}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.doFinal pinner (2) not found');
        //console.log(err);
    }

    // ----- doFinal (3)-----
    try {
        Java.use('javax.crypto.Cipher').doFinal.overload('[B', 'int', 'int', '[B', 'int').implementation = function(arg0, arg1, arg2, arg3, arg4) {
            //console.log("javax.crypto.Cipher.doFinal (3)" + this);
            //console.log("input: " + toHexString(arg0) + " | " + toAsciiString(arg0));
            //console.log("inputOffset: " + arg1);
            //console.log("inputLen: " + arg2);
            //console.log("output: " + toHexString(arg3) + " | " + toAsciiString(arg3));
            //console.log("outputOffset: " + arg4);
            // Return type: kotlin.Int
            const returnValue = this.doFinal.apply(this, arguments);
            //console.log('Cipher.doFinal (3) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.doFinal input: ${toHexString(arg0)},\ninputOffset: ${arg1}, inputLen: ${arg2}\noutput: ${toHexString(arg3)}\noutputOffset: ${arg4}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.doFinal pinner (3) not found');
        //console.log(err);
    }

    // ----- doFinal (4)-----
    try {
        Java.use('javax.crypto.Cipher').doFinal.overload().implementation = function() {
            //console.log("javax.crypto.Cipher.doFinal (4)" + this);
            // Return type: kotlin.ByteArray!
            const returnValue = this.doFinal.apply(this, arguments);
            //console.log('Cipher.doFinal (4) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: 'javax.crypto.Cipher.doFinal'
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.doFinal pinner (4) not found');
        //console.log(err);
    }

    // ----- doFinal (5)-----
    try {
        Java.use('javax.crypto.Cipher').doFinal.overload('[B').implementation = function(arg0) {
            //console.log("javax.crypto.Cipher.doFinal (5)" + this);
            //console.log("input: " + toHexString(arg0) + " | " + toAsciiString(arg0));
            // Return type: kotlin.ByteArray!
            const returnValue = this.doFinal.apply(this, arguments);
            //console.log('Cipher.doFinal (5) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.doFinal input: ${toHexString(arg0)}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.doFinal pinner (5) not found');
        //console.log(err);
    }

    // ----- doFinal (6)-----
    try {
        Java.use('javax.crypto.Cipher').doFinal.overload('[B', 'int', 'int').implementation = function(arg0, arg1, arg2) {
            //console.log("javax.crypto.Cipher.doFinal (6)" + this);
            //console.log("input: " + toHexString(arg0) + " | " + toAsciiString(arg0));
            //console.log("inputOffset: " + arg1);
            //console.log("inputLen: " + arg2);
            // Return type: kotlin.ByteArray!
            const returnValue = this.doFinal.apply(this, arguments);
            //console.log('Cipher.doFinal (6) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.doFinal input: ${toHexString(arg0)},\ninputOffset: ${arg1}, inputLen: ${arg2}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.doFinal pinner (6) not found');
        //console.log(err);
    }

    // ----- update -----
    try {
        Java.use('javax.crypto.Cipher').update.overload('java.nio.ByteBuffer', 'java.nio.ByteBuffer').implementation = function(arg0, arg1) {
            //console.log("javax.crypto.Cipher.update" + this);
            //console.log("input: " + arg0);
            //console.log("output: " + arg1);
            // Return type: kotlin.Int
            const returnValue = this.update.apply(this, arguments);
            //console.log('Cipher.update return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.update input: ${arg0},\noutput: ${arg1}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.update pinner not found');
        //console.log(err);
    }

    // ----- update (1)-----
    try {
        Java.use('javax.crypto.Cipher').update.overload('[B', 'int', 'int', '[B').implementation = function(arg0, arg1, arg2, arg3) {
            //console.log("javax.crypto.Cipher.update (1)" + this);
            //console.log("input: " + toHexString(arg0) + " | " + toAsciiString(arg0));
            //console.log("inputOffset: " + arg1);
            //console.log("inputLen: " + arg2);
            //console.log("output: " + toHexString(arg3) + " | " + toAsciiString(arg3));
            // Return type: kotlin.Int
            const returnValue = this.update.apply(this, arguments);
            //console.log('Cipher.update (1) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.update input: ${toHexString(arg0)},\ninputOffset: ${arg1}, inputLen: ${arg2}\noutput: ${toHexString(arg3)}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.update pinner (1) not found');
        //console.log(err);
    }

    // ----- update (2)-----
    try {
        Java.use('javax.crypto.Cipher').update.overload('[B', 'int', 'int', '[B', 'int').implementation = function(arg0, arg1, arg2, arg3, arg4) {
            //console.log("javax.crypto.Cipher.update (2)" + this);
            //console.log("input: " + toHexString(arg0) + " | " + toAsciiString(arg0));
            //console.log("inputOffset: " + arg1);
            //console.log("inputLen: " + arg2);
            //console.log("output: " + toHexString(arg3) + " | " + toAsciiString(arg3));
            //console.log("outputOffset: " + arg4);
            // Return type: kotlin.Int
            const returnValue = this.update.apply(this, arguments);
            //console.log('Cipher.update (2) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.update input: ${toHexString(arg0)},\ninputOffset: ${arg1}, inputLen: ${arg2}\noutput: ${toHexString(arg3)}\noutputOffset: ${arg4}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.update pinner (2) not found');
        //console.log(err);
    }

    // ----- update (3)-----
    try {
        Java.use('javax.crypto.Cipher').update.overload('[B').implementation = function(arg0) {
            //console.log("javax.crypto.Cipher.update (3)" + this);
            //console.log("input: " + toHexString(arg0) + " | " + toAsciiString(arg0));
            // Return type: kotlin.ByteArray!
            const returnValue = this.update.apply(this, arguments);
            //console.log('Cipher.update (3) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.update input: ${toHexString(arg0)}`
            }));


            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.update pinner (3) not found');
        //console.log(err);
    }

    // ----- update (4)-----
    try {
        Java.use('javax.crypto.Cipher').update.overload('[B', 'int', 'int').implementation = function(arg0, arg1, arg2) {
            //console.log("javax.crypto.Cipher.update (4)" + this);
            //console.log("input: " + toHexString(arg0) + " | " + toAsciiString(arg0));
            //console.log("inputOffset: " + arg1);
            //console.log("inputLen: " + arg2);
            // Return type: kotlin.ByteArray!
            const returnValue = this.update.apply(this, arguments);
            //console.log('Cipher.update (4) return value: ' + toHexString(returnValue) + " | " + toAsciiString(returnValue));

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: this.toString(),
                value: `javax.crypto.Cipher.update input: ${toHexString(arg0)},\ninputOffset: ${arg1}, inputLen: ${arg2}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.update pinner (4) not found');
        //console.log(err);
    }


    // ----- getInstance -----
    try {
        Java.use('javax.crypto.Cipher').getInstance.overload('java.lang.String').implementation = function(arg0) {
            //console.log("javax.crypto.Cipher.getInstance" + this);
            //console.log("transformation: " + arg0);
            // Return type: javax.crypto.Cipher!
            const returnValue = this.getInstance.apply(this, arguments);
            //console.log('Cipher.getInstance return value: ' + returnValue);
            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: returnValue.toString(),
                value: `javax.crypto.Cipher.getInstance transformation: ${arg0}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.getInstance pinner not found');
        //console.log(err);
    }

    // ----- getInstance (1)-----
    try {
        Java.use('javax.crypto.Cipher').getInstance.overload('java.lang.String', 'java.lang.String').implementation = function(arg0, arg1) {
            //console.log("javax.crypto.Cipher.getInstance (1)" + this);
            //console.log("transformation: " + arg0);
            //console.log("provider: " + arg1);
            // Return type: javax.crypto.Cipher!
            const returnValue = this.getInstance.apply(this, arguments);
            //console.log('Cipher.getInstance (1) return value: ' + returnValue);

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: returnValue.toString(),
                value: `javax.crypto.Cipher.getInstance transformation: ${arg0}, provider: ${arg1}`
            }));

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.getInstance pinner (1) not found');
        //console.log(err);
    }

    // ----- getInstance (2)-----
    try {
        Java.use('javax.crypto.Cipher').getInstance.overload('java.lang.String', 'java.security.Provider').implementation = function(arg0, arg1) {
            //console.log("javax.crypto.Cipher.getInstance (2)" + this);
            //console.log("transformation: " + arg0);
            //console.log("provider: " + arg1.getInfo() );
            // Return type: javax.crypto.Cipher!
            const returnValue = this.getInstance.apply(this, arguments);
            //console.log('Cipher.getInstance (2) return value: ' + returnValue);

            send(JSON.stringify({
                type: 'cipher',
                timestamp: Date.now(),
                sub_type: returnValue.toString(),
                value: `javax.crypto.Cipher.getInstance transformation: ${arg0}, provider: ${arg1.getInfo()}`
            }));
            //`transformation: ${arg0}, provider: ${arg1.getInfo()}`

            return returnValue;
        };
    } catch (err) {
        //console.log('[-] javax.crypto.Cipher.getInstance pinner (2) not found');
        //console.log(err);
    }


    send(JSON.stringify({
        type: 'internal',
        timestamp: Date.now(),
        sub_type: 'scriptLoaded',
        value: 'cipher.js'
    }));

});