﻿	function get(name){
	   if(name=(new RegExp('[?&]'+encodeURIComponent(name)+'=([^&]*)')).exec(location.search))
	      return decodeURIComponent(name[1]);
	}

	var maxConnected = 0;
	var socket = io(serverNode).connect({transports: ['websocket']});

	var current_show_id = "";
	
	function sendActionColor(action){
	    var action = {
		    	show_id : current_show_id,
		        action: 'FC',
		        value: action,
	    };
	    socket.emit('action', action);
	}

	function sendActionBGColor(action){
	    var action = {
		    	show_id : current_show_id,
		        action: 'BGC',
		        value: action,
	    };
	    socket.emit('action', action);
	}	
	
	
	function sendActionImage(action){
		// Added to support IE
		action = action.replace(/['"]+/g, '');
	
	    var action = {
	    		show_id : current_show_id,
		        action: 'IMG',
		        value: action,
	    };
	    socket.emit('action', action);
	}
	
	function sendActionWatermark(action){
		// Added to support IE
		action = action.replace(/['"]+/g, '');
	
	    var action = {
	    		show_id : current_show_id,
		        action: 'WM',
		        value: action,
	    };
	    socket.emit('action', action);
	}
	
	function sendActionVideo(action){
	    var action = {
	    		show_id : current_show_id,
		        action: 'VIDEO',
		        value: action,
	    };
	    socket.emit('action', action);
	}

	function sendActionSound(action){
	    var action = {
	    		show_id : current_show_id,
		        action: 'PLAYSOUND',
		        value: action,
	    };
	    socket.emit('action', action);
	}
	function sendActionVolume(action){
	    var action = {
	    		show_id : current_show_id,
		        action: 'VOL',
		        value: action,
	    };
	    socket.emit('action', action);
	}
	function sendActionMatrix(paramx, paramy){
		var action = {
	    		show_id : current_show_id,
		        x: paramx,
		        y: paramy,
	    };
	    socket.emit('matrix', action);
		
	}
	function sendActionLogo(action){
	    var action = {
	    		show_id : current_show_id,
		        action: 'LOGO',
		        value: action,
	    };
	    socket.emit('action', action);
	}
	function sendActionLogoFlash(action){
	    var action = {
	    		show_id : current_show_id,
		        action: 'LOGOF',
		        value: action,
	    };
	    socket.emit('action', action);
	}
	function sendActionText(action){
	    var action = {
	    		show_id : current_show_id,
		        action: 'TEXT',
		        value: action,
	    };
	    socket.emit('action', action);
	}

	function sendActionTTS(action){
	    var action = {
	    		show_id : current_show_id,
		        action: 'TTS',
		        value: action,
	    };
	    socket.emit('action', action);
	}

	function sendActionTextTTS(actionValue){
		var jsonObj = {
				show_id : current_show_id,
				actionList: [
					{ type : "action", action: "TEXT", parameter: actionValue},
					{ type : "action", action: "TTS", parameter: actionValue}
				]
			};
		socket.emit('bulk', jsonObj);
		return false;
	}
	
	function sendActionUrl(action){
	    var action = {
	    		show_id : current_show_id,
	    		action: 'URL',
	        	value: action,
	    };
	    socket.emit('action', action);
	}
	
	function sendActionHTML(action){
	    var action = {
	    		show_id : current_show_id,
	    		action: 'HTML',
	        	value: action,
	    };
	    socket.emit('action', action);
	}

	function sendActionBrightness(actionValue){
		var actionJson = {
				show_id : current_show_id,
				action: 'B',
				value: actionValue,
		};
		socket.emit('action', actionJson);
		return false;
	}

	function sendActionVibration(actionValue){
		var actionJson = {
				show_id : current_show_id,
				action: 'VIB',
				value: actionValue,
		};
		socket.emit('action', actionJson);
		return false;
	}

	function sendActionFlash(actionValue){
		var actionJson = {
				show_id : current_show_id,
				action: 'FLASH',
				value: actionValue,
		};
		socket.emit('action', actionJson);
		return false;
	}

	function sendActionAdvancedColor(actionValue){
		var actionJson = {
				show_id : current_show_id,
				action: 'AC',
				value: actionValue,
		};
		socket.emit('action', actionJson);
		return false;
	}
	
	function sendActionAdvancedSound(actionValue){
		var actionJson = {
				show_id : current_show_id,
				action: 'ASOUND',
				value: actionValue,
		};
		socket.emit('action', actionJson);
		return false;
	}
	
	function sendActionActionSoundColor(actionValue){
		var actionJson = {
				show_id : current_show_id,
				action: 'ASC',
				value: actionValue,
		};
		socket.emit('action', actionJson);
		return false;
	}

	function sendActionWave(action){
	    var action = {
	    		show_id : current_show_id,
		        action: 'WAVE',
		        value: action,
	    };
	    socket.emit('action', action);
	}
	
	function convert(integer) { 
	    var str = Number(integer).toString(16); 
	    return str.length == 1 ? "0" + str : str; 
	};
	
	function rgbToHex(rgb) {
	  var rgbvals = /rgb\((.+),(.+),(.+)\)/i.exec(rgb);
	  var rval = parseInt(rgbvals[1]);
	  var gval = parseInt(rgbvals[2]);
	  var bval = parseInt(rgbvals[3]);
	  return '#' + (
	    convert(rval) +
	    convert(gval) +
	    convert(bval)
	  ).toUpperCase();
	}

$(document).ready(function(){
	
	var actionUserType = {id: "admin", value: "admin" };
	socket.emit('user_type', actionUserType);
	
	// manage the show setted in GET request
	//socket.emit('show_id', get('show_id'));
	current_show_id = "light4events";
	if( get('show_id') ){
		current_show_id = get('show_id');
	}

	// LOAD THE PREVIEW
	$("#preview").html('<object width="100%" height="100%" data="http://'+ serverURL +'/live/?show_id='+current_show_id+'"/>');


// LIVE BUTTONS
	$("#triggerTextBtn").click(function () {
		if( $('#valueText').val().trim() ){
			sendActionText( $('#valueText').val());
		}
	});
	$('#valueText').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueText').val().trim() ){
			sendActionText( $('#valueText').val());
		}
		return false;
	  }
	});
	
	$("#triggerTTSBtn").click(function () {
		if( $('#valueText').val().trim() ){
			sendActionTTS( $('#valueText').val());
		}
	});
	$("#triggerTextTTSBtn").click(function () {
		if( $('#valueText').val().trim() ){
			sendActionTextTTS( $('#valueText').val());
		}
	});
	$("#triggerColorBtn").click(function () {
		if( $('#valueColor').val().trim() ){
			sendActionColor( $('#valueColor').val());
		}
	});
	$('#valueColor').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueColor').val().trim() ){
			sendActionColor( $('#valueColor').val());
		}
		return false;
	  }
	});
	
	$("#triggerImageBtn").click(function () {
		if( $('#valueImage').val().trim() ){
			sendActionImage( $('#valueImage').val());
		}
	});
	$('#valueImage').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueImage').val().trim() ){
			sendActionImage( $('#valueImage').val());
		}
		return false;
	  }
	});
	
	$("#triggerVolumeBtn").click(function () {
		if( $('#valueVolume').val().trim() ){
			sendActionVolume( $('#valueVolume').val());
		}
	});
	$('#valueVolume').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueVolume').val().trim() ){
			sendActionVolume( $('#valueVolume').val());
		}
		return false;
	  }
	});
	
	$("#triggerVideoBtn").click(function () {
		if( $('#valueVideo').val().trim() ){
			sendActionVideo( $('#valueVideo').val());
		}
	});
	$('#valueVideo').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueVideo').val().trim() ){
			sendActionVideo( $('#valueVideo').val());
		}
		return false;
	  }
	});
	
	$("#triggerSoundBtn").click(function () {
		if( $('#valueSound').val().trim() ){
			sendActionSound( $('#valueSound').val());
		}
	});
	$('#valueSound').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueSound').val().trim() ){
			sendActionSound( $('#valueSound').val());
		}
		return false;
	  }
	});
	
	$("#triggerURLBtn").click(function () {
		if( $('#valueURL').val().trim() ){
			sendActionUrl( $('#valueURL').val());
		}
	});
	$('#valueURL').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueURL').val().trim() ){
			sendActionUrl( $('#valueURL').val());
		}
		return false;
	  }
	});
	
	$("#triggerHTMLBtn").click(function () {
		if( $('#valueHTML').val().trim() ){
			sendActionHTML( $('#valueHTML').val());
		}
	});
	$('#valueHTML').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueHTML').val().trim() ){
			sendActionHTML( $('#valueHTML').val());
		}
		return false;
	  }
	});
	
	$("#triggerBrightnessBtn").click(function () {
		if( $('#valueBrightness').val().trim() ){
			sendActionBrightness( $('#valueBrightness').val());
		}
	});
	$('#valueBrightness').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueBrightness').val().trim() ){
			sendActionBrightness( $('#valueBrightness').val());
		}
		return false;
	  }
	});
	
	$("#triggerVibrationBtn").click(function () {
		if( $('#valueVibration').val().trim() ){
			sendActionVibration( $('#valueVibration').val());
		}
	});
	$('#valueVibration').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueVibration').val().trim() ){
			sendActionVibration( $('#valueVibration').val());
		}
		return false;
	  }
	});
	
	$("#triggerFlashBtn").click(function () {
		if( $('#valueFlash').val().trim() ){
			sendActionFlash( $('#valueFlash').val());
		}
	});
	$('#valueFlash').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueFlash').val().trim() ){
			sendActionFlash( $('#valueFlash').val());
		}
		return false;
	  }
	});
	
	$("#triggerAdvancedColorBtn").click(function () {
		if( $('#valueAdvancedColor').val().trim() ){
			sendActionAdvancedColor( $('#valueAdvancedColor').val());
		}
	});
	$('#valueAdvancedColor').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueAdvancedColor').val().trim() ){
			sendActionAdvancedColor( $('#valueAdvancedColor').val());
		}
		return false;
	  }
	});
	
	$("#triggerAdvancedSoundBtn").click(function () {
		if( $('#valueAdvancedSound').val().trim() ){
			sendActionAdvancedSound( $('#valueAdvancedSound').val());
		}
	});
	$('#valueAdvancedSound').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueAdvancedSound').val().trim() ){
			sendActionAdvancedSound( $('#valueAdvancedSound').val());
		}
		return false;
	  }
	});
	
	$("#triggerSoundActionBtn").click(function () {
		if( $('#valueSoundActionColor1').val().trim() && $('#valueSoundActionColor2').val().trim() ){
			sendActionActionSoundColor( $('#valueSoundActionColor1').val().trim() + ',' + $('#valueSoundActionColor2').val().trim() );
		}
	});
	$('#valueSoundActionColor1').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueSoundActionColor2').focus().select();
		return false;
	  }
	});
	$('#valueSoundActionColor2').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueSoundActionColor1').val().trim() && $('#valueSoundActionColor2').val().trim() ){
			sendActionActionSoundColor( $('#valueSoundActionColor1').val().trim() + ',' + $('#valueSoundActionColor2').val().trim() );
		}
		return false;
	  }
	});
	
	$("#triggerMatrixBtn").click(function () {
		if( $('#valueMatrixWidth').val().trim() && $('#valueMatrixHeight').val().trim() ){
			sendActionMatrix( parseInt($('#valueMatrixWidth').val().trim()),parseInt($('#valueMatrixHeight').val().trim()) );
		}
	});

	
	$("#triggerLogoBtn").click(function () {
		if( $('#valueLogoUrl').val().trim() && $('#valueLogoWidth').val().trim() && $('#valueLogoHeight').val().trim() && $('#valueLogoDefaultColor').val().trim()){
			sendActionLogo( $('#valueLogoUrl').val().trim() + ',' + $('#valueLogoWidth').val().trim() + ',' + $('#valueLogoHeight').val().trim() + ',' + $('#valueLogoDefaultColor').val().trim() );
		}
	});
	$('#valueLogoUrl').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueLogoWidth').focus().select();
		return false;
	  }
	});
	$('#valueLogoWidth').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueLogoHeight').focus().select();
		return false;
	  }
	});
	$('#valueLogoHeight').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueLogoDefaultColor').focus().select();
		return false;
	  }
	});
	$('#valueLogoDefaultColor').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueLogoUrl').val().trim() && $('#valueLogoWidth').val().trim() && $('#valueLogoHeight').val().trim() && $('#valueLogoDefaultColor').val().trim()){
			sendActionLogo( $('#valueLogoUrl').val().trim() + ',' + $('#valueLogoWidth').val().trim() + ',' + $('#valueLogoHeight').val().trim() + ',' + $('#valueLogoDefaultColor').val().trim() );
		}
		return false;
	  }
	});
	
	
	$("#triggerLogoFlashBtn").click(function () {
		if( $('#valueLogoFlashUrl').val().trim() && $('#valueLogoFlashWidth').val().trim() && $('#valueLogoFlashHeight').val().trim() && $('#valueLogoFlashDefaultFlash').val().trim()){
			sendActionLogoFlash( $('#valueLogoFlashUrl').val().trim() + ',' + $('#valueLogoFlashWidth').val().trim() + ',' + $('#valueLogoFlashHeight').val().trim() + ',' + $('#valueLogoFlashDefaultFlash').val().trim() );
		}
	});
	$('#valueLogoFlashUrl').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueLogoFlashWidth').focus().select();
		return false;
	  }
	});
	$('#valueLogoFlashWidth').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueLogoFlashHeight').focus().select();
		return false;
	  }
	});
	$('#valueLogoFlashHeight').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueLogoFlashDefaultFlash').focus().select();
		return false;
	  }
	});
	$('#valueLogoFlashDefaultFlash').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueLogoFlashUrl').val().trim() && $('#valueLogoFlashWidth').val().trim() && $('#valueLogoFlashHeight').val().trim() && $('#valueLogoFlashDefaultFlash').val().trim()){
			sendActionLogoFlash( $('#valueLogoFlashUrl').val().trim() + ',' + $('#valueLogoFlashWidth').val().trim() + ',' + $('#valueLogoFlashHeight').val().trim() + ',' + $('#valueLogoFlashDefaultFlash').val().trim() );
		}
		return false;
	  }
	});
	
	
	$("#triggerWaveBtn").click(function () {
		if( $('#valueWavOnTime').val().trim() && $('#valueWavDelayX').val().trim() && $('#valueWavDelayY').val().trim() && $('#valueWavMode').val().trim() && $('#valueWavColorOff').val().trim() && $('#valueWavColorOn').val().trim()){
			sendActionWave( $('#valueWavOnTime').val().trim() + ',' + $('#valueWavDelayX').val().trim() + ',' + $('#valueWavDelayY').val().trim() + ',' + $('#valueWavMode').val().trim() + ',' + $('#valueWavColorOff').val().trim() + ',' + $('#valueWavColorOn').val().trim() );
		}
	});
	$('#valueWavOnTime').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueWavDelayX').focus().select();
		return false;
	  }
	});
	$('#valueWavDelayX').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueWavDelayY').focus().select();
		return false;
	  }
	});
	$('#valueWavDelayY').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueWavMode').focus().select();
		return false;
	  }
	});
	$('#valueWavMode').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueWavColorOff').focus().select();
		return false;
	  }
	});
	$('#valueWavColorOff').keypress(function (e) {
	  if (e.which == 13) {
		$('#valueWavColorOn').focus().select();
		return false;
	  }
	});
	$('#valueWavColorOn').keypress(function (e) {
	  if (e.which == 13) {
		if( $('#valueWavOnTime').val().trim() && $('#valueWavDelayX').val().trim() && $('#valueWavDelayY').val().trim() && $('#valueWavMode').val().trim() && $('#valueWavColorOff').val().trim() && $('#valueWavColorOn').val().trim()){
			sendActionWave( $('#valueWavOnTime').val().trim() + ',' + $('#valueWavDelayX').val().trim() + ',' + $('#valueWavDelayY').val().trim() + ',' + $('#valueWavMode').val().trim() + ',' + $('#valueWavColorOff').val().trim() + ',' + $('#valueWavColorOn').val().trim() );
		}
		return false;
	  }
	});

	
	// Push notification
	$("#triggerPushBtn").click(function () {
		if( $('#pushTitle').val().trim() && $('#pushDescription').val().trim() ){
			
			$.get( "push_notification.php?title="+$('#pushTitle').val().trim()+"&desc="+$('#pushDescription').val().trim(), function( data ) {
			  alert( data);
			});
		}
	});
			
// END LIVE BUTTONS

$(".ItemAction").click(function(){

    var url = $(this).css('background-image');
    if(url && url != 'none'){
        url = url.substring(4, url.length-1);
        sendActionImage(url);
    }else{
	
	    var bgValue = $(this).css('backgroundColor');
		if(undefined != bgValue){
			var bgcol = rgbToHex(bgValue);
			sendActionColor(bgcol);
		}
	}
    return false;
});


$(".ItemBackGroundColor").click(function(){
	var bgValue = $(this).css('backgroundColor');
	if(undefined != bgValue){
		var bgcol = rgbToHex(bgValue);
		sendActionBGColor(bgcol);
	}
    return false;
});


$(".ItemActionText").click(function(){
    var textValue = $(this).html();

    if(undefined != textValue){
        sendActionText(textValue);
    }
    return false;
});

$(".ItemActionTextTTS").click(function(){
    var textValue = $(this).html();

    if(undefined != textValue){
        sendActionTextTTS(textValue);
    }
    return false;
});

$(".ItemActionURL").click(function(){
    var textValue = $(this).data('code'); // .getElementById('frame').src

    if(undefined != textValue){
        sendActionUrl(textValue);
    }
    return false;
});

$(".ItemActionHTML").click(function(){
    var textValue = $(this).html();

    if(undefined != textValue){
        sendActionHTML(textValue);
    }
    return false;
});

$(".ItemWaterMark").click(function(){
    var url = $(this).css('background-image');
    if(url && url != 'none'){
        url = url.substring(4, url.length-1);
        sendActionWatermark(url);
    }
    return false;
});

$(".ItemLogo").click(function(){

    var url = $(this).css('background-image');
    if(url && url != 'none'){
        url = url.substring(4, url.length-1);
        
        url = url.replace(/['"]+/g, '');

        sendActionLogo(url+",3,3,#000000");
    }
    return false;
});

$(".ItemLogoFlash").click(function(){

    var url = $(this).css('background-image');
    if(url && url != 'none'){
        url = url.substring(4, url.length-1);
        
        url = url.replace(/['"]+/g, '');

        sendActionLogoFlash(url+",3,3,#000000");
    }
    return false;
});


$(".ItemSound").click(function(){

    var url = $(this).data( "url" );

    if(url && url != 'none'){
	    var action = {
	    		show_id : current_show_id,
		        action: 'PLAYSOUND',
		        value: url,
	    };
	    socket.emit('action', action);
    }
    
    return false;
});

$(".ItemVideo").click(function(){
	var url = $(this).data( "url" );

    if(url && url != 'none'){
    	sendActionVideo(url);
    }

		return false;
});

$("#reset").click(function(){
		sendActionImage("");
	return false;
});



// ##################################################
// # TESTS
// ##################################################
$("#question_dissmiss").click(function(){
        var questionRequest = {
        	show_id : current_show_id,
			options: []
        };
        socket.emit('question', questionRequest);
        return false;
    });

$("#question_no_title").click(function(){

	var questionOption1 = {title: "Choix 1", value:"c1"};
	var questionOption2 = {title: "Choix 2", value:"c2"};
	var questionOption3 = {title: "Choix 3", value:"c3"};
	var questionOption4 = {title: "Choix 4", value:"c4"};

	var questionOptionsList = [questionOption1, questionOption2, questionOption3, questionOption4];

	var questionRequest = {
		show_id : current_show_id,
		id : "choix",
		//title: "Quel est votre genre ?",
		options: questionOptionsList
	};
	socket.emit('question', questionRequest);
	return false;
});
	
$("#question_no_items").click(function(){
	
	var questionRequest = {
		show_id : current_show_id,
		id : "dialog",
		title: "Juste un titre sans choix !",
		options: []
	};
	socket.emit('question', questionRequest);
	return false;
});
	question_no_items


$("#test1").click(function(){
	var d = new Date();
	var pingRequest = {
		client: d.getTime()
	};
	socket.emit('ping', pingRequest);
	return false;
});

$("#test2").click(function(){
	var d = new Date();
	var startRequest = {
		delay: 10
	};
	socket.emit('start_delay', startRequest);
	return false;
});

$("#test3").click(function(){
	socket.emit('get_start', "");
	return false;
});

$("#test4").click(function(){

	var questionOptionHomme = {title: "Homme", value:"h"};
	var questionOptionFemme = {title: "Femme", value:"f"};

	var questionOptionsList = [questionOptionHomme, questionOptionFemme];

	var questionRequest = {
		show_id : current_show_id,
		id : "genre",
		title: "Quel est votre genre ?",
		options: questionOptionsList
	};
	socket.emit('question', questionRequest);
	return false;
});

 $("#test5").click(function(){

	var actionDiffH = {
		action: 'FC',
		value: "#3299D4",
	};
	var actionDiffF = {
		action: 'FC',
		value: "#F0569F",
	};

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'h', command: 'action', valueCommand: actionDiffH}, {value: 'f',  command: 'action', valueCommand: actionDiffF} ]
			};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#test6").click(function(){

	var actionDiffH = {
		action: 'FC',
		value: "#FD7720",
	};
	var actionDiffF = {
		action: 'FC',
		value: "#B0BA3D",
	};

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'h', command: 'action', valueCommand: actionDiffH}, {value: 'f',  command: 'action', valueCommand: actionDiffF} ]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#test7").click(function(){

	var actionDiffH = {
		action: 'FC',
		value: "#B0BA3D",
	};
	var actionDiffF = {
		action: 'FC',
		value: "#FD7720",
	};

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'h', command: 'action', valueCommand: actionDiffH}, {value: 'f',  command: 'action', valueCommand: actionDiffF} ]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#action_diff_hf_sexy").click(function(){

	var actionDiffH = {
		action: 'IMG',
		value: "http://tristan-salaun.com/l4e/content/imgs/sexy-lady.jpg",
	};
	var actionDiffF = {
		action: 'IMG',
		value: "http://tristan-salaun.com/l4e/content/imgs/sexy-man.jpg",
	};

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'h', command: 'action', valueCommand: actionDiffH}, {value: 'f',  command: 'action', valueCommand: actionDiffF} ]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});


// ##################################################
// # TESTS Diff Droite / Gauche
// ##################################################
$("#droite_gauche1").click(function(){
        var questionRequest = {
        	show_id : current_show_id,
			id : "side",
            title: "Etes vous à droite, ou à gauche ?",
            options: [
                {title: "Droite", value:"d"},
                {title: "Gauche", value:"g"},
            ]
        };
        socket.emit('question', questionRequest);
        return false;
    });

$("#droite_gauche2").click(function(){

        var actionDiffMessage = {
    			show_id : current_show_id,
    			actionDiff : [
            {value: 'd', command: 'action', valueCommand: { action: 'FC', value: "#FFFFFF"}},
            {value: 'g', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            ]
        };
			
        socket.emit('action_diff', actionDiffMessage);

        return false;
    });

$("#droite_gauche3").click(function(){

        var actionDiffMessage = {
    			show_id : current_show_id,
    			actionDiff : [
            {value: 'd', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: 'g', command: 'action', valueCommand: { action: 'FC', value: "#FFFFFF"}},
            ]
        };

        socket.emit('action_diff', actionDiffMessage);

        return false;
    });

$("#droite_gauche4").click(function(){

        var actionDiffMessage = {
    			show_id : current_show_id,
    			actionDiff : [
            {value: 'd', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}},
            {value: 'g', command: 'action', valueCommand: { action: 'FC', value: "#0000FF"}},
            ]
        };

        socket.emit('action_diff', actionDiffMessage);

        return false;
    });

$("#droite_gauche5").click(function(){

        var actionDiffMessage = {
    			show_id : current_show_id,
    			actionDiff : [
            {value: 'd', command: 'action', valueCommand: { action: 'FC', value: "#0000FF"}},
            {value: 'g', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}},
            ]
        };

        socket.emit('action_diff', actionDiffMessage);

        return false;
    });

// ##################################################
// # TESTS Diff 2
// ##################################################

$("#degrade1").click(function(){
        var questionRequest = {
        	show_id : current_show_id,
			id : "zone_test",
            title: "Dans quelle zone vous trouvez vous ?",
            options: [
                {title: "Zone 1", value:"1"},
                {title: "Zone 2", value:"2"},
                {title: "Zone 3", value:"3"},
                {title: "Zone 4", value:"4"},
                {title: "Zone 5", value:"5"},
            ]
        };
        socket.emit('question', questionRequest);
        return false;
    });


$("#degrade2").click(function(){

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [
		{value: '1', command: 'action', valueCommand: { action: 'FC', value: "#ff0000"}},
		{value: '2', command: 'action', valueCommand: { action: 'FC', value: "#c60000"}},
		{value: '3', command: 'action', valueCommand: { action: 'FC', value: "#8b0000"}},
		{value: '4', command: 'action', valueCommand: { action: 'FC', value: "#580000"}},
		{value: '5', command: 'action', valueCommand: { action: 'FC', value: "#1f0000"}},
		]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});


$("#degrade3").click(function(){

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [
		{value: '1', command: 'action', valueCommand: { action: 'FC', value: "#00ff42"}},
		{value: '2', command: 'action', valueCommand: { action: 'FC', value: "#00eaff"}},
		{value: '3', command: 'action', valueCommand: { action: 'FC', value: "#2400ff"}},
		{value: '4', command: 'action', valueCommand: { action: 'FC', value: "#ff00e4"}},
		{value: '5', command: 'action', valueCommand: { action: 'FC', value: "#ff0000"}},
		]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#degrade4").click(function(){

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [
		{value: '1', command: 'action', valueCommand: { action: 'FC', value: "#2DBB3E"}},
		{value: '2', command: 'action', valueCommand: { action: 'FC', value: "#258A93"}},
		{value: '3', command: 'action', valueCommand: { action: 'FC', value: "#F2913A"}},
		{value: '4', command: 'action', valueCommand: { action: 'FC', value: "#F2433A"}},
		{value: '5', command: 'action', valueCommand: { action: 'FC', value: "#FFFFFF"}},
		]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#degrade5").click(function(){

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [
		{value: '1', command: 'action', valueCommand: { action: 'FC', value: "#0000ff"}},
		{value: '2', command: 'action', valueCommand: { action: 'FC', value: "#4141ff"}},
		{value: '3', command: 'action', valueCommand: { action: 'FC', value: "#7171ff"}},
		{value: '4', command: 'action', valueCommand: { action: 'FC', value: "#b3b3ff"}},
		{value: '5', command: 'action', valueCommand: { action: 'FC', value: "#e8e8ff"}},
		]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});


$("#chenille1").click(function(){

        var actionDiffMessage = {
    			show_id : current_show_id,
    			actionDiff : [
            {value: '1', command: 'action', valueCommand: { action: 'FC', value: "#0000FF"}},
            {value: '2', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '3', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '4', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '5', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            ]
        };

        socket.emit('action_diff', actionDiffMessage);

        return false;
    });

$("#chenille2").click(function(){

        var actionDiffMessage = {
    			show_id : current_show_id,
    			actionDiff : [
            {value: '1', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '2', command: 'action', valueCommand: { action: 'FC', value: "#0000FF"}},
            {value: '3', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '4', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '5', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            ]
        };

        socket.emit('action_diff', actionDiffMessage);

        return false;
    });

$("#chenille3").click(function(){

        var actionDiffMessage = {
    			show_id : current_show_id,
    			actionDiff : [
            {value: '1', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '2', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '3', command: 'action', valueCommand: { action: 'FC', value: "#0000FF"}},
            {value: '4', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '5', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            ]
        };

        socket.emit('action_diff', actionDiffMessage);

        return false;
    });

$("#chenille4").click(function(){

        var actionDiffMessage = {
    			show_id : current_show_id,
    			actionDiff : [
            {value: '1', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '2', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '3', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '4', command: 'action', valueCommand: { action: 'FC', value: "#0000FF"}},
            {value: '5', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            ]
        };

        socket.emit('action_diff', actionDiffMessage);

        return false;
    });

$("#chenille5").click(function(){

        var actionDiffMessage = {
    			show_id : current_show_id,
    			actionDiff : [
            {value: '1', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '2', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '3', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '4', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},
            {value: '5', command: 'action', valueCommand: { action: 'FC', value: "#0000FF"}},
            ]
        };

        socket.emit('action_diff', actionDiffMessage);

        return false;
    });

$("#chenillesequence").click(function(){
	var actionSequence1Message = {
		id: 4,
		title: "Chenille1",
		video: "",
		audio: "",
		actionTrackList: [
			{ timedActionList: [
				{ timestamp: 0, action: "FC", parameter: "#FFFFFF"},
				{ timestamp: 1000, action: "FC", parameter: "#000000"},
				{ timestamp: 2000, action: "FC", parameter: "#000000"},
				{ timestamp: 3000, action: "FC", parameter: "#000000"},
				{ timestamp: 4000, action: "FC", parameter: "#000000"},
				{ timestamp: 5000, action: "FC", parameter: "#000000"},
				{ timestamp: 6000, action: "FC", parameter: "#000000"},
				{ timestamp: 7000, action: "FC", parameter: "#000000"},
				{ timestamp: 8000, action: "FC", parameter: "#FFFFFF"},
				{ timestamp: 9000, action: "FC", parameter: "#000000"},
				{ timestamp: 10000, action: "FC", parameter: "#FF0000"},
				{ timestamp: 10500, action: "FC", parameter: "#000000"},
				{ timestamp: 11000, action: "FC", parameter: "#000000"},
				{ timestamp: 11500, action: "FC", parameter: "#000000"},
				{ timestamp: 12000, action: "FC", parameter: "#000000"},
				{ timestamp: 12500, action: "FC", parameter: "#000000"},
				{ timestamp: 13000, action: "FC", parameter: "#000000"},
				{ timestamp: 13500, action: "FC", parameter: "#000000"},
				{ timestamp: 14000, action: "FC", parameter: "#FF0000"},
				{ timestamp: 14500, action: "FC", parameter: "#000000"},
				{ timestamp: 15000, action: "FC", parameter: "#0000FF"},
				{ timestamp: 15200, action: "FC", parameter: "#000000"},
				{ timestamp: 15400, action: "FC", parameter: "#000000"},
				{ timestamp: 15600, action: "FC", parameter: "#000000"},
				{ timestamp: 15800, action: "FC", parameter: "#000000"},
				{ timestamp: 16000, action: "FC", parameter: "#000000"},
				{ timestamp: 16200, action: "FC", parameter: "#000000"},
				{ timestamp: 16400, action: "FC", parameter: "#000000"},
				{ timestamp: 16600, action: "FC", parameter: "#0000FF"},
				{ timestamp: 16800, action: "FC", parameter: "#000000"},
				]
			},
		]
	};
	var actionSequence2Message = {
		id: 4,
		title: "Chenille2",
		video: "",
		audio: "",
		actionTrackList: [
			{ timedActionList: [
				{ timestamp: 0, action: "FC", parameter: "#000000"},
				{ timestamp: 1000, action: "FC", parameter: "#FFFFFF"},
				{ timestamp: 2000, action: "FC", parameter: "#000000"},
				{ timestamp: 3000, action: "FC", parameter: "#000000"},
				{ timestamp: 4000, action: "FC", parameter: "#000000"},
				{ timestamp: 5000, action: "FC", parameter: "#000000"},
				{ timestamp: 6000, action: "FC", parameter: "#000000"},
				{ timestamp: 7000, action: "FC", parameter: "#FFFFFF"},
				{ timestamp: 8000, action: "FC", parameter: "#000000"},
				{ timestamp: 9000, action: "FC", parameter: "#000000"},
				{ timestamp: 10000, action: "FC", parameter: "#000000"},
				{ timestamp: 10500, action: "FC", parameter: "#FF0000"},
				{ timestamp: 11000, action: "FC", parameter: "#000000"},
				{ timestamp: 11500, action: "FC", parameter: "#000000"},
				{ timestamp: 12000, action: "FC", parameter: "#000000"},
				{ timestamp: 12500, action: "FC", parameter: "#000000"},
				{ timestamp: 13000, action: "FC", parameter: "#000000"},
				{ timestamp: 13500, action: "FC", parameter: "#FF0000"},
				{ timestamp: 14000, action: "FC", parameter: "#000000"},
				{ timestamp: 14500, action: "FC", parameter: "#000000"},
				{ timestamp: 15000, action: "FC", parameter: "#000000"},
				{ timestamp: 15200, action: "FC", parameter: "#0000FF"},
				{ timestamp: 15400, action: "FC", parameter: "#000000"},
				{ timestamp: 15600, action: "FC", parameter: "#000000"},
				{ timestamp: 15800, action: "FC", parameter: "#000000"},
				{ timestamp: 16000, action: "FC", parameter: "#000000"},
				{ timestamp: 16200, action: "FC", parameter: "#000000"},
				{ timestamp: 16400, action: "FC", parameter: "#0000FF"},
				{ timestamp: 16600, action: "FC", parameter: "#000000"},
				{ timestamp: 16800, action: "FC", parameter: "#000000"},
				]
			},
		]
	};
	var actionSequence3Message = {
		id: 4,
		title: "Chenille3",
		video: "",
		audio: "",
		actionTrackList: [
			{ timedActionList: [
				{ timestamp: 0, action: "FC", parameter: "#000000"},
				{ timestamp: 1000, action: "FC", parameter: "#000000"},
				{ timestamp: 2000, action: "FC", parameter: "#FFFFFF"},
				{ timestamp: 3000, action: "FC", parameter: "#000000"},
				{ timestamp: 4000, action: "FC", parameter: "#000000"},
				{ timestamp: 5000, action: "FC", parameter: "#000000"},
				{ timestamp: 6000, action: "FC", parameter: "#FFFFFF"},
				{ timestamp: 7000, action: "FC", parameter: "#000000"},
				{ timestamp: 8000, action: "FC", parameter: "#000000"},
				{ timestamp: 9000, action: "FC", parameter: "#000000"},
				{ timestamp: 10000, action: "FC", parameter: "#000000"},
				{ timestamp: 10500, action: "FC", parameter: "#000000"},
				{ timestamp: 11000, action: "FC", parameter: "#FF0000"},
				{ timestamp: 11500, action: "FC", parameter: "#000000"},
				{ timestamp: 12000, action: "FC", parameter: "#000000"},
				{ timestamp: 12500, action: "FC", parameter: "#000000"},
				{ timestamp: 13000, action: "FC", parameter: "#FF0000"},
				{ timestamp: 13500, action: "FC", parameter: "#000000"},
				{ timestamp: 14000, action: "FC", parameter: "#000000"},
				{ timestamp: 14500, action: "FC", parameter: "#000000"},
				{ timestamp: 15000, action: "FC", parameter: "#000000"},
				{ timestamp: 15200, action: "FC", parameter: "#000000"},
				{ timestamp: 15400, action: "FC", parameter: "#0000FF"},
				{ timestamp: 15600, action: "FC", parameter: "#000000"},
				{ timestamp: 15800, action: "FC", parameter: "#000000"},
				{ timestamp: 16000, action: "FC", parameter: "#000000"},
				{ timestamp: 16200, action: "FC", parameter: "#0000FF"},
				{ timestamp: 16400, action: "FC", parameter: "#000000"},
				{ timestamp: 16600, action: "FC", parameter: "#000000"},
				{ timestamp: 16800, action: "FC", parameter: "#000000"},
				]
			},
		]
	};
	var actionSequence4Message = {
		id: 4,
		title: "Chenille4",
		video: "",
		audio: "",
		actionTrackList: [
			{ timedActionList: [
				{ timestamp: 0, action: "FC", parameter: "#000000"},
				{ timestamp: 1000, action: "FC", parameter: "#000000"},
				{ timestamp: 2000, action: "FC", parameter: "#000000"},
				{ timestamp: 3000, action: "FC", parameter: "#FFFFFF"},
				{ timestamp: 4000, action: "FC", parameter: "#000000"},
				{ timestamp: 5000, action: "FC", parameter: "#FFFFFF"},
				{ timestamp: 6000, action: "FC", parameter: "#000000"},
				{ timestamp: 7000, action: "FC", parameter: "#000000"},
				{ timestamp: 8000, action: "FC", parameter: "#000000"},
				{ timestamp: 9000, action: "FC", parameter: "#000000"},
				{ timestamp: 10000, action: "FC", parameter: "#000000"},
				{ timestamp: 10500, action: "FC", parameter: "#000000"},
				{ timestamp: 11000, action: "FC", parameter: "#000000"},
				{ timestamp: 11500, action: "FC", parameter: "#FF0000"},
				{ timestamp: 12000, action: "FC", parameter: "#000000"},
				{ timestamp: 12500, action: "FC", parameter: "#FF0000"},
				{ timestamp: 13000, action: "FC", parameter: "#000000"},
				{ timestamp: 13500, action: "FC", parameter: "#000000"},
				{ timestamp: 14000, action: "FC", parameter: "#000000"},
				{ timestamp: 14500, action: "FC", parameter: "#000000"},
				{ timestamp: 15000, action: "FC", parameter: "#000000"},
				{ timestamp: 15200, action: "FC", parameter: "#000000"},
				{ timestamp: 15400, action: "FC", parameter: "#000000"},
				{ timestamp: 15600, action: "FC", parameter: "#0000FF"},
				{ timestamp: 15800, action: "FC", parameter: "#000000"},
				{ timestamp: 16000, action: "FC", parameter: "#0000FF"},
				{ timestamp: 16200, action: "FC", parameter: "#000000"},
				{ timestamp: 16400, action: "FC", parameter: "#000000"},
				{ timestamp: 16600, action: "FC", parameter: "#000000"},
				{ timestamp: 16800, action: "FC", parameter: "#000000"},
				]
			},
		]
	};
	var actionSequence5Message = {
		id: 4,
		title: "Chenille5",
		video: "",
		audio: "",
		actionTrackList: [
			{ timedActionList: [
				{ timestamp: 0, action: "FC", parameter: "#000000"},
				{ timestamp: 1000, action: "FC", parameter: "#000000"},
				{ timestamp: 2000, action: "FC", parameter: "#000000"},
				{ timestamp: 3000, action: "FC", parameter: "#000000"},
				{ timestamp: 4000, action: "FC", parameter: "#FFFFFF"},
				{ timestamp: 5000, action: "FC", parameter: "#000000"},
				{ timestamp: 6000, action: "FC", parameter: "#000000"},
				{ timestamp: 7000, action: "FC", parameter: "#000000"},
				{ timestamp: 8000, action: "FC", parameter: "#000000"},
				{ timestamp: 9000, action: "FC", parameter: "#000000"},
				{ timestamp: 10000, action: "FC", parameter: "#000000"},
				{ timestamp: 10500, action: "FC", parameter: "#000000"},
				{ timestamp: 11000, action: "FC", parameter: "#000000"},
				{ timestamp: 11500, action: "FC", parameter: "#000000"},
				{ timestamp: 12000, action: "FC", parameter: "#FF0000"},
				{ timestamp: 12500, action: "FC", parameter: "#000000"},
				{ timestamp: 13000, action: "FC", parameter: "#000000"},
				{ timestamp: 13500, action: "FC", parameter: "#000000"},
				{ timestamp: 14000, action: "FC", parameter: "#000000"},
				{ timestamp: 14500, action: "FC", parameter: "#000000"},
				{ timestamp: 15000, action: "FC", parameter: "#000000"},
				{ timestamp: 15200, action: "FC", parameter: "#000000"},
				{ timestamp: 15400, action: "FC", parameter: "#000000"},
				{ timestamp: 15600, action: "FC", parameter: "#000000"},
				{ timestamp: 15800, action: "FC", parameter: "#0000FF"},
				{ timestamp: 16000, action: "FC", parameter: "#000000"},
				{ timestamp: 16200, action: "FC", parameter: "#000000"},
				{ timestamp: 16400, action: "FC", parameter: "#000000"},
				{ timestamp: 16600, action: "FC", parameter: "#000000"},
				{ timestamp: 16800, action: "FC", parameter: "#000000"},
				]
			},
		]
	};
	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [
		{value: '1', command: 'loading', valueCommand: actionSequence1Message},
		{value: '2', command: 'loading', valueCommand: actionSequence2Message},
		{value: '3', command: 'loading', valueCommand: actionSequence3Message},
		{value: '4', command: 'loading', valueCommand: actionSequence4Message},
		{value: '5', command: 'loading', valueCommand: actionSequence5Message},
		]
	};
		
	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#chenillesequencego").click(function(){
	var startRequest = {
		show_id : current_show_id,
		delay: 10,
		sequence_id: 4
	};

	socket.emit('start_delay', startRequest);
	return false;
});

// ##################################################
// # Anooki
// ##################################################
	
$("#sequence2").click(function(){

	var actionSequenceMessage = {
		show_id : current_show_id,
		id: 1,
		title: "Anooki",
		video: "http://tristan-salaun.com/l4e/anooki_nakina.mp4",
		audio: "",
		actionTrackList: [
			{ timedActionList: [
				{ timestamp: 0, action: "FC", parameter: "#DA5701"},
				{ timestamp: 12370, action: "FC", parameter: "#CE000D"},
				{ timestamp: 17430, action: "FC", parameter: "#DA1DD1"},
				{ timestamp: 22370, action: "FC", parameter: "#803FE4"},
				{ timestamp: 27330, action: "FC", parameter: "#1782D4"},
				{ timestamp: 32300, action: "FC", parameter: "#57A600"},
				{ timestamp: 37330, action: "FC", parameter: "#D58B00"},
				{ timestamp: 42300, action: "FC", parameter: "#DA5700"},
				{ timestamp: 51830, action: "FC", parameter: "#CE000D"},
				{ timestamp: 57370, action: "FC", parameter: "#DA1DCA"},
				{ timestamp: 60270, action: "FC", parameter: "#1782D4"},
				{ timestamp: 66760, action: "FC", parameter: "#000000"},
				]
			},
			{ timedActionList: [
				{ timestamp: 9921, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 12424, action: "VIB", parameter: "0,100"},
				{ timestamp: 14928, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 17426, action: "VIB", parameter: "0,100"},
				{ timestamp: 19944, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 22448, action: "VIB", parameter: "0,100"},
				{ timestamp: 24945, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 27457, action: "VIB", parameter: "0,100"},
				{ timestamp: 29940, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 32437, action: "VIB", parameter: "0,100"},
				{ timestamp: 34907, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 37411, action: "VIB", parameter: "0,100"},
				{ timestamp: 39922, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 42413, action: "VIB", parameter: "0,100"},
				{ timestamp: 44913, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 47421, action: "VIB", parameter: "0,100"},
				{ timestamp: 49932, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 52430, action: "VIB", parameter: "0,100"},
				{ timestamp: 54892, action: "VIB", parameter: "0,100,200,100"},
				{ timestamp: 57369, action: "VIB", parameter: "0,100"},
				{ timestamp: 59866, action: "VIB", parameter: "0,100,200,100"},
				]
			},
		]
	};

	socket.emit('loading', actionSequenceMessage);
	return false;
});

$("#sequence3").click(function(){
	var startRequest = {
		show_id : current_show_id,
		delay: 10,
		sequence_id: 1
	};

	socket.emit('start_delay', startRequest);
	return false;
});
	
	
// ##################################################
// # Sequence 2
// ##################################################
	
$("#testsequence1").click(function(){

	var actionSequenceMessage = {
		show_id : current_show_id,
		id: 2,
		title: "Test Brightness",
		video: "",
		audio: "",
		actionTrackList: [
			{ timedActionList: [
				{timestamp: 0, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 0, action: "B", parameter: "0"},
				{timestamp: 2000, action: "B", parameter: "10"},
				{timestamp: 3000, action: "B", parameter: "20"},
				{timestamp: 4000, action: "B", parameter: "30"},
				{timestamp: 5000, action: "B", parameter: "40"},
				{timestamp: 6000, action: "B", parameter: "50"},
				{timestamp: 7000, action: "B", parameter: "60"},
				{timestamp: 8000, action: "B", parameter: "70"},
				{timestamp: 9000, action: "B", parameter: "80"},
				{timestamp: 10000, action: "B", parameter: "90"},
				{timestamp: 11000, action: "B", parameter: "100"},
				{timestamp: 12000, action: "B", parameter: "90"},
				{timestamp: 13000, action: "B", parameter: "80"},
				{timestamp: 14000, action: "B", parameter: "70"},
				{timestamp: 15000, action: "B", parameter: "60"},
				{timestamp: 16000, action: "B", parameter: "50"},
				{timestamp: 17000, action: "B", parameter: "40"},
				{timestamp: 18000, action: "B", parameter: "30"},
				{timestamp: 19000, action: "B", parameter: "20"},
				{timestamp: 20000, action: "B", parameter: "10"},
				{timestamp: 21000, action: "B", parameter: "0"},
				{timestamp: 25000, action: "B", parameter: "100"},
				]
			},
		]
	};

	socket.emit('loading', actionSequenceMessage);
	return false;
});

$("#testsequence2").click(function(){
	var startRequest = {
		show_id : current_show_id,
		delay: 10,
		sequence_id: 2
	};

	socket.emit('start_delay', startRequest);
	return false;
});
	
// ##################################################
// # Sequence 3
// ##################################################
	
$("#testsequence3_1").click(function(){

	var actionSequenceMessage = {
		show_id : current_show_id,
		id: 3,
		title: "Test Séquence",
		video: "",
		audio: "",
		actionTrackList: [
			{ timedActionList: [
				{timestamp: 0, action: "FC", parameter: "#000000"},
				{timestamp: 3000, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 4000, action: "FC", parameter: "#FF0000"},
				{timestamp: 5000, action: "FC", parameter: "#00FF00"},
				{timestamp: 6000, action: "FC", parameter: "#0000FF"},
				{timestamp: 7000, action: "FC", parameter: "#00FFFF"},
				{timestamp: 8000, action: "FC", parameter: "#FF00FF"},
				{timestamp: 9000, action: "FC", parameter: "#FFFF00"},
				{timestamp: 10000, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 11000, action: "FC", parameter: "#777777"},
				{timestamp: 12000, action: "FC", parameter: "#333333"},
				{timestamp: 13000, action: "FC", parameter: "#000000"},
				{timestamp: 14000, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 14500, action: "FC", parameter: "#000000"},
				{timestamp: 15000, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 15500, action: "FC", parameter: "#000000"},
				{timestamp: 16000, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 16500, action: "FC", parameter: "#000000"},
				{timestamp: 17000, action: "FC", parameter: "#FF0000"},
				{timestamp: 17500, action: "FC", parameter: "#000000"},
				{timestamp: 18000, action: "FC", parameter: "#FF0000"},
				{timestamp: 18500, action: "FC", parameter: "#000000"},
				{timestamp: 19000, action: "FC", parameter: "#0000FF"},
				{timestamp: 19500, action: "FC", parameter: "#000000"},
				{timestamp: 20000, action: "FC", parameter: "#0000FF"},
				{timestamp: 20500, action: "FC", parameter: "#0000FF"},
				{timestamp: 21000, action: "FC", parameter: "#FF0000"},
				{timestamp: 21500, action: "FC", parameter: "#0000FF"},
				{timestamp: 22000, action: "FC", parameter: "#FF0000"},
				{timestamp: 22500, action: "FC", parameter: "#0000FF"},
				{timestamp: 23000, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 23500, action: "FC", parameter: "#000000"},
				{timestamp: 24000, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 24500, action: "FC", parameter: "#000000"},
				{timestamp: 25000, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 25500, action: "FC", parameter: "#000000"},
				{timestamp: 26000, action: "FC", parameter: "#FFFFFF"},
				{timestamp: 26500, action: "FC", parameter: "#000000"},
				]
			},
		]
	};

	socket.emit('loading', actionSequenceMessage);
	return false;
});

$("#testsequence3_2").click(function(){
	var startRequest = {
		show_id : current_show_id,
		delay: 10,
		sequence_id: 3
	};

	socket.emit('start_delay', startRequest);
	return false;
});
	
// ##################################################
// # Brightness
// ##################################################
$("#brightness0").click(function(){

	var actionBrightness = {
		action: 'B',
		value: "0",
	};
	
	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness10").click(function(){

	var actionBrightness = {
		action: 'B',
		value: "10",
	};
	
	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness20").click(function(){

	var actionBrightness = {
		show_id : current_show_id,
		action: 'B',
		value: "20",
	};

	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness30").click(function(){

	var actionBrightness = {
		show_id : current_show_id,
		action: 'B',
		value: "30",
	};

	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness40").click(function(){

	var actionBrightness = {
		show_id : current_show_id,
		action: 'B',
		value: "40",
	};

	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness50").click(function(){

	var actionBrightness = {
		show_id : current_show_id,
		action: 'B',
		value: "50",
	};

	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness60").click(function(){

	var actionBrightness = {
		show_id : current_show_id,
		action: 'B',
		value: "60",
	};

	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness70").click(function(){

	var actionBrightness = {
			show_id : current_show_id,
		action: 'B',
		value: "70",
	};

	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness80").click(function(){

	var actionBrightness = {
			show_id : current_show_id,
		action: 'B',
		value: "80",
	};
	
	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness90").click(function(){

	var actionBrightness = {
			show_id : current_show_id,
		action: 'B',
		value: "90",
	};

	socket.emit('action', actionBrightness);

	return false;
});
$("#brightness100").click(function(){

	var actionBrightness = {
			show_id : current_show_id,
		action: 'B',
		value: "100",
	};
	
	socket.emit('action', actionBrightness);

	return false;
});

// ##################################################
// # Vibration
// ##################################################
$("#vibration1").click(function(){

	var actionVib = {
			show_id : current_show_id,
		action: 'VIB',
		value: "0,100,200,100",
	};

	socket.emit('action', actionVib);

	return false;
});
$("#vibration2").click(function(){

	var actionVib = {
			show_id : current_show_id,
		action: 'VIB',
		value: "0,1000",
	};
	
	socket.emit('action', actionVib);

	return false;
});
$("#vibration3").click(function(){

	var actionVib = {
			show_id : current_show_id,
		action: 'VIB',
		value: "0,50,50,50,50,50,50,50,50,50,50,50",
	};

	socket.emit('action', actionVib);

	return false;
});
$("#vibration4").click(function(){

	var actionVib = {
			show_id : current_show_id,
		action: 'VIB',
		value: "0,100,100,100,100,100,100,100,100,100,100,100",
	};

	socket.emit('action', actionVib);

	return false;
});
$("#vibration5").click(function(){

	var actionVib = {
			show_id : current_show_id,
		action: 'VIB',
		value: "0,300,300,300,300,300,300,300,300,300,300,300",
	};

	socket.emit('action', actionVib);

	return false;
});


// ##################################################
// # Flash
// ##################################################
$("#flash1").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "1000,1000,5",
	};

	socket.emit('action', actionFlash);

	return false;
});
$("#flash2").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "500,2000,3",
	};

	socket.emit('action', actionFlash);

	return false;
});
$("#flash3").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "2000,500,2",
	};

	socket.emit('action', actionFlash);

	return false;
});
$("#flash4").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "200,200,-1",
	};

	socket.emit('action', actionFlash);

	return false;
});
$("#flash5").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "200,3000,-1",
	};

	socket.emit('action', actionFlash);

	return false;
});

$("#flash7").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "100,100,20",
	};

	socket.emit('action', actionFlash);

	return false;
});

$("#flash8").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "50,50,40",
	};

	socket.emit('action', actionFlash);

	return false;
});

$("#flash9").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "20,20,100",
	};

	socket.emit('action', actionFlash);

	return false;
});

$("#flash10").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "10,10,200",
	};

	socket.emit('action', actionFlash);

	return false;
});

$("#flash11").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "5,5,400",
	};

	socket.emit('action', actionFlash);

	return false;
});


$("#flash6").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "0,0,0",
	};

	socket.emit('action', actionFlash);

	return false;
});

$("#flash_stop").click(function(){

	var actionFlash = {
			show_id : current_show_id,
		action: 'FLASH',
		value: "0,0,0",
	};

	socket.emit('action', actionFlash);

	return false;
});
		
// ##################################################
// # NEW Action
// ##################################################
$("#new_action_1").click(function(){

	var actionACMessage = {
			show_id : current_show_id,
		action: 'AC',
		value: "NONE,N,N-0-1000,#FF0000,#0000FF",
	};

	socket.emit('action', actionACMessage);

	return false;
});

$("#new_action_2").click(function(){

	// Random couleurs bleu, blanc, rouge
	var actionACMessage = {
			show_id : current_show_id,
		action: 'AC',
		value: "NONE,Y,N-1000-500,#FF0000,#FFFFFF,#0000FF",
	};

	socket.emit('action', actionACMessage);

	return false;
});

$("#new_action_3").click(function(){

	// Scintillement variés (couleurs complétement aléatoires)
	var actionACMessage = {
			show_id : current_show_id,
		action: 'AC',
		value: "NONE,Y,N-0-200",
	};

	socket.emit('action', actionACMessage);

	return false;
});

$("#new_action_4").click(function(){

	// Scintillement blancs (temps aléatoires)
	var actionACMessage = {
			show_id : current_show_id,
		action: 'AC',
		value: "NONE,Y,Y-2000-5000-100-200,#FFFFFF",
	};

	socket.emit('action', actionACMessage);

	return false;
});

// ##################################################
// # Exit
// ##################################################
$("#exit").click(function(){

	var actionExit = {
			show_id : current_show_id,
		action: 'EXIT',
	};

	socket.emit('action', actionExit);

	return false;
});


$("#zones_3_question").click(function(){
	var questionRequest = {show_id : current_show_id, id : "zone", "title":"Dans quelle zone vous trouvez vous ?","options":[{"title":"Zone 0","value":"z-0"},{"title":"Zone 1","value":"z-1"},{"title":"Zone 2","value":"z-2"}]};
	
	socket.emit('question', questionRequest);
	return false;
});


$("#zones_3_load").click(function(){

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [{"value":"z-0","command":"loading","valueCommand":{"id":4,"title":"sequence Test0","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#FFFFFF"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#00FF00"},{"timestamp":6500,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":7500,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#00FF00"},{"timestamp":8500,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#0000FF"},{"timestamp":9300,"action":"FC","parameter":"#000000"},{"timestamp":9600,"action":"FC","parameter":"#000000"},{"timestamp":9900,"action":"FC","parameter":"#000000"},{"timestamp":10200,"action":"FC","parameter":"#0000FF"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10800,"action":"FC","parameter":"#FF00FF"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":11200,"action":"FC","parameter":"#000000"},{"timestamp":11400,"action":"FC","parameter":"#000000"},{"timestamp":11600,"action":"FC","parameter":"#FF00FF"},{"timestamp":11800,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":13000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":14000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":15000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":16000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#00FF00"},{"timestamp":17500,"action":"FC","parameter":"#00FF00"},{"timestamp":18000,"action":"FC","parameter":"#00FF00"},{"timestamp":18500,"action":"FC","parameter":"#00FF00"},{"timestamp":19000,"action":"FC","parameter":"#00FF00"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#0000FF"},{"timestamp":19800,"action":"FC","parameter":"#0000FF"},{"timestamp":20100,"action":"FC","parameter":"#0000FF"},{"timestamp":20400,"action":"FC","parameter":"#0000FF"},{"timestamp":20700,"action":"FC","parameter":"#0000FF"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#FF00FF"},{"timestamp":21200,"action":"FC","parameter":"#FF00FF"},{"timestamp":21400,"action":"FC","parameter":"#FF00FF"},{"timestamp":21600,"action":"FC","parameter":"#FF00FF"},{"timestamp":21800,"action":"FC","parameter":"#FF00FF"},{"timestamp":22000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-1","command":"loading","valueCommand":{"id":4,"title":"sequence Test1","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":6500,"action":"FC","parameter":"#00FF00"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":7500,"action":"FC","parameter":"#00FF00"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":8500,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":9300,"action":"FC","parameter":"#0000FF"},{"timestamp":9600,"action":"FC","parameter":"#000000"},{"timestamp":9900,"action":"FC","parameter":"#0000FF"},{"timestamp":10200,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10800,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#FF00FF"},{"timestamp":11200,"action":"FC","parameter":"#000000"},{"timestamp":11400,"action":"FC","parameter":"#FF00FF"},{"timestamp":11600,"action":"FC","parameter":"#000000"},{"timestamp":11800,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":14000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":15000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#00FF00"},{"timestamp":18000,"action":"FC","parameter":"#00FF00"},{"timestamp":18500,"action":"FC","parameter":"#00FF00"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#0000FF"},{"timestamp":20100,"action":"FC","parameter":"#0000FF"},{"timestamp":20400,"action":"FC","parameter":"#0000FF"},{"timestamp":20700,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21200,"action":"FC","parameter":"#FF00FF"},{"timestamp":21400,"action":"FC","parameter":"#FF00FF"},{"timestamp":21600,"action":"FC","parameter":"#FF00FF"},{"timestamp":21800,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-2","command":"loading","valueCommand":{"id":4,"title":"sequence Test2","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":6500,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#00FF00"},{"timestamp":7500,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":8500,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":9300,"action":"FC","parameter":"#000000"},{"timestamp":9600,"action":"FC","parameter":"#0000FF"},{"timestamp":9900,"action":"FC","parameter":"#000000"},{"timestamp":10200,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10800,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":11200,"action":"FC","parameter":"#FF00FF"},{"timestamp":11400,"action":"FC","parameter":"#000000"},{"timestamp":11600,"action":"FC","parameter":"#000000"},{"timestamp":11800,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#00FF00"},{"timestamp":18500,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20100,"action":"FC","parameter":"#0000FF"},{"timestamp":20400,"action":"FC","parameter":"#000000"},{"timestamp":20700,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21200,"action":"FC","parameter":"#000000"},{"timestamp":21400,"action":"FC","parameter":"#FF00FF"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21800,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#000000"}]}]}}]
	};
	
	socket.emit('action_diff', actionDiffMessage);
	
	return false;
});

$("#zones_3_start").click(function(){
	var startRequest = {
			show_id : current_show_id,
		delay: 10,
		sequence_id: 4
	};

	socket.emit('start_delay', startRequest);
	return false;
});


$("#zones_4_question").click(function(){
	var questionRequest = {show_id : current_show_id, id : "zone", "title":"Dans quelle zone vous trouvez vous ?","options":[{"title":"Zone 0","value":"z-0"},{"title":"Zone 1","value":"z-1"},{"title":"Zone 2","value":"z-2"},{"title":"Zone 3","value":"z-3"}]};
	
	socket.emit('question', questionRequest);
	return false;
});


$("#zones_4_action").click(function(){

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [{"value":"z-0","command":"loading","valueCommand":{"id":5,"title":"sequence Test0","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#FFFFFF"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#00FF00"},{"timestamp":7500,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":8500,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":9500,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#00FF00"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#0000FF"},{"timestamp":10800,"action":"FC","parameter":"#000000"},{"timestamp":11100,"action":"FC","parameter":"#000000"},{"timestamp":11400,"action":"FC","parameter":"#000000"},{"timestamp":11700,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12300,"action":"FC","parameter":"#0000FF"},{"timestamp":12600,"action":"FC","parameter":"#000000"},{"timestamp":12600,"action":"FC","parameter":"#FF00FF"},{"timestamp":12800,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13200,"action":"FC","parameter":"#000000"},{"timestamp":13400,"action":"FC","parameter":"#000000"},{"timestamp":13600,"action":"FC","parameter":"#000000"},{"timestamp":13800,"action":"FC","parameter":"#FF00FF"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":15000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":16000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":17000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":18000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":19000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":20000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#00FF00"},{"timestamp":21500,"action":"FC","parameter":"#00FF00"},{"timestamp":22000,"action":"FC","parameter":"#00FF00"},{"timestamp":22500,"action":"FC","parameter":"#00FF00"},{"timestamp":23000,"action":"FC","parameter":"#00FF00"},{"timestamp":23500,"action":"FC","parameter":"#00FF00"},{"timestamp":24000,"action":"FC","parameter":"#00FF00"},{"timestamp":24500,"action":"FC","parameter":"#000000"},{"timestamp":24500,"action":"FC","parameter":"#0000FF"},{"timestamp":24800,"action":"FC","parameter":"#0000FF"},{"timestamp":25100,"action":"FC","parameter":"#0000FF"},{"timestamp":25400,"action":"FC","parameter":"#0000FF"},{"timestamp":25700,"action":"FC","parameter":"#0000FF"},{"timestamp":26000,"action":"FC","parameter":"#0000FF"},{"timestamp":26300,"action":"FC","parameter":"#0000FF"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#FF00FF"},{"timestamp":26800,"action":"FC","parameter":"#FF00FF"},{"timestamp":27000,"action":"FC","parameter":"#FF00FF"},{"timestamp":27200,"action":"FC","parameter":"#FF00FF"},{"timestamp":27400,"action":"FC","parameter":"#FF00FF"},{"timestamp":27600,"action":"FC","parameter":"#FF00FF"},{"timestamp":27800,"action":"FC","parameter":"#FF00FF"},{"timestamp":28000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-1","command":"loading","valueCommand":{"id":5,"title":"sequence Test1","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":7500,"action":"FC","parameter":"#00FF00"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":8500,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":9500,"action":"FC","parameter":"#00FF00"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10800,"action":"FC","parameter":"#0000FF"},{"timestamp":11100,"action":"FC","parameter":"#000000"},{"timestamp":11400,"action":"FC","parameter":"#000000"},{"timestamp":11700,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#0000FF"},{"timestamp":12300,"action":"FC","parameter":"#000000"},{"timestamp":12600,"action":"FC","parameter":"#000000"},{"timestamp":12600,"action":"FC","parameter":"#000000"},{"timestamp":12800,"action":"FC","parameter":"#FF00FF"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13200,"action":"FC","parameter":"#000000"},{"timestamp":13400,"action":"FC","parameter":"#000000"},{"timestamp":13600,"action":"FC","parameter":"#FF00FF"},{"timestamp":13800,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":16000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":17000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":18000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":19000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21500,"action":"FC","parameter":"#00FF00"},{"timestamp":22000,"action":"FC","parameter":"#00FF00"},{"timestamp":22500,"action":"FC","parameter":"#00FF00"},{"timestamp":23000,"action":"FC","parameter":"#00FF00"},{"timestamp":23500,"action":"FC","parameter":"#00FF00"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":24500,"action":"FC","parameter":"#000000"},{"timestamp":24500,"action":"FC","parameter":"#000000"},{"timestamp":24800,"action":"FC","parameter":"#0000FF"},{"timestamp":25100,"action":"FC","parameter":"#0000FF"},{"timestamp":25400,"action":"FC","parameter":"#0000FF"},{"timestamp":25700,"action":"FC","parameter":"#0000FF"},{"timestamp":26000,"action":"FC","parameter":"#0000FF"},{"timestamp":26300,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26800,"action":"FC","parameter":"#FF00FF"},{"timestamp":27000,"action":"FC","parameter":"#FF00FF"},{"timestamp":27200,"action":"FC","parameter":"#FF00FF"},{"timestamp":27400,"action":"FC","parameter":"#FF00FF"},{"timestamp":27600,"action":"FC","parameter":"#FF00FF"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-2","command":"loading","valueCommand":{"id":4,"title":"sequence Test2","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":7500,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#00FF00"},{"timestamp":8500,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#00FF00"},{"timestamp":9500,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10800,"action":"FC","parameter":"#000000"},{"timestamp":11100,"action":"FC","parameter":"#0000FF"},{"timestamp":11400,"action":"FC","parameter":"#000000"},{"timestamp":11700,"action":"FC","parameter":"#0000FF"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12300,"action":"FC","parameter":"#000000"},{"timestamp":12600,"action":"FC","parameter":"#000000"},{"timestamp":12600,"action":"FC","parameter":"#000000"},{"timestamp":12800,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#FF00FF"},{"timestamp":13200,"action":"FC","parameter":"#000000"},{"timestamp":13400,"action":"FC","parameter":"#FF00FF"},{"timestamp":13600,"action":"FC","parameter":"#000000"},{"timestamp":13800,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":17000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":18000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21500,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#00FF00"},{"timestamp":22500,"action":"FC","parameter":"#00FF00"},{"timestamp":23000,"action":"FC","parameter":"#00FF00"},{"timestamp":23500,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":24500,"action":"FC","parameter":"#000000"},{"timestamp":24500,"action":"FC","parameter":"#000000"},{"timestamp":24800,"action":"FC","parameter":"#000000"},{"timestamp":25100,"action":"FC","parameter":"#0000FF"},{"timestamp":25400,"action":"FC","parameter":"#0000FF"},{"timestamp":25700,"action":"FC","parameter":"#0000FF"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":26300,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26800,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#FF00FF"},{"timestamp":27200,"action":"FC","parameter":"#FF00FF"},{"timestamp":27400,"action":"FC","parameter":"#FF00FF"},{"timestamp":27600,"action":"FC","parameter":"#000000"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-3","command":"loading","valueCommand":{"id":5,"title":"sequence Test3","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":7500,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":8500,"action":"FC","parameter":"#00FF00"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":9500,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":10800,"action":"FC","parameter":"#000000"},{"timestamp":11100,"action":"FC","parameter":"#000000"},{"timestamp":11400,"action":"FC","parameter":"#0000FF"},{"timestamp":11700,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12300,"action":"FC","parameter":"#000000"},{"timestamp":12600,"action":"FC","parameter":"#000000"},{"timestamp":12600,"action":"FC","parameter":"#000000"},{"timestamp":12800,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13200,"action":"FC","parameter":"#FF00FF"},{"timestamp":13400,"action":"FC","parameter":"#000000"},{"timestamp":13600,"action":"FC","parameter":"#000000"},{"timestamp":13800,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21500,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#000000"},{"timestamp":22500,"action":"FC","parameter":"#00FF00"},{"timestamp":23000,"action":"FC","parameter":"#000000"},{"timestamp":23500,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":24500,"action":"FC","parameter":"#000000"},{"timestamp":24500,"action":"FC","parameter":"#000000"},{"timestamp":24800,"action":"FC","parameter":"#000000"},{"timestamp":25100,"action":"FC","parameter":"#000000"},{"timestamp":25400,"action":"FC","parameter":"#0000FF"},{"timestamp":25700,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":26300,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26800,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":27200,"action":"FC","parameter":"#FF00FF"},{"timestamp":27400,"action":"FC","parameter":"#000000"},{"timestamp":27600,"action":"FC","parameter":"#000000"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"}]}]}}]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#zones_4_start").click(function(){
	var startRequest = {
			show_id : current_show_id, 
		delay: 10,
		sequence_id: 5
	};
	
	socket.emit('start_delay', startRequest);
	return false;
});

$("#zones_5_question").click(function(){
	var questionRequest = {show_id : current_show_id, id : "zone", "title":"Dans quelle zone vous trouvez vous ?","options":[{"title":"Zone 0","value":"z-0"},{"title":"Zone 1","value":"z-1"},{"title":"Zone 2","value":"z-2"},{"title":"Zone 3","value":"z-3"},{"title":"Zone 4","value":"z-4"}]};
	
	socket.emit('question', questionRequest);
	return false;
});


$("#zones_5_load").click(function(){

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [{"value":"z-0","command":"loading","valueCommand":{"id":6,"title":"sequence Test0","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#FFFFFF"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#00FF00"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":11500,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12500,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13500,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#00FF00"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#0000FF"},{"timestamp":15300,"action":"FC","parameter":"#000000"},{"timestamp":15600,"action":"FC","parameter":"#000000"},{"timestamp":15900,"action":"FC","parameter":"#000000"},{"timestamp":16200,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":16800,"action":"FC","parameter":"#000000"},{"timestamp":17100,"action":"FC","parameter":"#000000"},{"timestamp":17400,"action":"FC","parameter":"#0000FF"},{"timestamp":17700,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#FF00FF"},{"timestamp":18200,"action":"FC","parameter":"#000000"},{"timestamp":18400,"action":"FC","parameter":"#000000"},{"timestamp":18600,"action":"FC","parameter":"#000000"},{"timestamp":18800,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19200,"action":"FC","parameter":"#000000"},{"timestamp":19400,"action":"FC","parameter":"#000000"},{"timestamp":19600,"action":"FC","parameter":"#FF00FF"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":21000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":22000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":23000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":24000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":25000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":26000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":27000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":28000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#00FF00"},{"timestamp":29500,"action":"FC","parameter":"#00FF00"},{"timestamp":30000,"action":"FC","parameter":"#00FF00"},{"timestamp":30500,"action":"FC","parameter":"#00FF00"},{"timestamp":31000,"action":"FC","parameter":"#00FF00"},{"timestamp":31500,"action":"FC","parameter":"#00FF00"},{"timestamp":32000,"action":"FC","parameter":"#00FF00"},{"timestamp":32500,"action":"FC","parameter":"#00FF00"},{"timestamp":33000,"action":"FC","parameter":"#00FF00"},{"timestamp":33500,"action":"FC","parameter":"#000000"},{"timestamp":33500,"action":"FC","parameter":"#0000FF"},{"timestamp":33800,"action":"FC","parameter":"#0000FF"},{"timestamp":34100,"action":"FC","parameter":"#0000FF"},{"timestamp":34400,"action":"FC","parameter":"#0000FF"},{"timestamp":34700,"action":"FC","parameter":"#0000FF"},{"timestamp":35000,"action":"FC","parameter":"#0000FF"},{"timestamp":35300,"action":"FC","parameter":"#0000FF"},{"timestamp":35600,"action":"FC","parameter":"#0000FF"},{"timestamp":35900,"action":"FC","parameter":"#0000FF"},{"timestamp":36200,"action":"FC","parameter":"#000000"},{"timestamp":36200,"action":"FC","parameter":"#FF00FF"},{"timestamp":36400,"action":"FC","parameter":"#FF00FF"},{"timestamp":36600,"action":"FC","parameter":"#FF00FF"},{"timestamp":36800,"action":"FC","parameter":"#FF00FF"},{"timestamp":37000,"action":"FC","parameter":"#FF00FF"},{"timestamp":37200,"action":"FC","parameter":"#FF00FF"},{"timestamp":37400,"action":"FC","parameter":"#FF00FF"},{"timestamp":37600,"action":"FC","parameter":"#FF00FF"},{"timestamp":37800,"action":"FC","parameter":"#FF00FF"},{"timestamp":38000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-1","command":"loading","valueCommand":{"id":6,"title":"sequence Test1","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#00FF00"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":11500,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12500,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13500,"action":"FC","parameter":"#00FF00"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15300,"action":"FC","parameter":"#0000FF"},{"timestamp":15600,"action":"FC","parameter":"#000000"},{"timestamp":15900,"action":"FC","parameter":"#000000"},{"timestamp":16200,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":16800,"action":"FC","parameter":"#000000"},{"timestamp":17100,"action":"FC","parameter":"#0000FF"},{"timestamp":17400,"action":"FC","parameter":"#000000"},{"timestamp":17700,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18200,"action":"FC","parameter":"#FF00FF"},{"timestamp":18400,"action":"FC","parameter":"#000000"},{"timestamp":18600,"action":"FC","parameter":"#000000"},{"timestamp":18800,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19200,"action":"FC","parameter":"#000000"},{"timestamp":19400,"action":"FC","parameter":"#FF00FF"},{"timestamp":19600,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":22000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":23000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":24000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":25000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":26000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":27000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":29500,"action":"FC","parameter":"#00FF00"},{"timestamp":30000,"action":"FC","parameter":"#00FF00"},{"timestamp":30500,"action":"FC","parameter":"#00FF00"},{"timestamp":31000,"action":"FC","parameter":"#00FF00"},{"timestamp":31500,"action":"FC","parameter":"#00FF00"},{"timestamp":32000,"action":"FC","parameter":"#00FF00"},{"timestamp":32500,"action":"FC","parameter":"#00FF00"},{"timestamp":33000,"action":"FC","parameter":"#000000"},{"timestamp":33500,"action":"FC","parameter":"#000000"},{"timestamp":33500,"action":"FC","parameter":"#000000"},{"timestamp":33800,"action":"FC","parameter":"#0000FF"},{"timestamp":34100,"action":"FC","parameter":"#0000FF"},{"timestamp":34400,"action":"FC","parameter":"#0000FF"},{"timestamp":34700,"action":"FC","parameter":"#0000FF"},{"timestamp":35000,"action":"FC","parameter":"#0000FF"},{"timestamp":35300,"action":"FC","parameter":"#0000FF"},{"timestamp":35600,"action":"FC","parameter":"#0000FF"},{"timestamp":35900,"action":"FC","parameter":"#000000"},{"timestamp":36200,"action":"FC","parameter":"#000000"},{"timestamp":36200,"action":"FC","parameter":"#000000"},{"timestamp":36400,"action":"FC","parameter":"#FF00FF"},{"timestamp":36600,"action":"FC","parameter":"#FF00FF"},{"timestamp":36800,"action":"FC","parameter":"#FF00FF"},{"timestamp":37000,"action":"FC","parameter":"#FF00FF"},{"timestamp":37200,"action":"FC","parameter":"#FF00FF"},{"timestamp":37400,"action":"FC","parameter":"#FF00FF"},{"timestamp":37600,"action":"FC","parameter":"#FF00FF"},{"timestamp":37800,"action":"FC","parameter":"#000000"},{"timestamp":38000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-2","command":"loading","valueCommand":{"id":6,"title":"sequence Test2","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#00FF00"},{"timestamp":11500,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12500,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#00FF00"},{"timestamp":13500,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15300,"action":"FC","parameter":"#000000"},{"timestamp":15600,"action":"FC","parameter":"#0000FF"},{"timestamp":15900,"action":"FC","parameter":"#000000"},{"timestamp":16200,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":16800,"action":"FC","parameter":"#0000FF"},{"timestamp":17100,"action":"FC","parameter":"#000000"},{"timestamp":17400,"action":"FC","parameter":"#000000"},{"timestamp":17700,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18200,"action":"FC","parameter":"#000000"},{"timestamp":18400,"action":"FC","parameter":"#FF00FF"},{"timestamp":18600,"action":"FC","parameter":"#000000"},{"timestamp":18800,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19200,"action":"FC","parameter":"#FF00FF"},{"timestamp":19400,"action":"FC","parameter":"#000000"},{"timestamp":19600,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":23000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":24000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":25000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":26000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":29500,"action":"FC","parameter":"#000000"},{"timestamp":30000,"action":"FC","parameter":"#00FF00"},{"timestamp":30500,"action":"FC","parameter":"#00FF00"},{"timestamp":31000,"action":"FC","parameter":"#00FF00"},{"timestamp":31500,"action":"FC","parameter":"#00FF00"},{"timestamp":32000,"action":"FC","parameter":"#00FF00"},{"timestamp":32500,"action":"FC","parameter":"#000000"},{"timestamp":33000,"action":"FC","parameter":"#000000"},{"timestamp":33500,"action":"FC","parameter":"#000000"},{"timestamp":33500,"action":"FC","parameter":"#000000"},{"timestamp":33800,"action":"FC","parameter":"#000000"},{"timestamp":34100,"action":"FC","parameter":"#0000FF"},{"timestamp":34400,"action":"FC","parameter":"#0000FF"},{"timestamp":34700,"action":"FC","parameter":"#0000FF"},{"timestamp":35000,"action":"FC","parameter":"#0000FF"},{"timestamp":35300,"action":"FC","parameter":"#0000FF"},{"timestamp":35600,"action":"FC","parameter":"#000000"},{"timestamp":35900,"action":"FC","parameter":"#000000"},{"timestamp":36200,"action":"FC","parameter":"#000000"},{"timestamp":36200,"action":"FC","parameter":"#000000"},{"timestamp":36400,"action":"FC","parameter":"#000000"},{"timestamp":36600,"action":"FC","parameter":"#FF00FF"},{"timestamp":36800,"action":"FC","parameter":"#FF00FF"},{"timestamp":37000,"action":"FC","parameter":"#FF00FF"},{"timestamp":37200,"action":"FC","parameter":"#FF00FF"},{"timestamp":37400,"action":"FC","parameter":"#FF00FF"},{"timestamp":37600,"action":"FC","parameter":"#000000"},{"timestamp":37800,"action":"FC","parameter":"#000000"},{"timestamp":38000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-3","command":"loading","valueCommand":{"id":6,"title":"sequence Test3","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":11500,"action":"FC","parameter":"#00FF00"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12500,"action":"FC","parameter":"#00FF00"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13500,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15300,"action":"FC","parameter":"#000000"},{"timestamp":15600,"action":"FC","parameter":"#000000"},{"timestamp":15900,"action":"FC","parameter":"#0000FF"},{"timestamp":16200,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#0000FF"},{"timestamp":16800,"action":"FC","parameter":"#000000"},{"timestamp":17100,"action":"FC","parameter":"#000000"},{"timestamp":17400,"action":"FC","parameter":"#000000"},{"timestamp":17700,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18200,"action":"FC","parameter":"#000000"},{"timestamp":18400,"action":"FC","parameter":"#000000"},{"timestamp":18600,"action":"FC","parameter":"#FF00FF"},{"timestamp":18800,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#FF00FF"},{"timestamp":19200,"action":"FC","parameter":"#000000"},{"timestamp":19400,"action":"FC","parameter":"#000000"},{"timestamp":19600,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#000000"},{"timestamp":23000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":24000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":25000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":29500,"action":"FC","parameter":"#000000"},{"timestamp":30000,"action":"FC","parameter":"#000000"},{"timestamp":30500,"action":"FC","parameter":"#00FF00"},{"timestamp":31000,"action":"FC","parameter":"#00FF00"},{"timestamp":31500,"action":"FC","parameter":"#00FF00"},{"timestamp":32000,"action":"FC","parameter":"#000000"},{"timestamp":32500,"action":"FC","parameter":"#000000"},{"timestamp":33000,"action":"FC","parameter":"#000000"},{"timestamp":33500,"action":"FC","parameter":"#000000"},{"timestamp":33500,"action":"FC","parameter":"#000000"},{"timestamp":33800,"action":"FC","parameter":"#000000"},{"timestamp":34100,"action":"FC","parameter":"#000000"},{"timestamp":34400,"action":"FC","parameter":"#0000FF"},{"timestamp":34700,"action":"FC","parameter":"#0000FF"},{"timestamp":35000,"action":"FC","parameter":"#0000FF"},{"timestamp":35300,"action":"FC","parameter":"#000000"},{"timestamp":35600,"action":"FC","parameter":"#000000"},{"timestamp":35900,"action":"FC","parameter":"#000000"},{"timestamp":36200,"action":"FC","parameter":"#000000"},{"timestamp":36200,"action":"FC","parameter":"#000000"},{"timestamp":36400,"action":"FC","parameter":"#000000"},{"timestamp":36600,"action":"FC","parameter":"#000000"},{"timestamp":36800,"action":"FC","parameter":"#FF00FF"},{"timestamp":37000,"action":"FC","parameter":"#FF00FF"},{"timestamp":37200,"action":"FC","parameter":"#FF00FF"},{"timestamp":37400,"action":"FC","parameter":"#000000"},{"timestamp":37600,"action":"FC","parameter":"#000000"},{"timestamp":37800,"action":"FC","parameter":"#000000"},{"timestamp":38000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-4","command":"loading","valueCommand":{"id":6,"title":"sequence Test4","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":10500,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":11500,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#00FF00"},{"timestamp":12500,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13500,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15300,"action":"FC","parameter":"#000000"},{"timestamp":15600,"action":"FC","parameter":"#000000"},{"timestamp":15900,"action":"FC","parameter":"#000000"},{"timestamp":16200,"action":"FC","parameter":"#0000FF"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":16800,"action":"FC","parameter":"#000000"},{"timestamp":17100,"action":"FC","parameter":"#000000"},{"timestamp":17400,"action":"FC","parameter":"#000000"},{"timestamp":17700,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18200,"action":"FC","parameter":"#000000"},{"timestamp":18400,"action":"FC","parameter":"#000000"},{"timestamp":18600,"action":"FC","parameter":"#000000"},{"timestamp":18800,"action":"FC","parameter":"#FF00FF"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19200,"action":"FC","parameter":"#000000"},{"timestamp":19400,"action":"FC","parameter":"#000000"},{"timestamp":19600,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#000000"},{"timestamp":23000,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":25000,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":29500,"action":"FC","parameter":"#000000"},{"timestamp":30000,"action":"FC","parameter":"#000000"},{"timestamp":30500,"action":"FC","parameter":"#000000"},{"timestamp":31000,"action":"FC","parameter":"#00FF00"},{"timestamp":31500,"action":"FC","parameter":"#000000"},{"timestamp":32000,"action":"FC","parameter":"#000000"},{"timestamp":32500,"action":"FC","parameter":"#000000"},{"timestamp":33000,"action":"FC","parameter":"#000000"},{"timestamp":33500,"action":"FC","parameter":"#000000"},{"timestamp":33500,"action":"FC","parameter":"#000000"},{"timestamp":33800,"action":"FC","parameter":"#000000"},{"timestamp":34100,"action":"FC","parameter":"#000000"},{"timestamp":34400,"action":"FC","parameter":"#000000"},{"timestamp":34700,"action":"FC","parameter":"#0000FF"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35300,"action":"FC","parameter":"#000000"},{"timestamp":35600,"action":"FC","parameter":"#000000"},{"timestamp":35900,"action":"FC","parameter":"#000000"},{"timestamp":36200,"action":"FC","parameter":"#000000"},{"timestamp":36200,"action":"FC","parameter":"#000000"},{"timestamp":36400,"action":"FC","parameter":"#000000"},{"timestamp":36600,"action":"FC","parameter":"#000000"},{"timestamp":36800,"action":"FC","parameter":"#000000"},{"timestamp":37000,"action":"FC","parameter":"#FF00FF"},{"timestamp":37200,"action":"FC","parameter":"#000000"},{"timestamp":37400,"action":"FC","parameter":"#000000"},{"timestamp":37600,"action":"FC","parameter":"#000000"},{"timestamp":37800,"action":"FC","parameter":"#000000"},{"timestamp":38000,"action":"FC","parameter":"#000000"}]}]}}]
	};
	
	socket.emit('action_diff', actionDiffMessage);
	
	return false;
});

$("#zones_5_start").click(function(){
	var startRequest = {
			show_id : current_show_id, 
		delay: 10,
		sequence_id: 6
	};

	socket.emit('start_delay', startRequest);
	return false;
});


$("#zones_6_question").click(function(){
	var questionRequest = {show_id : current_show_id, id : "zone", "title":"Dans quelle zone vous trouvez vous ?","options":[{"title":"Zone 0","value":"z-0"},{"title":"Zone 1","value":"z-1"},{"title":"Zone 2","value":"z-2"},{"title":"Zone 3","value":"z-3"},{"title":"Zone 4","value":"z-4"},{"title":"Zone 5","value":"z-5"}]};
	
	socket.emit('question', questionRequest);
	return false;
});


$("#zones_6_load").click(function(){

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [{"value":"z-0","command":"loading","valueCommand":{"id":7,"title":"sequence Test0","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#FFFFFF"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#00FF00"},{"timestamp":12500,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13500,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#00FF00"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#0000FF"},{"timestamp":18300,"action":"FC","parameter":"#000000"},{"timestamp":18600,"action":"FC","parameter":"#000000"},{"timestamp":18900,"action":"FC","parameter":"#000000"},{"timestamp":19200,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20100,"action":"FC","parameter":"#000000"},{"timestamp":20400,"action":"FC","parameter":"#000000"},{"timestamp":20700,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#0000FF"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#FF00FF"},{"timestamp":21800,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22400,"action":"FC","parameter":"#000000"},{"timestamp":22600,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23000,"action":"FC","parameter":"#000000"},{"timestamp":23200,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23600,"action":"FC","parameter":"#FF00FF"},{"timestamp":23800,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":25000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":26000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":27000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":28000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":29000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":30000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":31000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":32000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":33000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":34000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#00FF00"},{"timestamp":35500,"action":"FC","parameter":"#00FF00"},{"timestamp":36000,"action":"FC","parameter":"#00FF00"},{"timestamp":36500,"action":"FC","parameter":"#00FF00"},{"timestamp":37000,"action":"FC","parameter":"#00FF00"},{"timestamp":37500,"action":"FC","parameter":"#00FF00"},{"timestamp":38000,"action":"FC","parameter":"#00FF00"},{"timestamp":38500,"action":"FC","parameter":"#00FF00"},{"timestamp":39000,"action":"FC","parameter":"#00FF00"},{"timestamp":39500,"action":"FC","parameter":"#00FF00"},{"timestamp":40000,"action":"FC","parameter":"#00FF00"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#0000FF"},{"timestamp":40800,"action":"FC","parameter":"#0000FF"},{"timestamp":41100,"action":"FC","parameter":"#0000FF"},{"timestamp":41400,"action":"FC","parameter":"#0000FF"},{"timestamp":41700,"action":"FC","parameter":"#0000FF"},{"timestamp":42000,"action":"FC","parameter":"#0000FF"},{"timestamp":42300,"action":"FC","parameter":"#0000FF"},{"timestamp":42600,"action":"FC","parameter":"#0000FF"},{"timestamp":42900,"action":"FC","parameter":"#0000FF"},{"timestamp":43200,"action":"FC","parameter":"#0000FF"},{"timestamp":43500,"action":"FC","parameter":"#0000FF"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#FF00FF"},{"timestamp":44000,"action":"FC","parameter":"#FF00FF"},{"timestamp":44200,"action":"FC","parameter":"#FF00FF"},{"timestamp":44400,"action":"FC","parameter":"#FF00FF"},{"timestamp":44600,"action":"FC","parameter":"#FF00FF"},{"timestamp":44800,"action":"FC","parameter":"#FF00FF"},{"timestamp":45000,"action":"FC","parameter":"#FF00FF"},{"timestamp":45200,"action":"FC","parameter":"#FF00FF"},{"timestamp":45400,"action":"FC","parameter":"#FF00FF"},{"timestamp":45600,"action":"FC","parameter":"#FF00FF"},{"timestamp":45800,"action":"FC","parameter":"#FF00FF"},{"timestamp":46000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-1","command":"loading","valueCommand":{"id":7,"title":"sequence Test1","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12500,"action":"FC","parameter":"#00FF00"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13500,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#00FF00"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18300,"action":"FC","parameter":"#0000FF"},{"timestamp":18600,"action":"FC","parameter":"#000000"},{"timestamp":18900,"action":"FC","parameter":"#000000"},{"timestamp":19200,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20100,"action":"FC","parameter":"#000000"},{"timestamp":20400,"action":"FC","parameter":"#000000"},{"timestamp":20700,"action":"FC","parameter":"#0000FF"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21800,"action":"FC","parameter":"#FF00FF"},{"timestamp":22000,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22400,"action":"FC","parameter":"#000000"},{"timestamp":22600,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23000,"action":"FC","parameter":"#000000"},{"timestamp":23200,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#FF00FF"},{"timestamp":23600,"action":"FC","parameter":"#000000"},{"timestamp":23800,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":25000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":26000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":27000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":28000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":29000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":30000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":31000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":32000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":33000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":34000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35500,"action":"FC","parameter":"#00FF00"},{"timestamp":36000,"action":"FC","parameter":"#00FF00"},{"timestamp":36500,"action":"FC","parameter":"#00FF00"},{"timestamp":37000,"action":"FC","parameter":"#00FF00"},{"timestamp":37500,"action":"FC","parameter":"#00FF00"},{"timestamp":38000,"action":"FC","parameter":"#00FF00"},{"timestamp":38500,"action":"FC","parameter":"#00FF00"},{"timestamp":39000,"action":"FC","parameter":"#00FF00"},{"timestamp":39500,"action":"FC","parameter":"#00FF00"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40800,"action":"FC","parameter":"#0000FF"},{"timestamp":41100,"action":"FC","parameter":"#0000FF"},{"timestamp":41400,"action":"FC","parameter":"#0000FF"},{"timestamp":41700,"action":"FC","parameter":"#0000FF"},{"timestamp":42000,"action":"FC","parameter":"#0000FF"},{"timestamp":42300,"action":"FC","parameter":"#0000FF"},{"timestamp":42600,"action":"FC","parameter":"#0000FF"},{"timestamp":42900,"action":"FC","parameter":"#0000FF"},{"timestamp":43200,"action":"FC","parameter":"#0000FF"},{"timestamp":43500,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":44000,"action":"FC","parameter":"#FF00FF"},{"timestamp":44200,"action":"FC","parameter":"#FF00FF"},{"timestamp":44400,"action":"FC","parameter":"#FF00FF"},{"timestamp":44600,"action":"FC","parameter":"#FF00FF"},{"timestamp":44800,"action":"FC","parameter":"#FF00FF"},{"timestamp":45000,"action":"FC","parameter":"#FF00FF"},{"timestamp":45200,"action":"FC","parameter":"#FF00FF"},{"timestamp":45400,"action":"FC","parameter":"#FF00FF"},{"timestamp":45600,"action":"FC","parameter":"#FF00FF"},{"timestamp":45800,"action":"FC","parameter":"#000000"},{"timestamp":46000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-2","command":"loading","valueCommand":{"id":7,"title":"sequence Test2","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12500,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#00FF00"},{"timestamp":13500,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#00FF00"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18300,"action":"FC","parameter":"#000000"},{"timestamp":18600,"action":"FC","parameter":"#0000FF"},{"timestamp":18900,"action":"FC","parameter":"#000000"},{"timestamp":19200,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20100,"action":"FC","parameter":"#000000"},{"timestamp":20400,"action":"FC","parameter":"#0000FF"},{"timestamp":20700,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21800,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#FF00FF"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22400,"action":"FC","parameter":"#000000"},{"timestamp":22600,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23000,"action":"FC","parameter":"#000000"},{"timestamp":23200,"action":"FC","parameter":"#FF00FF"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23600,"action":"FC","parameter":"#000000"},{"timestamp":23800,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":25000,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":27000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":28000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":29000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":30000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":31000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":32000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":33000,"action":"FC","parameter":"#000000"},{"timestamp":34000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35500,"action":"FC","parameter":"#000000"},{"timestamp":36000,"action":"FC","parameter":"#00FF00"},{"timestamp":36500,"action":"FC","parameter":"#00FF00"},{"timestamp":37000,"action":"FC","parameter":"#00FF00"},{"timestamp":37500,"action":"FC","parameter":"#00FF00"},{"timestamp":38000,"action":"FC","parameter":"#00FF00"},{"timestamp":38500,"action":"FC","parameter":"#00FF00"},{"timestamp":39000,"action":"FC","parameter":"#00FF00"},{"timestamp":39500,"action":"FC","parameter":"#000000"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40800,"action":"FC","parameter":"#000000"},{"timestamp":41100,"action":"FC","parameter":"#0000FF"},{"timestamp":41400,"action":"FC","parameter":"#0000FF"},{"timestamp":41700,"action":"FC","parameter":"#0000FF"},{"timestamp":42000,"action":"FC","parameter":"#0000FF"},{"timestamp":42300,"action":"FC","parameter":"#0000FF"},{"timestamp":42600,"action":"FC","parameter":"#0000FF"},{"timestamp":42900,"action":"FC","parameter":"#0000FF"},{"timestamp":43200,"action":"FC","parameter":"#000000"},{"timestamp":43500,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":44000,"action":"FC","parameter":"#000000"},{"timestamp":44200,"action":"FC","parameter":"#FF00FF"},{"timestamp":44400,"action":"FC","parameter":"#FF00FF"},{"timestamp":44600,"action":"FC","parameter":"#FF00FF"},{"timestamp":44800,"action":"FC","parameter":"#FF00FF"},{"timestamp":45000,"action":"FC","parameter":"#FF00FF"},{"timestamp":45200,"action":"FC","parameter":"#FF00FF"},{"timestamp":45400,"action":"FC","parameter":"#FF00FF"},{"timestamp":45600,"action":"FC","parameter":"#000000"},{"timestamp":45800,"action":"FC","parameter":"#000000"},{"timestamp":46000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-3","command":"loading","valueCommand":{"id":7,"title":"sequence Test3","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12500,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13500,"action":"FC","parameter":"#00FF00"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#00FF00"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18300,"action":"FC","parameter":"#000000"},{"timestamp":18600,"action":"FC","parameter":"#000000"},{"timestamp":18900,"action":"FC","parameter":"#0000FF"},{"timestamp":19200,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20100,"action":"FC","parameter":"#0000FF"},{"timestamp":20400,"action":"FC","parameter":"#000000"},{"timestamp":20700,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21800,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#FF00FF"},{"timestamp":22400,"action":"FC","parameter":"#000000"},{"timestamp":22600,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23000,"action":"FC","parameter":"#FF00FF"},{"timestamp":23200,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23600,"action":"FC","parameter":"#000000"},{"timestamp":23800,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":25000,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":28000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":29000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":30000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":31000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":32000,"action":"FC","parameter":"#000000"},{"timestamp":33000,"action":"FC","parameter":"#000000"},{"timestamp":34000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35500,"action":"FC","parameter":"#000000"},{"timestamp":36000,"action":"FC","parameter":"#000000"},{"timestamp":36500,"action":"FC","parameter":"#00FF00"},{"timestamp":37000,"action":"FC","parameter":"#00FF00"},{"timestamp":37500,"action":"FC","parameter":"#00FF00"},{"timestamp":38000,"action":"FC","parameter":"#00FF00"},{"timestamp":38500,"action":"FC","parameter":"#00FF00"},{"timestamp":39000,"action":"FC","parameter":"#000000"},{"timestamp":39500,"action":"FC","parameter":"#000000"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40800,"action":"FC","parameter":"#000000"},{"timestamp":41100,"action":"FC","parameter":"#000000"},{"timestamp":41400,"action":"FC","parameter":"#0000FF"},{"timestamp":41700,"action":"FC","parameter":"#0000FF"},{"timestamp":42000,"action":"FC","parameter":"#0000FF"},{"timestamp":42300,"action":"FC","parameter":"#0000FF"},{"timestamp":42600,"action":"FC","parameter":"#0000FF"},{"timestamp":42900,"action":"FC","parameter":"#000000"},{"timestamp":43200,"action":"FC","parameter":"#000000"},{"timestamp":43500,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":44000,"action":"FC","parameter":"#000000"},{"timestamp":44200,"action":"FC","parameter":"#000000"},{"timestamp":44400,"action":"FC","parameter":"#FF00FF"},{"timestamp":44600,"action":"FC","parameter":"#FF00FF"},{"timestamp":44800,"action":"FC","parameter":"#FF00FF"},{"timestamp":45000,"action":"FC","parameter":"#FF00FF"},{"timestamp":45200,"action":"FC","parameter":"#FF00FF"},{"timestamp":45400,"action":"FC","parameter":"#000000"},{"timestamp":45600,"action":"FC","parameter":"#000000"},{"timestamp":45800,"action":"FC","parameter":"#000000"},{"timestamp":46000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-4","command":"loading","valueCommand":{"id":7,"title":"sequence Test4","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12500,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13500,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#00FF00"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#00FF00"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18300,"action":"FC","parameter":"#000000"},{"timestamp":18600,"action":"FC","parameter":"#000000"},{"timestamp":18900,"action":"FC","parameter":"#000000"},{"timestamp":19200,"action":"FC","parameter":"#0000FF"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":19800,"action":"FC","parameter":"#0000FF"},{"timestamp":20100,"action":"FC","parameter":"#000000"},{"timestamp":20400,"action":"FC","parameter":"#000000"},{"timestamp":20700,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21800,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22400,"action":"FC","parameter":"#FF00FF"},{"timestamp":22600,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#FF00FF"},{"timestamp":23000,"action":"FC","parameter":"#000000"},{"timestamp":23200,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23600,"action":"FC","parameter":"#000000"},{"timestamp":23800,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":25000,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":29000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":30000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":31000,"action":"FC","parameter":"#000000"},{"timestamp":32000,"action":"FC","parameter":"#000000"},{"timestamp":33000,"action":"FC","parameter":"#000000"},{"timestamp":34000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35500,"action":"FC","parameter":"#000000"},{"timestamp":36000,"action":"FC","parameter":"#000000"},{"timestamp":36500,"action":"FC","parameter":"#000000"},{"timestamp":37000,"action":"FC","parameter":"#00FF00"},{"timestamp":37500,"action":"FC","parameter":"#00FF00"},{"timestamp":38000,"action":"FC","parameter":"#00FF00"},{"timestamp":38500,"action":"FC","parameter":"#000000"},{"timestamp":39000,"action":"FC","parameter":"#000000"},{"timestamp":39500,"action":"FC","parameter":"#000000"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40800,"action":"FC","parameter":"#000000"},{"timestamp":41100,"action":"FC","parameter":"#000000"},{"timestamp":41400,"action":"FC","parameter":"#000000"},{"timestamp":41700,"action":"FC","parameter":"#0000FF"},{"timestamp":42000,"action":"FC","parameter":"#0000FF"},{"timestamp":42300,"action":"FC","parameter":"#0000FF"},{"timestamp":42600,"action":"FC","parameter":"#000000"},{"timestamp":42900,"action":"FC","parameter":"#000000"},{"timestamp":43200,"action":"FC","parameter":"#000000"},{"timestamp":43500,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":44000,"action":"FC","parameter":"#000000"},{"timestamp":44200,"action":"FC","parameter":"#000000"},{"timestamp":44400,"action":"FC","parameter":"#000000"},{"timestamp":44600,"action":"FC","parameter":"#FF00FF"},{"timestamp":44800,"action":"FC","parameter":"#FF00FF"},{"timestamp":45000,"action":"FC","parameter":"#FF00FF"},{"timestamp":45200,"action":"FC","parameter":"#000000"},{"timestamp":45400,"action":"FC","parameter":"#000000"},{"timestamp":45600,"action":"FC","parameter":"#000000"},{"timestamp":45800,"action":"FC","parameter":"#000000"},{"timestamp":46000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-5","command":"loading","valueCommand":{"id":7,"title":"sequence Test5","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":12500,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":13500,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#00FF00"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18300,"action":"FC","parameter":"#000000"},{"timestamp":18600,"action":"FC","parameter":"#000000"},{"timestamp":18900,"action":"FC","parameter":"#000000"},{"timestamp":19200,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#0000FF"},{"timestamp":19800,"action":"FC","parameter":"#000000"},{"timestamp":20100,"action":"FC","parameter":"#000000"},{"timestamp":20400,"action":"FC","parameter":"#000000"},{"timestamp":20700,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21800,"action":"FC","parameter":"#000000"},{"timestamp":22000,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22400,"action":"FC","parameter":"#000000"},{"timestamp":22600,"action":"FC","parameter":"#FF00FF"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23000,"action":"FC","parameter":"#000000"},{"timestamp":23200,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23600,"action":"FC","parameter":"#000000"},{"timestamp":23800,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":25000,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":30000,"action":"FC","parameter":"#000000"},{"timestamp":31000,"action":"FC","parameter":"#000000"},{"timestamp":32000,"action":"FC","parameter":"#000000"},{"timestamp":33000,"action":"FC","parameter":"#000000"},{"timestamp":34000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":35500,"action":"FC","parameter":"#000000"},{"timestamp":36000,"action":"FC","parameter":"#000000"},{"timestamp":36500,"action":"FC","parameter":"#000000"},{"timestamp":37000,"action":"FC","parameter":"#000000"},{"timestamp":37500,"action":"FC","parameter":"#00FF00"},{"timestamp":38000,"action":"FC","parameter":"#000000"},{"timestamp":38500,"action":"FC","parameter":"#000000"},{"timestamp":39000,"action":"FC","parameter":"#000000"},{"timestamp":39500,"action":"FC","parameter":"#000000"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40500,"action":"FC","parameter":"#000000"},{"timestamp":40800,"action":"FC","parameter":"#000000"},{"timestamp":41100,"action":"FC","parameter":"#000000"},{"timestamp":41400,"action":"FC","parameter":"#000000"},{"timestamp":41700,"action":"FC","parameter":"#000000"},{"timestamp":42000,"action":"FC","parameter":"#0000FF"},{"timestamp":42300,"action":"FC","parameter":"#000000"},{"timestamp":42600,"action":"FC","parameter":"#000000"},{"timestamp":42900,"action":"FC","parameter":"#000000"},{"timestamp":43200,"action":"FC","parameter":"#000000"},{"timestamp":43500,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":43800,"action":"FC","parameter":"#000000"},{"timestamp":44000,"action":"FC","parameter":"#000000"},{"timestamp":44200,"action":"FC","parameter":"#000000"},{"timestamp":44400,"action":"FC","parameter":"#000000"},{"timestamp":44600,"action":"FC","parameter":"#000000"},{"timestamp":44800,"action":"FC","parameter":"#FF00FF"},{"timestamp":45000,"action":"FC","parameter":"#000000"},{"timestamp":45200,"action":"FC","parameter":"#000000"},{"timestamp":45400,"action":"FC","parameter":"#000000"},{"timestamp":45600,"action":"FC","parameter":"#000000"},{"timestamp":45800,"action":"FC","parameter":"#000000"},{"timestamp":46000,"action":"FC","parameter":"#000000"}]}]}}]
	};
	
	socket.emit('action_diff', actionDiffMessage);
	
	return false;
});

$("#zones_6_start").click(function(){
	var startRequest = {
			show_id : current_show_id, 
		delay: 10,
		sequence_id: 7
	};

	socket.emit('start_delay', startRequest);
	return false;
});

$("#zones_7_question").click(function(){
	var questionRequest = {show_id : current_show_id, id : "zone", "title":"Dans quelle zone vous trouvez vous ?","options":[{"title":"Zone 0","value":"z-0"},{"title":"Zone 1","value":"z-1"},{"title":"Zone 2","value":"z-2"},{"title":"Zone 3","value":"z-3"},{"title":"Zone 4","value":"z-4"},{"title":"Zone 5","value":"z-5"},{"title":"Zone 6","value":"z-6"}]};
	
	socket.emit('question', questionRequest);
	return false;
});


$("#zones_7_load").click(function(){

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [{"value":"z-0","command":"loading","valueCommand":{"id":8,"title":"sequence Test0","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#FFFFFF"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#00FF00"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18500,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#00FF00"},{"timestamp":20500,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#0000FF"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21900,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22500,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23100,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23700,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":24300,"action":"FC","parameter":"#000000"},{"timestamp":24600,"action":"FC","parameter":"#0000FF"},{"timestamp":24900,"action":"FC","parameter":"#000000"},{"timestamp":25200,"action":"FC","parameter":"#FF00FF"},{"timestamp":25400,"action":"FC","parameter":"#000000"},{"timestamp":25600,"action":"FC","parameter":"#000000"},{"timestamp":25800,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":26200,"action":"FC","parameter":"#000000"},{"timestamp":26400,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26800,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":27200,"action":"FC","parameter":"#000000"},{"timestamp":27400,"action":"FC","parameter":"#000000"},{"timestamp":27600,"action":"FC","parameter":"#FF00FF"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":29000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":30000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":31000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":32000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":33000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":34000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":35000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":36000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":37000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":38000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":39000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":40000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#00FF00"},{"timestamp":41500,"action":"FC","parameter":"#00FF00"},{"timestamp":42000,"action":"FC","parameter":"#00FF00"},{"timestamp":42500,"action":"FC","parameter":"#00FF00"},{"timestamp":43000,"action":"FC","parameter":"#00FF00"},{"timestamp":43500,"action":"FC","parameter":"#00FF00"},{"timestamp":44000,"action":"FC","parameter":"#00FF00"},{"timestamp":44500,"action":"FC","parameter":"#00FF00"},{"timestamp":45000,"action":"FC","parameter":"#00FF00"},{"timestamp":45500,"action":"FC","parameter":"#00FF00"},{"timestamp":46000,"action":"FC","parameter":"#00FF00"},{"timestamp":46500,"action":"FC","parameter":"#00FF00"},{"timestamp":47000,"action":"FC","parameter":"#00FF00"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#0000FF"},{"timestamp":47800,"action":"FC","parameter":"#0000FF"},{"timestamp":48100,"action":"FC","parameter":"#0000FF"},{"timestamp":48400,"action":"FC","parameter":"#0000FF"},{"timestamp":48700,"action":"FC","parameter":"#0000FF"},{"timestamp":49000,"action":"FC","parameter":"#0000FF"},{"timestamp":49300,"action":"FC","parameter":"#0000FF"},{"timestamp":49600,"action":"FC","parameter":"#0000FF"},{"timestamp":49900,"action":"FC","parameter":"#0000FF"},{"timestamp":50200,"action":"FC","parameter":"#0000FF"},{"timestamp":50500,"action":"FC","parameter":"#0000FF"},{"timestamp":50800,"action":"FC","parameter":"#0000FF"},{"timestamp":51100,"action":"FC","parameter":"#0000FF"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#FF00FF"},{"timestamp":51600,"action":"FC","parameter":"#FF00FF"},{"timestamp":51800,"action":"FC","parameter":"#FF00FF"},{"timestamp":52000,"action":"FC","parameter":"#FF00FF"},{"timestamp":52200,"action":"FC","parameter":"#FF00FF"},{"timestamp":52400,"action":"FC","parameter":"#FF00FF"},{"timestamp":52600,"action":"FC","parameter":"#FF00FF"},{"timestamp":52800,"action":"FC","parameter":"#FF00FF"},{"timestamp":53000,"action":"FC","parameter":"#FF00FF"},{"timestamp":53200,"action":"FC","parameter":"#FF00FF"},{"timestamp":53400,"action":"FC","parameter":"#FF00FF"},{"timestamp":53600,"action":"FC","parameter":"#FF00FF"},{"timestamp":53800,"action":"FC","parameter":"#FF00FF"},{"timestamp":54000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-1","command":"loading","valueCommand":{"id":8,"title":"sequence Test1","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#00FF00"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18500,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#00FF00"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":20500,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#0000FF"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21900,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22500,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23100,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23700,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":24300,"action":"FC","parameter":"#0000FF"},{"timestamp":24600,"action":"FC","parameter":"#000000"},{"timestamp":24900,"action":"FC","parameter":"#000000"},{"timestamp":25200,"action":"FC","parameter":"#000000"},{"timestamp":25400,"action":"FC","parameter":"#FF00FF"},{"timestamp":25600,"action":"FC","parameter":"#000000"},{"timestamp":25800,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":26200,"action":"FC","parameter":"#000000"},{"timestamp":26400,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26800,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":27200,"action":"FC","parameter":"#000000"},{"timestamp":27400,"action":"FC","parameter":"#FF00FF"},{"timestamp":27600,"action":"FC","parameter":"#000000"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":30000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":31000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":32000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":33000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":34000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":35000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":36000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":37000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":38000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":39000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41500,"action":"FC","parameter":"#00FF00"},{"timestamp":42000,"action":"FC","parameter":"#00FF00"},{"timestamp":42500,"action":"FC","parameter":"#00FF00"},{"timestamp":43000,"action":"FC","parameter":"#00FF00"},{"timestamp":43500,"action":"FC","parameter":"#00FF00"},{"timestamp":44000,"action":"FC","parameter":"#00FF00"},{"timestamp":44500,"action":"FC","parameter":"#00FF00"},{"timestamp":45000,"action":"FC","parameter":"#00FF00"},{"timestamp":45500,"action":"FC","parameter":"#00FF00"},{"timestamp":46000,"action":"FC","parameter":"#00FF00"},{"timestamp":46500,"action":"FC","parameter":"#00FF00"},{"timestamp":47000,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47800,"action":"FC","parameter":"#0000FF"},{"timestamp":48100,"action":"FC","parameter":"#0000FF"},{"timestamp":48400,"action":"FC","parameter":"#0000FF"},{"timestamp":48700,"action":"FC","parameter":"#0000FF"},{"timestamp":49000,"action":"FC","parameter":"#0000FF"},{"timestamp":49300,"action":"FC","parameter":"#0000FF"},{"timestamp":49600,"action":"FC","parameter":"#0000FF"},{"timestamp":49900,"action":"FC","parameter":"#0000FF"},{"timestamp":50200,"action":"FC","parameter":"#0000FF"},{"timestamp":50500,"action":"FC","parameter":"#0000FF"},{"timestamp":50800,"action":"FC","parameter":"#0000FF"},{"timestamp":51100,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51600,"action":"FC","parameter":"#FF00FF"},{"timestamp":51800,"action":"FC","parameter":"#FF00FF"},{"timestamp":52000,"action":"FC","parameter":"#FF00FF"},{"timestamp":52200,"action":"FC","parameter":"#FF00FF"},{"timestamp":52400,"action":"FC","parameter":"#FF00FF"},{"timestamp":52600,"action":"FC","parameter":"#FF00FF"},{"timestamp":52800,"action":"FC","parameter":"#FF00FF"},{"timestamp":53000,"action":"FC","parameter":"#FF00FF"},{"timestamp":53200,"action":"FC","parameter":"#FF00FF"},{"timestamp":53400,"action":"FC","parameter":"#FF00FF"},{"timestamp":53600,"action":"FC","parameter":"#FF00FF"},{"timestamp":53800,"action":"FC","parameter":"#000000"},{"timestamp":54000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-2","command":"loading","valueCommand":{"id":8,"title":"sequence Test2","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#00FF00"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18500,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#00FF00"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":20500,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#0000FF"},{"timestamp":21900,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22500,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23100,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23700,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#0000FF"},{"timestamp":24300,"action":"FC","parameter":"#000000"},{"timestamp":24600,"action":"FC","parameter":"#000000"},{"timestamp":24900,"action":"FC","parameter":"#000000"},{"timestamp":25200,"action":"FC","parameter":"#000000"},{"timestamp":25400,"action":"FC","parameter":"#000000"},{"timestamp":25600,"action":"FC","parameter":"#FF00FF"},{"timestamp":25800,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":26200,"action":"FC","parameter":"#000000"},{"timestamp":26400,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26800,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":27200,"action":"FC","parameter":"#FF00FF"},{"timestamp":27400,"action":"FC","parameter":"#000000"},{"timestamp":27600,"action":"FC","parameter":"#000000"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":30000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":31000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":32000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":33000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":34000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":35000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":36000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":37000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":38000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":39000,"action":"FC","parameter":"#000000"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41500,"action":"FC","parameter":"#000000"},{"timestamp":42000,"action":"FC","parameter":"#00FF00"},{"timestamp":42500,"action":"FC","parameter":"#00FF00"},{"timestamp":43000,"action":"FC","parameter":"#00FF00"},{"timestamp":43500,"action":"FC","parameter":"#00FF00"},{"timestamp":44000,"action":"FC","parameter":"#00FF00"},{"timestamp":44500,"action":"FC","parameter":"#00FF00"},{"timestamp":45000,"action":"FC","parameter":"#00FF00"},{"timestamp":45500,"action":"FC","parameter":"#00FF00"},{"timestamp":46000,"action":"FC","parameter":"#00FF00"},{"timestamp":46500,"action":"FC","parameter":"#000000"},{"timestamp":47000,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47800,"action":"FC","parameter":"#000000"},{"timestamp":48100,"action":"FC","parameter":"#0000FF"},{"timestamp":48400,"action":"FC","parameter":"#0000FF"},{"timestamp":48700,"action":"FC","parameter":"#0000FF"},{"timestamp":49000,"action":"FC","parameter":"#0000FF"},{"timestamp":49300,"action":"FC","parameter":"#0000FF"},{"timestamp":49600,"action":"FC","parameter":"#0000FF"},{"timestamp":49900,"action":"FC","parameter":"#0000FF"},{"timestamp":50200,"action":"FC","parameter":"#0000FF"},{"timestamp":50500,"action":"FC","parameter":"#0000FF"},{"timestamp":50800,"action":"FC","parameter":"#000000"},{"timestamp":51100,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51600,"action":"FC","parameter":"#000000"},{"timestamp":51800,"action":"FC","parameter":"#FF00FF"},{"timestamp":52000,"action":"FC","parameter":"#FF00FF"},{"timestamp":52200,"action":"FC","parameter":"#FF00FF"},{"timestamp":52400,"action":"FC","parameter":"#FF00FF"},{"timestamp":52600,"action":"FC","parameter":"#FF00FF"},{"timestamp":52800,"action":"FC","parameter":"#FF00FF"},{"timestamp":53000,"action":"FC","parameter":"#FF00FF"},{"timestamp":53200,"action":"FC","parameter":"#FF00FF"},{"timestamp":53400,"action":"FC","parameter":"#FF00FF"},{"timestamp":53600,"action":"FC","parameter":"#000000"},{"timestamp":53800,"action":"FC","parameter":"#000000"},{"timestamp":54000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-3","command":"loading","valueCommand":{"id":8,"title":"sequence Test3","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#00FF00"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18500,"action":"FC","parameter":"#00FF00"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":20500,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21900,"action":"FC","parameter":"#0000FF"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22500,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23100,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23700,"action":"FC","parameter":"#0000FF"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":24300,"action":"FC","parameter":"#000000"},{"timestamp":24600,"action":"FC","parameter":"#000000"},{"timestamp":24900,"action":"FC","parameter":"#000000"},{"timestamp":25200,"action":"FC","parameter":"#000000"},{"timestamp":25400,"action":"FC","parameter":"#000000"},{"timestamp":25600,"action":"FC","parameter":"#000000"},{"timestamp":25800,"action":"FC","parameter":"#FF00FF"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":26200,"action":"FC","parameter":"#000000"},{"timestamp":26400,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26800,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#FF00FF"},{"timestamp":27200,"action":"FC","parameter":"#000000"},{"timestamp":27400,"action":"FC","parameter":"#000000"},{"timestamp":27600,"action":"FC","parameter":"#000000"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":30000,"action":"FC","parameter":"#000000"},{"timestamp":31000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":32000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":33000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":34000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":35000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":36000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":37000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":38000,"action":"FC","parameter":"#000000"},{"timestamp":39000,"action":"FC","parameter":"#000000"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41500,"action":"FC","parameter":"#000000"},{"timestamp":42000,"action":"FC","parameter":"#000000"},{"timestamp":42500,"action":"FC","parameter":"#00FF00"},{"timestamp":43000,"action":"FC","parameter":"#00FF00"},{"timestamp":43500,"action":"FC","parameter":"#00FF00"},{"timestamp":44000,"action":"FC","parameter":"#00FF00"},{"timestamp":44500,"action":"FC","parameter":"#00FF00"},{"timestamp":45000,"action":"FC","parameter":"#00FF00"},{"timestamp":45500,"action":"FC","parameter":"#00FF00"},{"timestamp":46000,"action":"FC","parameter":"#000000"},{"timestamp":46500,"action":"FC","parameter":"#000000"},{"timestamp":47000,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47800,"action":"FC","parameter":"#000000"},{"timestamp":48100,"action":"FC","parameter":"#000000"},{"timestamp":48400,"action":"FC","parameter":"#0000FF"},{"timestamp":48700,"action":"FC","parameter":"#0000FF"},{"timestamp":49000,"action":"FC","parameter":"#0000FF"},{"timestamp":49300,"action":"FC","parameter":"#0000FF"},{"timestamp":49600,"action":"FC","parameter":"#0000FF"},{"timestamp":49900,"action":"FC","parameter":"#0000FF"},{"timestamp":50200,"action":"FC","parameter":"#0000FF"},{"timestamp":50500,"action":"FC","parameter":"#000000"},{"timestamp":50800,"action":"FC","parameter":"#000000"},{"timestamp":51100,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51600,"action":"FC","parameter":"#000000"},{"timestamp":51800,"action":"FC","parameter":"#000000"},{"timestamp":52000,"action":"FC","parameter":"#FF00FF"},{"timestamp":52200,"action":"FC","parameter":"#FF00FF"},{"timestamp":52400,"action":"FC","parameter":"#FF00FF"},{"timestamp":52600,"action":"FC","parameter":"#FF00FF"},{"timestamp":52800,"action":"FC","parameter":"#FF00FF"},{"timestamp":53000,"action":"FC","parameter":"#FF00FF"},{"timestamp":53200,"action":"FC","parameter":"#FF00FF"},{"timestamp":53400,"action":"FC","parameter":"#000000"},{"timestamp":53600,"action":"FC","parameter":"#000000"},{"timestamp":53800,"action":"FC","parameter":"#000000"},{"timestamp":54000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-4","command":"loading","valueCommand":{"id":8,"title":"sequence Test4","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#00FF00"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#00FF00"},{"timestamp":18500,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":20500,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21900,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#0000FF"},{"timestamp":22500,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23100,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#0000FF"},{"timestamp":23700,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":24300,"action":"FC","parameter":"#000000"},{"timestamp":24600,"action":"FC","parameter":"#000000"},{"timestamp":24900,"action":"FC","parameter":"#000000"},{"timestamp":25200,"action":"FC","parameter":"#000000"},{"timestamp":25400,"action":"FC","parameter":"#000000"},{"timestamp":25600,"action":"FC","parameter":"#000000"},{"timestamp":25800,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#FF00FF"},{"timestamp":26200,"action":"FC","parameter":"#000000"},{"timestamp":26400,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26800,"action":"FC","parameter":"#FF00FF"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":27200,"action":"FC","parameter":"#000000"},{"timestamp":27400,"action":"FC","parameter":"#000000"},{"timestamp":27600,"action":"FC","parameter":"#000000"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":30000,"action":"FC","parameter":"#000000"},{"timestamp":31000,"action":"FC","parameter":"#000000"},{"timestamp":32000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":33000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":34000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":35000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":36000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":37000,"action":"FC","parameter":"#000000"},{"timestamp":38000,"action":"FC","parameter":"#000000"},{"timestamp":39000,"action":"FC","parameter":"#000000"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41500,"action":"FC","parameter":"#000000"},{"timestamp":42000,"action":"FC","parameter":"#000000"},{"timestamp":42500,"action":"FC","parameter":"#000000"},{"timestamp":43000,"action":"FC","parameter":"#00FF00"},{"timestamp":43500,"action":"FC","parameter":"#00FF00"},{"timestamp":44000,"action":"FC","parameter":"#00FF00"},{"timestamp":44500,"action":"FC","parameter":"#00FF00"},{"timestamp":45000,"action":"FC","parameter":"#00FF00"},{"timestamp":45500,"action":"FC","parameter":"#000000"},{"timestamp":46000,"action":"FC","parameter":"#000000"},{"timestamp":46500,"action":"FC","parameter":"#000000"},{"timestamp":47000,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47800,"action":"FC","parameter":"#000000"},{"timestamp":48100,"action":"FC","parameter":"#000000"},{"timestamp":48400,"action":"FC","parameter":"#000000"},{"timestamp":48700,"action":"FC","parameter":"#0000FF"},{"timestamp":49000,"action":"FC","parameter":"#0000FF"},{"timestamp":49300,"action":"FC","parameter":"#0000FF"},{"timestamp":49600,"action":"FC","parameter":"#0000FF"},{"timestamp":49900,"action":"FC","parameter":"#0000FF"},{"timestamp":50200,"action":"FC","parameter":"#000000"},{"timestamp":50500,"action":"FC","parameter":"#000000"},{"timestamp":50800,"action":"FC","parameter":"#000000"},{"timestamp":51100,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51600,"action":"FC","parameter":"#000000"},{"timestamp":51800,"action":"FC","parameter":"#000000"},{"timestamp":52000,"action":"FC","parameter":"#000000"},{"timestamp":52200,"action":"FC","parameter":"#FF00FF"},{"timestamp":52400,"action":"FC","parameter":"#FF00FF"},{"timestamp":52600,"action":"FC","parameter":"#FF00FF"},{"timestamp":52800,"action":"FC","parameter":"#FF00FF"},{"timestamp":53000,"action":"FC","parameter":"#FF00FF"},{"timestamp":53200,"action":"FC","parameter":"#000000"},{"timestamp":53400,"action":"FC","parameter":"#000000"},{"timestamp":53600,"action":"FC","parameter":"#000000"},{"timestamp":53800,"action":"FC","parameter":"#000000"},{"timestamp":54000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-5","command":"loading","valueCommand":{"id":8,"title":"sequence Test5","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":6000,"action":"FC","parameter":"#000000"},{"timestamp":7000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#00FF00"},{"timestamp":17000,"action":"FC","parameter":"#000000"},{"timestamp":17500,"action":"FC","parameter":"#00FF00"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18500,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":20500,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21900,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22500,"action":"FC","parameter":"#0000FF"},{"timestamp":22800,"action":"FC","parameter":"#000000"},{"timestamp":23100,"action":"FC","parameter":"#0000FF"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23700,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":24300,"action":"FC","parameter":"#000000"},{"timestamp":24600,"action":"FC","parameter":"#000000"},{"timestamp":24900,"action":"FC","parameter":"#000000"},{"timestamp":25200,"action":"FC","parameter":"#000000"},{"timestamp":25400,"action":"FC","parameter":"#000000"},{"timestamp":25600,"action":"FC","parameter":"#000000"},{"timestamp":25800,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":26200,"action":"FC","parameter":"#FF00FF"},{"timestamp":26400,"action":"FC","parameter":"#000000"},{"timestamp":26600,"action":"FC","parameter":"#FF00FF"},{"timestamp":26800,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":27200,"action":"FC","parameter":"#000000"},{"timestamp":27400,"action":"FC","parameter":"#000000"},{"timestamp":27600,"action":"FC","parameter":"#000000"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":30000,"action":"FC","parameter":"#000000"},{"timestamp":31000,"action":"FC","parameter":"#000000"},{"timestamp":32000,"action":"FC","parameter":"#000000"},{"timestamp":33000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":34000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":35000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":36000,"action":"FC","parameter":"#000000"},{"timestamp":37000,"action":"FC","parameter":"#000000"},{"timestamp":38000,"action":"FC","parameter":"#000000"},{"timestamp":39000,"action":"FC","parameter":"#000000"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41500,"action":"FC","parameter":"#000000"},{"timestamp":42000,"action":"FC","parameter":"#000000"},{"timestamp":42500,"action":"FC","parameter":"#000000"},{"timestamp":43000,"action":"FC","parameter":"#000000"},{"timestamp":43500,"action":"FC","parameter":"#00FF00"},{"timestamp":44000,"action":"FC","parameter":"#00FF00"},{"timestamp":44500,"action":"FC","parameter":"#00FF00"},{"timestamp":45000,"action":"FC","parameter":"#000000"},{"timestamp":45500,"action":"FC","parameter":"#000000"},{"timestamp":46000,"action":"FC","parameter":"#000000"},{"timestamp":46500,"action":"FC","parameter":"#000000"},{"timestamp":47000,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47800,"action":"FC","parameter":"#000000"},{"timestamp":48100,"action":"FC","parameter":"#000000"},{"timestamp":48400,"action":"FC","parameter":"#000000"},{"timestamp":48700,"action":"FC","parameter":"#000000"},{"timestamp":49000,"action":"FC","parameter":"#0000FF"},{"timestamp":49300,"action":"FC","parameter":"#0000FF"},{"timestamp":49600,"action":"FC","parameter":"#0000FF"},{"timestamp":49900,"action":"FC","parameter":"#000000"},{"timestamp":50200,"action":"FC","parameter":"#000000"},{"timestamp":50500,"action":"FC","parameter":"#000000"},{"timestamp":50800,"action":"FC","parameter":"#000000"},{"timestamp":51100,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51600,"action":"FC","parameter":"#000000"},{"timestamp":51800,"action":"FC","parameter":"#000000"},{"timestamp":52000,"action":"FC","parameter":"#000000"},{"timestamp":52200,"action":"FC","parameter":"#000000"},{"timestamp":52400,"action":"FC","parameter":"#FF00FF"},{"timestamp":52600,"action":"FC","parameter":"#FF00FF"},{"timestamp":52800,"action":"FC","parameter":"#FF00FF"},{"timestamp":53000,"action":"FC","parameter":"#000000"},{"timestamp":53200,"action":"FC","parameter":"#000000"},{"timestamp":53400,"action":"FC","parameter":"#000000"},{"timestamp":53600,"action":"FC","parameter":"#000000"},{"timestamp":53800,"action":"FC","parameter":"#000000"},{"timestamp":54000,"action":"FC","parameter":"#000000"}]}]}},{"value":"z-6","command":"loading","valueCommand":{"id":8,"title":"sequence Test6","video":"","audio":"","actionTrackList":[{"timedActionList":[{"timestamp":0,"action":"FC","parameter":"#000000"},{"timestamp":1000,"action":"FC","parameter":"#000000"},{"timestamp":2000,"action":"FC","parameter":"#000000"},{"timestamp":3000,"action":"FC","parameter":"#000000"},{"timestamp":4000,"action":"FC","parameter":"#000000"},{"timestamp":5000,"action":"FC","parameter":"#000000"},{"timestamp":6000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":7000,"action":"FC","parameter":"#000000"},{"timestamp":8000,"action":"FC","parameter":"#000000"},{"timestamp":9000,"action":"FC","parameter":"#000000"},{"timestamp":10000,"action":"FC","parameter":"#000000"},{"timestamp":11000,"action":"FC","parameter":"#000000"},{"timestamp":12000,"action":"FC","parameter":"#000000"},{"timestamp":13000,"action":"FC","parameter":"#000000"},{"timestamp":14000,"action":"FC","parameter":"#000000"},{"timestamp":14500,"action":"FC","parameter":"#000000"},{"timestamp":15000,"action":"FC","parameter":"#000000"},{"timestamp":15500,"action":"FC","parameter":"#000000"},{"timestamp":16000,"action":"FC","parameter":"#000000"},{"timestamp":16500,"action":"FC","parameter":"#000000"},{"timestamp":17000,"action":"FC","parameter":"#00FF00"},{"timestamp":17500,"action":"FC","parameter":"#000000"},{"timestamp":18000,"action":"FC","parameter":"#000000"},{"timestamp":18500,"action":"FC","parameter":"#000000"},{"timestamp":19000,"action":"FC","parameter":"#000000"},{"timestamp":19500,"action":"FC","parameter":"#000000"},{"timestamp":20000,"action":"FC","parameter":"#000000"},{"timestamp":20500,"action":"FC","parameter":"#000000"},{"timestamp":21000,"action":"FC","parameter":"#000000"},{"timestamp":21300,"action":"FC","parameter":"#000000"},{"timestamp":21600,"action":"FC","parameter":"#000000"},{"timestamp":21900,"action":"FC","parameter":"#000000"},{"timestamp":22200,"action":"FC","parameter":"#000000"},{"timestamp":22500,"action":"FC","parameter":"#000000"},{"timestamp":22800,"action":"FC","parameter":"#0000FF"},{"timestamp":23100,"action":"FC","parameter":"#000000"},{"timestamp":23400,"action":"FC","parameter":"#000000"},{"timestamp":23700,"action":"FC","parameter":"#000000"},{"timestamp":24000,"action":"FC","parameter":"#000000"},{"timestamp":24300,"action":"FC","parameter":"#000000"},{"timestamp":24600,"action":"FC","parameter":"#000000"},{"timestamp":24900,"action":"FC","parameter":"#000000"},{"timestamp":25200,"action":"FC","parameter":"#000000"},{"timestamp":25400,"action":"FC","parameter":"#000000"},{"timestamp":25600,"action":"FC","parameter":"#000000"},{"timestamp":25800,"action":"FC","parameter":"#000000"},{"timestamp":26000,"action":"FC","parameter":"#000000"},{"timestamp":26200,"action":"FC","parameter":"#000000"},{"timestamp":26400,"action":"FC","parameter":"#FF00FF"},{"timestamp":26600,"action":"FC","parameter":"#000000"},{"timestamp":26800,"action":"FC","parameter":"#000000"},{"timestamp":27000,"action":"FC","parameter":"#000000"},{"timestamp":27200,"action":"FC","parameter":"#000000"},{"timestamp":27400,"action":"FC","parameter":"#000000"},{"timestamp":27600,"action":"FC","parameter":"#000000"},{"timestamp":27800,"action":"FC","parameter":"#000000"},{"timestamp":28000,"action":"FC","parameter":"#000000"},{"timestamp":29000,"action":"FC","parameter":"#000000"},{"timestamp":30000,"action":"FC","parameter":"#000000"},{"timestamp":31000,"action":"FC","parameter":"#000000"},{"timestamp":32000,"action":"FC","parameter":"#000000"},{"timestamp":33000,"action":"FC","parameter":"#000000"},{"timestamp":34000,"action":"FC","parameter":"#FFFFFF"},{"timestamp":35000,"action":"FC","parameter":"#000000"},{"timestamp":36000,"action":"FC","parameter":"#000000"},{"timestamp":37000,"action":"FC","parameter":"#000000"},{"timestamp":38000,"action":"FC","parameter":"#000000"},{"timestamp":39000,"action":"FC","parameter":"#000000"},{"timestamp":40000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41000,"action":"FC","parameter":"#000000"},{"timestamp":41500,"action":"FC","parameter":"#000000"},{"timestamp":42000,"action":"FC","parameter":"#000000"},{"timestamp":42500,"action":"FC","parameter":"#000000"},{"timestamp":43000,"action":"FC","parameter":"#000000"},{"timestamp":43500,"action":"FC","parameter":"#000000"},{"timestamp":44000,"action":"FC","parameter":"#00FF00"},{"timestamp":44500,"action":"FC","parameter":"#000000"},{"timestamp":45000,"action":"FC","parameter":"#000000"},{"timestamp":45500,"action":"FC","parameter":"#000000"},{"timestamp":46000,"action":"FC","parameter":"#000000"},{"timestamp":46500,"action":"FC","parameter":"#000000"},{"timestamp":47000,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47500,"action":"FC","parameter":"#000000"},{"timestamp":47800,"action":"FC","parameter":"#000000"},{"timestamp":48100,"action":"FC","parameter":"#000000"},{"timestamp":48400,"action":"FC","parameter":"#000000"},{"timestamp":48700,"action":"FC","parameter":"#000000"},{"timestamp":49000,"action":"FC","parameter":"#000000"},{"timestamp":49300,"action":"FC","parameter":"#0000FF"},{"timestamp":49600,"action":"FC","parameter":"#000000"},{"timestamp":49900,"action":"FC","parameter":"#000000"},{"timestamp":50200,"action":"FC","parameter":"#000000"},{"timestamp":50500,"action":"FC","parameter":"#000000"},{"timestamp":50800,"action":"FC","parameter":"#000000"},{"timestamp":51100,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51400,"action":"FC","parameter":"#000000"},{"timestamp":51600,"action":"FC","parameter":"#000000"},{"timestamp":51800,"action":"FC","parameter":"#000000"},{"timestamp":52000,"action":"FC","parameter":"#000000"},{"timestamp":52200,"action":"FC","parameter":"#000000"},{"timestamp":52400,"action":"FC","parameter":"#000000"},{"timestamp":52600,"action":"FC","parameter":"#FF00FF"},{"timestamp":52800,"action":"FC","parameter":"#000000"},{"timestamp":53000,"action":"FC","parameter":"#000000"},{"timestamp":53200,"action":"FC","parameter":"#000000"},{"timestamp":53400,"action":"FC","parameter":"#000000"},{"timestamp":53600,"action":"FC","parameter":"#000000"},{"timestamp":53800,"action":"FC","parameter":"#000000"},{"timestamp":54000,"action":"FC","parameter":"#000000"}]}]}}]
	};
	
	socket.emit('action_diff', actionDiffMessage);
	
	return false;
});

$("#zones_7_start").click(function(){
	var startRequest = {
			show_id : current_show_id, 
		delay: 10,
		sequence_id: 8
	};

	socket.emit('start_delay', startRequest);
	return false;
});


//##################################################
//# MIDI
//##################################################

$("#midi_tetris_question").click(function(){

	var questionOptionTrack1 = {title: "Piste 1 (Mélodie)", value:"track1"};
	var questionOptionTrack2 = {title: "Piste 2 (Mélodie Secondaire)", value:"track2"};
	var questionOptionTrack3 = {title: "Piste 3 (Basse)", value:"track3"};
	var questionOptionTrack4 = {title: "Piste 4 (Batterie)", value:"track4"};

	var questionOptionsList = [questionOptionTrack1, questionOptionTrack2, questionOptionTrack3, questionOptionTrack4];

	var questionRequest = {
			show_id : current_show_id, 
		id : "track",
		title: "Choisissez une piste ?",
		options: questionOptionsList
	};

	socket.emit('question', questionRequest);
	return false;
});

$("#load_midi_tetris_full").click(function(){
	var action = {
			show_id : current_show_id, 
        action: 'LOAD',
        value: "http://"+serverURL+"/content/midi/tetris.mid",
    };

    socket.emit('action', action);
	return false;
});
$("#load_midi_tetris_track1").click(function(){
	var action = {
			show_id : current_show_id, 
        action: 'LOAD',
        value: "http://"+serverURL+"/content/midi/tetris_track1.mid",
    };

    socket.emit('action', action);
	return false;
});
$("#load_midi_tetris_track2").click(function(){
	var action = {
			show_id : current_show_id, 
        action: 'LOAD',
        value: "http://"+serverURL+"/content/midi/tetris_track2.mid",
    };

    socket.emit('action', action);
	return false;
});
$("#load_midi_tetris_track3").click(function(){
	var action = {
			show_id : current_show_id, 
        action: 'LOAD',
        value: "http://"+serverURL+"/content/midi/tetris_track3.mid",
    };

    socket.emit('action', action);
	return false;
});
$("#load_midi_tetris_track4").click(function(){
	var action = {
			show_id : current_show_id, 
        action: 'LOAD',
        value: "http://"+serverURL+"/content/midi/tetris_track4.mid",
    };

    socket.emit('action', action);
	return false;
});


$("#midi_tetris_full").click(function(){
	var action = {
			show_id : current_show_id, 
        action: 'MIDI',
        value: "http://"+serverURL+"/content/midi/tetris.mid",
    };

    socket.emit('action', action);
	return false;
});


$("#midi_tetris_track1").click(function(){
	var action = {
			show_id : current_show_id, 
	        action: 'MIDI',
	        value: "http://"+serverURL+"/content/midi/tetris_track1.mid",
	    };

	    socket.emit('action', action);
		return false;
});
$("#midi_tetris_track2").click(function(){
	var action = {
			show_id : current_show_id, 
	        action: 'MIDI',
	        value: "http://"+serverURL+"content/midi/tetris_track2.mid",
	    };

	    socket.emit('action', action);
		return false;
});
$("#midi_tetris_track3").click(function(){
	var action = {
			show_id : current_show_id, 
	        action: 'MIDI',
	        value: "http://"+serverURL+"/content/midi/tetris_track3.mid",
	    };

	    socket.emit('action', action);
		return false;
});
$("#midi_tetris_track4").click(function(){
	var action = {
			show_id : current_show_id, 
	        action: 'MIDI',
	        value: "http://"+serverURL+"/content/midi/tetris_track4.mid",
	    };

	    socket.emit('action', action);
		return false;
});

$("#midi_tetris_track_all").click(function(){
	var actionDiffTrack1 = {
		action: 'MIDI',
		value: "tetris_track1.mid"
	};
	var actionDiffTrack2 = {
		action: 'MIDI',
		value: "tetris_track2.mid"
	};
	var actionDiffTrack3 = {
			action: 'MIDI',
			value: "tetris_track3.mid"
		};
		var actionDiffTrack4 = {
			action: 'MIDI',
			value: "tetris_track4.mid"
		};

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'track1', command: 'action', valueCommand: actionDiffTrack1}, {value: 'track2',  command: 'action', valueCommand: actionDiffTrack2}, {value: 'track3',  command: 'action', valueCommand: actionDiffTrack3}, {value: 'track4',  command: 'action', valueCommand: actionDiffTrack4} ]
	};

	socket.emit('action_diff', actionDiffMessage);
	return false;
});


$("#midi_tetris_track_all_sequence").click(function(){

	var actionSequenceMessageTrack1 = {
		id: 10,
		title: "Tetris Track1",
		video: "",
		audio: "",
		actionTrackList: [
			{ timedActionList: [
				{timestamp: 1000, action: "MIDI_P", parameter: "tetris_track1.mid"},
				{timestamp: 0, action: "MIDI", parameter: ""},
				]
			}
		]
	};
	var actionSequenceMessageTrack2 = {
			id: 10,
			title: "Tetris Track2",
			video: "",
			audio: "",
			actionTrackList: [
				{ timedActionList: [
					{timestamp: 1000, action: "MIDI_P", parameter: "tetris_track2.mid"},
					{timestamp: 0, action: "MIDI", parameter: ""},
					]
				}
			]
		};
	var actionSequenceMessageTrack3 = {
			id: 10,
			title: "Tetris Track3",
			video: "",
			audio: "",
			actionTrackList: [
				{ timedActionList: [
					{timestamp: 1000, action: "MIDI_P", parameter: "tetris_track3.mid"},
					{timestamp: 0, action: "MIDI", parameter: ""},
					]
				}
			]
		};
	var actionSequenceMessageTrack4 = {
			id: 10,
			title: "Tetris Track4",
			video: "",
			audio: "",
			actionTrackList: [
				{ timedActionList: [
					{timestamp: 1000, action: "MIDI_P", parameter: "tetris_track4.mid"},
					{timestamp: 0, action: "MIDI", parameter: ""},
					]
				}
			]
		};

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'track1', command: 'loading', valueCommand: actionSequenceMessageTrack1}, {value: 'track2',  command: 'loading', valueCommand: actionSequenceMessageTrack2}, {value: 'track3',  command: 'loading', valueCommand: actionSequenceMessageTrack3}, {value: 'track4',  command: 'loading', valueCommand: actionSequenceMessageTrack4} ]
	};

	socket.emit('action_diff', actionDiffMessage);
	
	return false;
});

$("#midi_tetris_track_all_sequence_start").click(function(){
	var startRequest = {
			show_id : current_show_id, 
		delay: 10,
		sequence_id: 10
	};

	socket.emit('start_delay', startRequest);
	return false;
});


// #####
// # SWAM

$("#swamwill").click(function(){

	var questionOption1 = {title: "William", value:"willw"};
	var questionOption2 = {title: "La paon", value:"willp"};

	var questionOptionsList = [questionOption1, questionOption2];

	var questionRequest = {
			show_id : current_show_id, 
		id : "feroce",
		title: "Qui est le plus féroce ?",
		options: questionOptionsList
	};
	socket.emit('question', questionRequest);
	return false;
});

$("#swamwillaction").click(function(){

	var actionDiff1 = {
		action: 'FC',
		value: "#000000",
	};
	var actionDiff2 = {
		action: 'AC',
		value: "NONE,N,N-0-500,#FF0000,#FFFFFF",
	};

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'willw', command: 'action', valueCommand: actionDiff1}, {value: 'willp',  command: 'action', valueCommand: actionDiff2} ]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#swamprojet").click(function(){
    /*var questionRequest = {
		id : "project",
        title: "Quel projet vous fait le plus kiffer ?",
        options: [
            {title: "Mapetitepoulette", value:"mpp"},
            {title: "Foodfilter", value:"ff"},
            {title: "Greenify", value:"green"},
            {title: "Odeprog", value:"odp"},
            {title: "Whatenergy", value:"we"},
            {title: "Oneforall", value:"ofa"},
            {title: "C'estdelabombe", value:"cdlb"},
            {title: "Stickersbio", value:"sb"},
            {title: "Lesabeilles", value:"la"},
            {title: "Cuboak", value:"co"},
            {title: "Edsmile", value:"es"},
            {title: "Boucheàoreilles", value:"bao"},
        ]
    };*/

    var questionRequest = {
    		show_id : current_show_id, 
    		id : "project",
            title: "Quel est votre projet coup de coeur ?",
            options: [
                {title: "Sport et Cancer", value:"sec"},
                {title: "Ca match", value:"cm"},
                {title: "TRUST", value:"trust"},
                {title: "Share my way", value:"smw"},
                {title: "Hall of fan", value:"hof"},
                {title: "Chalenge me", value:"chalenge"},
                {title: "Connected ball", value:"cb"},
                {title: "Wasabri", value:"w"},
                {title: "LIIFE", value:"l"},
                {title: "Loic tu es bidon", value:"lteb"},
            ]
        };
    socket.emit('question', questionRequest);
    return false;
});


//##################################################
//# SWAM
//##################################################

$("#swam_fp_question").click(function(){
    var questionRequest = {
    		show_id : current_show_id, 
		id : "vote",
        title: "Ce projet vous plait-il ?",
        options: [
            {title: "Oui", value:"voteoui"},
            {title: "Non", value:"votenon"},
        ]
    };
    socket.emit('question', questionRequest);
    return false;
});
		
$("#swam_fp_action_diff").click(function(){

	var actionDiff1 = {
		action: 'FC',
		value: "#00FF00",
	};
	var actionDiff2 = {
		action: 'FC',
		value: "#FF0000",
	};

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'voteoui', command: 'action', valueCommand: actionDiff1}, {value: 'votenon',  command: 'action', valueCommand: actionDiff2} ]
	};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#swam_fp_end_vote").click(function(){
	socket.emit('reset_votes', '');
	return false;
});

//##################################################
//# AUTOMODE
//##################################################

$("#automode_demo_apple").click(function(){

	var jsonObj = {
			loop : true,
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", parameter: {action: "B", value:"100"} },
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#000000"} },
				{ delay: 10000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/onboarding_1_neutral.png"} },
				{ delay: 100, type : "action", parameter: {action: "WM", value:"http://tristan-salaun.com/l4e/content/imgs/watermark_light4events.png"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#FF2A64"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#4C606B"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#F44336"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#4CAF50"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#3F51B5"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#9C27B0"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#FFEB3B"} },
				
				{ delay: 100, type : "action", parameter: {action: "HTML", value:"<HTML><BODY bgcolor=black><FONT COLOR=white><CENTER><h1><BR/><BR/>Vibrations</h1></CENTER></FONT></BODY></HTML>"} },
				{ delay: 6000, type : "action", parameter: {action: "VIB", value:"0,100,100,100,100,100,100,100,100,100,100,100"} },
				{ delay: 2000, type : "action", parameter: {action: "VIB", value:"0,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"} },
				{ delay: 4000, type : "action", parameter: {action: "VIB", value:"0,300,300,300,300,300,300,300,300,300,300,300"} },
				
				{ delay: 100, type : "action", parameter: {action: "HTML", value:"<HTML><BODY bgcolor=black><FONT COLOR=white><CENTER><h1><BR/><BR/>Flash</h1></CENTER></FONT></BODY></HTML>"} },
				{ delay: 5000, type : "action", parameter: {action: "FLASH", value:"500,500,10"} },
				{ delay: 100, type : "action", parameter: {action: "FLASH", value:"0,0,0"} },
				{ delay: 5000, type : "action", parameter: {action: "FLASH", value:"100,100,20"} },
				{ delay: 100, type : "action", parameter: {action: "FLASH", value:"0,0,0"} },
				{ delay: 10000, type : "action", parameter: {action: "AC", value:"NONE,Y,N-0-200"} },
				{ delay: 100, type : "action", parameter: {action: "WM", value:""} },
								
				{ delay: 10000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/onboarding_2_neutral.png"} },
				// Texte images medias
				{ delay: 100, type : "action", parameter: {action: "WM", value:"http://tristan-salaun.com/l4e/content/imgs/watermark_cocacola_bouteille.png"} },
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#FFFFFF"} },
				{ delay: 10000, type : "action", parameter: {action: "TEXT", value:"Aux armes, citoyens<br/>Formez vos bataillons<br/>Marchons, marchons !<br/>Qu'un sang impur<br/>Abreuve nos sillons !<br/><br/>Allons enfants de la Patrie<br/>Le jour de gloire est arrivé !<br/>Contre nous de la tyrannie<br/>L'étendard sanglant est levé<br/>L'étendard sanglant est levé<br/>Entendez-vous dans les campagnes<br/>Mugir ces féroces soldats ?<br/>Ils viennent jusque dans vos bras<br/>Égorger vos fils, vos compagnes !<br/><br/>Aux armes, citoyens<br/>Formez vos bataillons<br/>Marchons, marchons !<br/>Qu'un sang impur<br/>Abreuve nos sillons !<br/><br/>Nous entrerons dans la carrière<br/>Quand nos aînés n'y seront plus,<br/>Nous y trouverons leur poussière<br/>Et la trace de leurs vertus<br/>Et la trace de leurs vertus<br/>Bien moins jaloux de leur survivre<br/>Que de partager leur cercueil<br/>Nous aurons le sublime orgueil<br/>De les venger ou de les suivre<br/><br/>Aux armes, citoyens<br/>Formez vos bataillons<br/>Marchons, marchons !<br/>Qu'un sang impur<br/>Abreuve nos sillons !<br/><br/>Quoi ! des cohortes étrangères<br/>Feraient la loi dans nos foyers !<br/>Quoi ! Ces phalanges mercenaires<br/>Terrasseraient nos fiers guerriers !<br/>Terrasseraient nos fiers guerriers !<br/>Grand Dieu ! Par des mains enchaînées<br/>Nos fronts sous le joug se ploieraient<br/>De vils despotes deviendraient<br/>Les maîtres de nos destinées !<br/><br/>Aux armes, citoyens<br/>Formez vos bataillons<br/>Marchons, marchons !<br/>Qu'un sang impur<br/>Abreuve nos sillons !<br/><br/>Amour sacré de la Patrie,<br/>Conduis, soutiens nos bras vengeurs<br/>Liberté, Liberté chérie<br/>Combats avec tes défenseurs !<br/>Combats avec tes défenseurs !<br/>Sous nos drapeaux que la victoire<br/>Accoure à tes mâles accents<br/>Que tes ennemis expirants<br/>Voient ton triomphe et notre gloire !<br/><br/>Aux armes, citoyens<br/>Formez vos bataillons<br/>Marchons, marchons !<br/>Qu'un sang impur<br/>Abreuve nos sillons !"} },
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#000000"} },
				{ delay: 5000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/logo_light4events.png"} },
				{ delay: 100, type : "action", parameter: {action: "VOL", value:"50"} },
				{ delay: 100, type : "action", parameter: {action: "HTML", value:"<HTML><BODY bgcolor=black><FONT COLOR=white><CENTER><h1><BR/><BR/>Sound</h1></CENTER></FONT></BODY></HTML>"} },
				{ delay: 10000, type : "action", parameter: {action: "ASOUND", value:"Y,N,100-2000,5,http://tristan-salaun.com/l4e/content/sound/tonerre.mp3,http://tristan-salaun.com/l4e/content/sound/grillons.mp3"} },
				{ delay: 100, type : "action", parameter: {action: "ASOUND", value:"Y,N,0-0,0,"} },
				{ delay: 100, type : "action", parameter: {action: "VOL", value:"100"} },
				{ delay: 100, type : "action", parameter: {action: "HTML", value:"<HTML><BODY bgcolor=black><FONT COLOR=white><CENTER><h1><BR/><BR/>Sound LOUD</h1></CENTER></FONT></BODY></HTML>"} },
				{ delay: 10000, type : "action", parameter: {action: "ASOUND", value:"Y,N,100-2000,5,http://tristan-salaun.com/l4e/content/sound/tonerre.mp3,http://tristan-salaun.com/l4e/content/sound/grillons.mp3"} },
				{ delay: 100, type : "action", parameter: {action: "ASOUND", value:"Y,N,0-0,0,"} },
//				{ delay: 5000, type : "action", parameter: {action: "HTML", value:"<HTML><BODY bgcolor=black><FONT COLOR=white><CENTER><h1><BR/><BR/>Make some noise<BR/><BR/>Clap in your hands</h1></CENTER></FONT></BODY></HTML>"} },
//				{ delay: 10000, type : "action", parameter: {action: "ASC", value:"#0000FF,#FF0000"} },
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#FFFFFF"} },
				{ delay: 100, type : "action", parameter: {action: "WM", value:""} },
				
				
				{ delay: 10000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/onboarding_3_neutral.png"} },
				// Notification
				// Vote
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#FFFFFF"} },
				{ delay: 10000, type : "question", parameter: { id : "mvp", title: "Votez pour le meilleur joueur du match ?", options: [ {title: "33 Ronan Quemener", value:"mvp_1"}, {title: "39 Cristobal Huet", value:"mvp_2"}, {title: "49 Florian Hardy", value:"mvp_3"}, {title: "3 Jonathan Janil", value:"mvp_4"}, {title: "18 Yohann Auvitu", value:"mvp_5"} ] } },
				
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#FFFFFF"} },
				{ delay: 3000, type : "action", parameter: {action: "HTML", value:"<HTML><BODY bgcolor=black><FONT COLOR=white><CENTER><h1><BR/><BR/>NEED 3 PHONES</h1></CENTER></FONT></BODY></HTML>"} },
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#000000"} },
				{ delay: 500, type : "action_diff", parameter: {actionDiff : [{value: 'zone_1', command: 'action', valueCommand: { action: 'FC', value: "#0000FF"}},{value: 'zone_2', command: 'action', valueCommand: { action: 'FC', value: "#FFFFFF"}},{value: 'zone_3', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}} ]}	 },
				{ delay: 10000, type : "question", parameter: { id : "zone", title: "Dans quelle zone êtes vous placé ?", options: [ {title: "Zone 1", value:"zone_1"}, {title: "Zone 2", value:"zone_2"},{title: "Zone 3", value:"zone_3"} ] } },
				
				{ delay: 2000, type : "action_diff", parameter: {actionDiff : [{value: 'zone_1', command: 'action', valueCommand: { action: 'FC', value: "#002b7f"}},{value: 'zone_2', command: 'action', valueCommand: { action: 'FC', value: "#fcd116"}},{value: 'zone_3', command: 'action', valueCommand: { action: 'FC', value: "#ce1126"}} ]}	 },
				{ delay: 2000, type : "action_diff", parameter: {actionDiff : [{value: 'zone_1', command: 'action', valueCommand: { action: 'FC', value: "#000000"}},{value: 'zone_2', command: 'action', valueCommand: { action: 'FC', value: "#fae042"}},{value: 'zone_3', command: 'action', valueCommand: { action: 'FC', value: "#ed2939"}} ]}	 },
				{ delay: 2000, type : "action_diff", parameter: {actionDiff : [{value: 'zone_1', command: 'action', valueCommand: { action: 'FC', value: "#d91023"}},{value: 'zone_2', command: 'action', valueCommand: { action: 'FC', value: "#FFFFFF"}},{value: 'zone_3', command: 'action', valueCommand: { action: 'FC', value: "#d91023"}} ]}	 },
				{ delay: 2000, type : "action_diff", parameter: {actionDiff : [{value: 'zone_1', command: 'action', valueCommand: { action: 'FC', value: "#4bad26"}},{value: 'zone_2', command: 'action', valueCommand: { action: 'FC', value: "#FFFFFF"}},{value: 'zone_3', command: 'action', valueCommand: { action: 'FC', value: "#fc0204"}} ]}	 },
				
				// Quizz
				{ delay: 5000, type : "action", parameter: {action: "HTML", value:"<HTML><BODY bgcolor=black><FONT COLOR=white><CENTER><h1><BR/><BR/>Good answers : <BR/><BR/>Q1 : 1<BR/>Q2 : 2<BR/>Q3 : 3</h1></CENTER></FONT></BODY></HTML>"} },
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#000000"} },
				{ delay: 500, type : "action_diff", parameter: {actionDiff : [{value: 'umf_1_r1', command: 'action', valueCommand: { action: 'FC', value: "#00FF00"}},{value: 'umf_1_r2', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}},{value: 'umf_1_r3', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}} ]}	 },
				{ delay: 10000, type : "question", parameter: { id : "umf_1", title: "1 - En quelle année à eu lieu la première édition de United Music Festival ?", options: [ {title: "2016", value:"umf_1_r1"}, {title: "2017", value:"umf_1_r2"},{title: "2018", value:"umf_1_r3"} ] } },
				
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#000000"} },
				{ delay: 500, type : "action_diff", parameter: {actionDiff : [{value: 'umf_2_r1', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}},{value: 'umf_2_r2', command: 'action', valueCommand: { action: 'FC', value: "#00FF00"}},{value: 'umf_2_r3', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}} ]}	 },
				{ delay: 10000, type : "question", parameter: { id : "umf_2", title: "2 - Combien de dates sont prévues pour l'édition de 2017 ?", options: [ {title: "1", value:"umf_2_r1"}, {title: "2", value:"umf_2_r2"},{title: "3", value:"umf_2_r3"} ] } },
				
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#000000"} },
				{ delay: 500, type : "action_diff", parameter: {actionDiff : [{value: 'umf_3_r1', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}},{value: 'umf_3_r2', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}},{value: 'umf_3_r3', command: 'action', valueCommand: { action: 'FC', value: "#00FF00"}} ]}	 },
				{ delay: 10000, type : "question", parameter: { id : "umf_3", title: "3 - Quelle ville ne fera pas partis de la tournée de 2017 ?", options: [ {title: "Valentigney", value:"umf_3_r1"}, {title: "Vittel", value:"umf_3_r2"},{title: "Biarritz", value:"umf_3_r3"} ] } },
				
				// pages interactives
				{ delay: 100, type : "action", parameter: {action: "FC", value:"#FFFFFF"} },
				// { delay: 10000, type : "action", parameter: {action: "URL", value:"http://light4events.fr"} },
				{ delay: 10000, type : "action", parameter: {action: "URL", value:"http://tristan-salaun.com/l4e/content/html/ProfileCardTristanSALAUN.html"} },
				{ delay: 10000, type : "action", parameter: {action: "URL", value:"http://tristan-salaun.com/l4e/content/html/ProfileCardClementMERCIER.html"} },
				{ delay: 10000, type : "action", parameter: {action: "URL", value:"http://tristan-salaun.com/l4e/content/html/ProfileCardAlexandrePARTOUCHE.html"} },
				
				// jeux concours
				{ delay: 10000, type : "action", parameter: {action: "URL", value:"https://goo.gl/forms/Jb0Qyw0ZBJNZWiig1"} },				
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_simple").click(function(){

	var jsonObj = {
			loop : true,
			show_id : current_show_id,
			timedActionList: [
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#000000"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#FFFFFF"} },			
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_bis").click(function(){

	var jsonObj = {
			loop : true,
			show_id : current_show_id,
			timedActionList: [
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#c61618"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#8189c2"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#ff6100"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#832325"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#e05d2a"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#f5bd28"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#c5d734"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#0084a0"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#FFFFFF"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/logo_greencopper.jpg"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/logo_lebureauexport.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/logo_light4events.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/logo_nantes.jpg"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/logo_weezevent.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/imgs/logo_irma.jpg"} },
				{ delay: 4000, type : "action", parameter: {action: "VIB", value:"0,300,300,300,300,300,300,300,300,300,300,300"} },
				{ delay: 5000, type : "action", parameter: {action: "FLASH", value:"500,500,10"} },
				{ delay: 100, type : "action", parameter: {action: "FLASH", value:"0,0,0"} },
				
			]
		};

	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_startupmarseille").click(function(){

	var jsonObj = {
			loop : true,
			show_id : current_show_id,
			timedActionList: [
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#c61618"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#8189c2"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#ff6100"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#832325"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#e05d2a"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#f5bd28"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#c5d734"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#0084a0"} },
				{ delay: 1000, type : "action", parameter: {action: "FC", value:"#FFFFFF"} },
				{ delay: 5000, type : "action", parameter: {action: "FLASH", value:"500,500,10"} },
				{ delay: 100, type : "action", parameter: {action: "FLASH", value:"0,0,0"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_atelier nab.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_eonfit.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_hashtag_trophy.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_insatiables.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_light4events.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_listenleon.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_lwb.jpg"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_nocnoc.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_o2quant.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_shake.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_simplyalert.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_startupmarseille.png"} },
				{ delay: 3000, type : "action", parameter: {action: "IMG", value:"http://tristan-salaun.com/l4e/content/sm_logo_wecoprod.png"} },
				
				{ delay: 3000, type : "action", parameter: {action: "LOGO", value:"http://tristan-salaun.com/l4e/content/flag_fr.png,3,3,#000000"} },
				{ delay: 3000, type : "action", parameter: {action: "LOGO", value:"http://tristan-salaun.com/l4e/content/flag_guinea.png,3,3,#000000"} },
				{ delay: 3000, type : "action", parameter: {action: "LOGO", value:"http://tristan-salaun.com/l4e/content/flag_jamaica.png,3,3,#000000"} },
				{ delay: 3000, type : "action", parameter: {action: "LOGO", value:"http://tristan-salaun.com/l4e/content/flag_japan.png,3,3,#000000"} },
				{ delay: 3000, type : "action", parameter: {action: "LOGO", value:"http://tristan-salaun.com/l4e/content/flag_tanzania.png,3,3,#000000"} },
			]
		};

	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_rotary").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_accueil.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_environnemental_accueil_prix.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_environnemental_hysilabs.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_environnemental_iadys.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_environnemental_techno_bam.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_international_accueil_prix.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_international_adiona.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_international_infinityspace.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_international_unabella.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_numerique_accueil_prix.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_numerique_light4events.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_numerique_perspectives.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_numerique_socialbox.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_sante_accueil_prix.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_sante_anapix.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_sante_medicadvance.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_sante_technoconcept.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_societal_accueil_prix.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_societal_ecoledesxv.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_societal_loisirmobilite.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_societal_popupmoi.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_villeintelligente_accueil_prix.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_villeintelligente_astragale.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_villeintelligente_terradona.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#ef3e2e"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/rotary_villeintelligente_voisins_vigilants.jpg"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});


$("#automode_2017").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/2017_02.jpg"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/2017_05.jpg"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_psg").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_psg_flat.png"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_psg_monochrome.png"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_psg_ombres.png"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});


$("#automode_telethon").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#fac90b"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#02575e"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#0cb7bf"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#8cd50a"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#fc6303"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#a20353"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/telethon_logo.png"},
				//{ delay: 1500, type : "action", action: "VIB", parameter: "0,100,100,100,100,100,100,100,100,100,100,100"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#9cbee4"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#e48e3c"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#5c627c"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/telethon_logo_avignon.gif"},
				{ delay: 5000, type : "action", action: "FLASH", parameter: "500,500,5"},
				{ delay: 100, type : "action", action: "FLASH", parameter: "0,0,0"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#ed3f48"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/telethon_logo_spectaculart.jpg"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_demo").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 10000, type : "action", action: "TEXT", parameter: "La démonstration Light4Events commence. Plus vous avez de téléphones/tablettes à disposition, et mieux cela sera :-D"},
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 3000, type : "action", action: "TEXT", parameter: "Les couleurs"},
				{ delay: 2000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 2000, type : "action", action: "FC", parameter: "#FF0000"},
				{ delay: 2000, type : "action", action: "FC", parameter: "#00FF00"},
				{ delay: 2000, type : "action", action: "FC", parameter: "#0000FF"},
				{ delay: 2000, type : "action", action: "FC", parameter: "#FF00FF"},
				{ delay: 2000, type : "action", action: "FC", parameter: "#00FFFF"},
				{ delay: 2000, type : "action", action: "FC", parameter: "#FFFF00"},
				{ delay: 2000, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 3000, type : "action", action: "TEXT", parameter: "La luminosité"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 5000, type : "action", action: "B", parameter: "0"},
				{ delay: 1000, type : "action", action: "B", parameter: "10"},
				{ delay: 1000, type : "action", action: "B", parameter: "20"},
				{ delay: 1000, type : "action", action: "B", parameter: "30"},
				{ delay: 1000, type : "action", action: "B", parameter: "40"},
				{ delay: 1000, type : "action", action: "B", parameter: "50"},
				{ delay: 1000, type : "action", action: "B", parameter: "60"},
				{ delay: 1000, type : "action", action: "B", parameter: "70"},
				{ delay: 1000, type : "action", action: "B", parameter: "80"},
				{ delay: 1000, type : "action", action: "B", parameter: "90"},
				{ delay: 1000, type : "action", action: "B", parameter: "100"},
				{ delay: 3000, type : "action", action: "B", parameter: "0"},
				{ delay: 3000, type : "action", action: "B", parameter: "100"},
				{ delay: 3000, type : "action", action: "B", parameter: "0"},
				{ delay: 3000, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 3000, type : "action", action: "TEXT", parameter: "Les images"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_light4events.png"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/allumette.jpg"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/bougie2.gif"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 3000, type : "action", action: "TEXT", parameter: "Les vibrations"},
				{ delay: 3000, type : "action", action: "VIB", parameter: "0,100,200,100"},
				{ delay: 3000, type : "action", action: "VIB", parameter: "0,100"},
				{ delay: 3000, type : "action", action: "VIB", parameter: "0,50,50,50,50,50,50,50,50,50,50,50"},
				{ delay: 3000, type : "action", action: "VIB", parameter: "0,100,100,100,100,100,100,100,100,100,100,100"},
				{ delay: 3000, type : "action", action: "VIB", parameter: "0,300,300,300,300,300,300,300,300,300,300,300"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 3000, type : "action", action: "TEXT", parameter: "Le flash"},
				{ delay:10000, type : "action", action: "FLASH", parameter: "1000,1000,-1"},
				{ delay:10000, type : "action", action: "FLASH", parameter: "200,200,-1"},
				{ delay:  100, type : "action", action: "FLASH", parameter: "0,0,0"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 3000, type : "action", action: "TEXT", parameter: "Fonctions plus évoluées"},
				{ delay: 3000, type : "action", action: "TEXT", parameter: "Flashs rouges, bleux et blancs"},
				{ delay:10000, type : "action", action: "AC", parameter: "NONE,Y,N-1000-500,#FF0000,#FFFFFF,#0000FF"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 3000, type : "action", action: "TEXT", parameter: "Multicouleur aléatoire"},
				{ delay:10000, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 3000, type : "action", action: "TEXT", parameter: "Nuit scintillante"},
				{ delay:20000, type : "action", action: "AC", parameter: "NONE,Y,Y-2000-5000-100-200,#FFFFFF"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 5000, type : "action", action: "TEXT", parameter: "La distinction des mobiles"},
				{ delay: 10000, type : "question", parameter: {id : "genre", title: "Quel est votre genre ?",options: [{title: "Homme", value:"h"}, {title: "Femme", value:"f"}]}},
				{ delay: 5000, type : "action_diff", parameter: [ {value: 'h', command: 'action', valueCommand: { action: 'FC', value: "#3299D4"}}, {value: 'f',  command: 'action', valueCommand: { action: 'FC', value: "#F0569F" }} ]},
				{ delay: 5000, type : "action_diff", parameter: [ {value: 'h', command: 'action', valueCommand: { action: 'TEXT', value: "Je suis un homme et fiert de l'Ãªtre"}}, {value: 'f',  command: 'action', valueCommand: { action: 'TEXT', value: "Je suis une femme et je sais quel est le vrai sexe faible :-D" }} ]},
				{ delay: 3000, type : "action_diff", parameter: [ {value: 'h', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}}, {value: 'f',  command: 'action', valueCommand: { action: 'FC', value: "#00FF00" }} ]},
				{ delay: 3000, type : "action_diff", parameter: [ {value: 'h', command: 'action', valueCommand: { action: 'FC', value: "#00FF00"}}, {value: 'f',  command: 'action', valueCommand: { action: 'FC', value: "#FF0000" }} ]},
				{ delay: 10000, type : "question", parameter: {id : "side", title: "Etes vous Ã  droite, ou Ã  gauche ?",options: [{title: "Droite", value:"d"}, {title: "Gauche", value:"g"}]}},
				{ delay: 2000, type : "action_diff", parameter: [ {value: 'd', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}}, {value: 'g',  command: 'action', valueCommand: { action: 'FC', value: "#0000FF" }} ]},
				{ delay: 2000, type : "action_diff", parameter: [ {value: 'd', command: 'action', valueCommand: { action: 'FC', value: "#0000FF"}}, {value: 'g',  command: 'action', valueCommand: { action: 'FC', value: "#FF0000" }} ]},
				{ delay: 2000, type : "action_diff", parameter: [ {value: 'd', command: 'action', valueCommand: { action: 'FC', value: "#FF0000"}}, {value: 'g',  command: 'action', valueCommand: { action: 'FC', value: "#000000" }} ]},
				{ delay: 2000, type : "action_diff", parameter: [ {value: 'd', command: 'action', valueCommand: { action: 'FC', value: "#000000"}}, {value: 'g',  command: 'action', valueCommand: { action: 'FC', value: "#FF0000" }} ]},
				{ delay: 2000, type : "action_diff", parameter: [ {value: 'd', command: 'action', valueCommand: { action: 'FC', value: "#FFFFFF"}}, {value: 'g',  command: 'action', valueCommand: { action: 'FC', value: "#FF00FF" }} ]},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 5000, type : "action", action: "TEXT", parameter: "Les scénarios synchronisés"},
				{ delay: 100, type : "loading", parameter: {id: 3, title: "Test Séquence", video: "", audio: "", actionTrackList: [{ timedActionList: [{timestamp: 0, action: "FC", parameter: "#000000"},{timestamp: 3000, action: "FC", parameter: "#FFFFFF"},{timestamp: 4000, action: "FC", parameter: "#FF0000"},{timestamp: 5000, action: "FC", parameter: "#00FF00"},{timestamp: 6000, action: "FC", parameter: "#0000FF"},{timestamp: 7000, action: "FC", parameter: "#00FFFF"},{timestamp: 8000, action: "FC", parameter: "#FF00FF"},{timestamp: 9000, action: "FC", parameter: "#FFFF00"},{timestamp: 10000, action: "FC", parameter: "#FFFFFF"},{timestamp: 11000, action: "FC", parameter: "#777777"},{timestamp: 12000, action: "FC", parameter: "#333333"},{timestamp: 13000, action: "FC", parameter: "#000000"},{timestamp: 14000, action: "FC", parameter: "#FFFFFF"},{timestamp: 14500, action: "FC", parameter: "#000000"},{timestamp: 15000, action: "FC", parameter: "#FFFFFF"},{timestamp: 15500, action: "FC", parameter: "#000000"},{timestamp: 16000, action: "FC", parameter: "#FFFFFF"},{timestamp: 16500, action: "FC", parameter: "#000000"},{timestamp: 17000, action: "FC", parameter: "#FF0000"},{timestamp: 17500, action: "FC", parameter: "#000000"},{timestamp: 18000, action: "FC", parameter: "#FF0000"},{timestamp: 18500, action: "FC", parameter: "#000000"},{timestamp: 19000, action: "FC", parameter: "#0000FF"},{timestamp: 19500, action: "FC", parameter: "#000000"},{timestamp: 20000, action: "FC", parameter: "#0000FF"},{timestamp: 20500, action: "FC", parameter: "#0000FF"},{timestamp: 21000, action: "FC", parameter: "#FF0000"},{timestamp: 21500, action: "FC", parameter: "#0000FF"},{timestamp: 22000, action: "FC", parameter: "#FF0000"},{timestamp: 22500, action: "FC", parameter: "#0000FF"},{timestamp: 23000, action: "FC", parameter: "#FFFFFF"},{timestamp: 23500, action: "FC", parameter: "#000000"},{timestamp: 24000, action: "FC", parameter: "#FFFFFF"},{timestamp: 24500, action: "FC", parameter: "#000000"},{timestamp: 25000, action: "FC", parameter: "#FFFFFF"},{timestamp: 25500, action: "FC", parameter: "#000000"},{timestamp: 26000, action: "FC", parameter: "#FFFFFF"},{timestamp: 26500, action: "FC", parameter: "#000000"}]},]}},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 50000, type : "start_delay", parameter: {delay: 20 ,sequence_id: 3} },
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 30000, type : "action", action: "TEXT", parameter: "C'est fini, on recommence dans 30 secondes, si vous avez d'autres smartphones, tablettes à disposition, c'est le moment de les connecter."}
			]
		};
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_demo_web").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
//				{ delay: 100, type : "action", action: "B", parameter: "100"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#4C606B"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#FF2A64"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#B8B8B8"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#4C606B"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#FF2A64"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#B8B8B8"},
//				{ delay: 100, type : "action", action: "VIB", parameter: "0,100,200,100"},
//				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
//				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/aix-marseille-french-tech.png"},
//				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
//				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/aix-marseille-french-tech2.jpg"},
//				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
//				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/allumette.jpg"},
//				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
//				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_light4events.png"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#F44336"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#4CAF50"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#3F51B5"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#9C27B0"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#75CEDE"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#FFEB3B"},
//				{ delay: 1000, type : "action", action: "FC", parameter: "#FFFFFF"},
//				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
//				{ delay: 1500, type : "action", action: "VIB", parameter: "0,100,100,100,100,100,100,100,100,100,100,100"},
//				{ delay:5000, type : "action", action: "FLASH", parameter: "500,500,5"},
//				{ delay: 100, type : "action", action: "FLASH", parameter: "0,0,0"},
//				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
//				{ delay:3000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#4C606B,#FF2A64,#B8B8B8"},
//				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
//				{ delay:3000, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
//				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
//				{ delay:8000, type : "action", action: "AC", parameter: "NONE,Y,Y-2000-5000-100-200,#FFFFFF"},
//				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},

				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 600000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/huddlemakers/content/imgs/ihwc_can_fra.jpg"},

			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_demo_logos").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/telthon.png"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_avignon.gif"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_light4events.png"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_france3.png"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_francebleu84.gif"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_la_provence.png"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_vauclusematin.gif"},
				{ delay: 3000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_radiovinciautoroutes.gif"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});



$("#automode_demo_bbr").click(function(){

	var jsonObj = {
			loop : true,
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", parameter: {action: "B", value:"100"} },
				{ delay: 5000, type : "action", parameter: {action: "FC", value:"#051440"} },
				{ delay: 5000, type : "action", parameter: {action: "FC", value:"#FFFFFF"} },
				{ delay: 5000, type : "action", parameter: {action: "FC", value:"#EC1920"} },
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_anooki").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "Anooki 5"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "Anooki 4"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "Anooki 3"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "Anooki 2"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "Anooki 1"},
				{ delay: 12370, type : "action", action: "FC", parameter: "#DA5701"},
				{ delay: 5060, type : "action", action: "FC", parameter: "#CE000D"},
				{ delay: 4940, type : "action", action: "FC", parameter: "#DA1DD1"},
				{ delay: 4960, type : "action", action: "FC", parameter: "#803FE4"},
				{ delay: 4970, type : "action", action: "FC", parameter: "#1782D4"},
				{ delay: 5030, type : "action", action: "FC", parameter: "#57A600"},
				{ delay: 4970, type : "action", action: "FC", parameter: "#D58B00"},
				{ delay: 9530, type : "action", action: "FC", parameter: "#DA5700"},
				{ delay: 5540, type : "action", action: "FC", parameter: "#CE000D"},
				{ delay: 2900, type : "action", action: "FC", parameter: "#DA1DCA"},
				{ delay: 6490, type : "action", action: "FC", parameter: "#1782D4"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 10000, type : "action", action: "TEXT", parameter: "FIN"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});


$("#automode_tedx_before").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 5000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_tedx_avignon.png"},
				{ delay: 5000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Rendez-vous<br/>SAMEDI 1 Octobre<br/>au Pandora Avignon<br/>pour le <font color=red><B>TEDx</B></font></font></CENTER></h1></BODY>"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_tedx_jj").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 7000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_tedx_avignon.png"},
				{ delay: 7000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Merci d'avoir installé l'application Light4Events<br/>pour le <font color=red><B>TEDx</B></font><br/>Nous vous indiquerons le bon moment pour sortir votre smartphone</font></CENTER></h1></BODY>"},
				{ delay: 7000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Dans la salle vous pourrez vous connecter au wifi<br/><font color=red><B>l4e</B></font><br/>Note : pas de connexion internet disponible</font></CENTER></h1></BODY>"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_tedx_jj_salle").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 7000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_tedx_avignon.png"},
				{ delay: 7000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Application installée<br/>WiFi connecté<br/>Tout est OK<br/><br/>Nous vous indiquerons le bon moment pour sortir votre smartphone</font></CENTER></h1></BODY>"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});


$("#automode_tedx_synchro").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
  				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
  				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx Avignon 10"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx Avignon 9"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx Avignon 8"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx Avignon 7"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx :-D Avignon 6"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#505050"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#505050"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#A0A0A0"},
				{ delay: 300, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 300, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 600, type : "action", action: "FC", parameter: "#B8B8B8"},
				{ delay: 300, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 300, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 600, type : "action", action: "FC", parameter: "#B8B8B8"},
				{ delay: 3000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 200000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Votre point est connecté</font></CENTER></h1></BODY>"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_tedx").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
  				{ delay: 100, type : "action", action: "B", parameter: "100"},
  				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
  				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx Avignon 10"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx Avignon 9"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx Avignon 8"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx Avignon 7"},
				{ delay: 1000, type : "action", action: "TEXT", parameter: "TEDx :-D Avignon 6"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#505050"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#505050"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"}, // Noir
				{ delay: 8500, type : "action", action: "AC", parameter: "NONE,N,Y-200-2000-50-200,#E62B1E"}, // Random rouge pointes de couleurs

				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 10200, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF"}, // Random explosion de couleurs
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 10100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF"}, // Random explosion de couleurs
				
				//{ delay: 19000, type : "action", action: "FC", parameter: "#E62B1E"}, // Reprise paroles

				// 30 000 - 49 000
				{ delay: 300, type : "action", action: "FC", parameter: "#000000"}, // ajustement
				{ delay: 666, type : "action", action: "FC", parameter: "#FFFF00"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FFEB3B"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FF9800"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FF5722"}, 
				{ delay: 646, type : "action", action: "FC", parameter: "#c71d26"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#FFFF00"}, 
				{ delay: 859, type : "action", action: "FC", parameter: "#c71d26"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FFFF00"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FFEB3B"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FF9800"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FF5722"}, 
				{ delay: 646, type : "action", action: "FC", parameter: "#c71d26"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#FFFF00"}, 
				{ delay: 830, type : "action", action: "FC", parameter: "#c71d26"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FFFF00"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FFEB3B"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FF9800"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FF5722"}, 
				{ delay: 646, type : "action", action: "FC", parameter: "#c71d26"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#FFFF00"}, 
				{ delay: 830, type : "action", action: "FC", parameter: "#c71d26"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FFFF00"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FFEB3B"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FF9800"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#FF5722"}, 
				{ delay: 646, type : "action", action: "FC", parameter: "#c71d26"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#FFFF00"}, 
				{ delay: 540, type : "action", action: "FC", parameter: "#c71d26"}, 

				{ delay: 2000, type : "action", action: "FC", parameter: "#000000"}, // Moment plus calme

				//{ delay: 19000, type : "action", action: "FC", parameter: "#E62B1E"}, // Reprise paroles
// 51 000 - 70 000
				{ delay: 1188, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1188, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1180, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1180, type : "action", action: "FC", parameter: "#FFFFFF"},
				
				
				{ delay: 1500, type : "action", action: "FC", parameter: "#000000"}, // Moment calme
				//{ delay: 19500, type : "action", action: "FC", parameter: "#E62B1E"}, // Reprise

				// 71500 - 91000 Froid
				{ delay: 666, type : "action", action: "FC", parameter: "#b21fbf"}, //
				{ delay: 666, type : "action", action: "FC", parameter: "#5c3dbf"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#3e90ff"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#10f3db"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#2de5a6"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#b21fbf"}, 
				{ delay: 859, type : "action", action: "FC", parameter: "#2de5a6"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#b21fbf"}, //
				{ delay: 666, type : "action", action: "FC", parameter: "#5c3dbf"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#3e90ff"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#10f3db"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#2de5a6"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#b21fbf"}, 
				{ delay: 859, type : "action", action: "FC", parameter: "#2de5a6"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#b21fbf"}, //
				{ delay: 666, type : "action", action: "FC", parameter: "#5c3dbf"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#3e90ff"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#10f3db"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#2de5a6"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#b21fbf"}, 
				{ delay: 859, type : "action", action: "FC", parameter: "#2de5a6"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#b21fbf"}, //
				{ delay: 666, type : "action", action: "FC", parameter: "#5c3dbf"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#3e90ff"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#10f3db"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#2de5a6"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#b21fbf"}, 
				{ delay: 1359, type : "action", action: "FC", parameter: "#2de5a6"}, 
				
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"}, 
				{ delay: 2900, type : "action", action: "AC", parameter: "NONE,N,Y-200-2000-50-200,#FFFFFF"}, // Moment calme étoiles
				//{ delay: 40000, type : "action", action: "FC", parameter: "#E62B1E"}, // reprise
				
				// Vert 94000 - 134000 (1'34 - 2'14)
				{ delay: 1100, type : "action", action: "FC", parameter: "#000000"}, // ajustement => 1'35'100
				{ delay: 666, type : "action", action: "FC", parameter: "#00FF00"}, //
				{ delay: 666, type : "action", action: "FC", parameter: "#4CAF50"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#8BC34A"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#B1D676"}, 
				{ delay: 646, type : "action", action: "FC", parameter: "#76d6da"}, 
				{ delay: 801, type : "action", action: "FC", parameter: "#00FF00"}, 
				{ delay: 830, type : "action", action: "FC", parameter: "#76d6da"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#00FF00"}, //
				{ delay: 666, type : "action", action: "FC", parameter: "#4CAF50"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#8BC34A"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#B1D676"}, 
				{ delay: 646, type : "action", action: "FC", parameter: "#76d6da"}, 
				{ delay: 651, type : "action", action: "FC", parameter: "#00FF00"}, 
				{ delay: 830, type : "action", action: "FC", parameter: "#76d6da"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#00FF00"}, //
				{ delay: 666, type : "action", action: "FC", parameter: "#4CAF50"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#8BC34A"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#B1D676"}, 
				{ delay: 646, type : "action", action: "FC", parameter: "#76d6da"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#00FF00"}, 
				{ delay: 870, type : "action", action: "FC", parameter: "#76d6da"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#00FF00"}, //
				{ delay: 666, type : "action", action: "FC", parameter: "#4CAF50"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#8BC34A"}, 
				{ delay: 666, type : "action", action: "FC", parameter: "#B1D676"}, 
				{ delay: 706, type : "action", action: "FC", parameter: "#76d6da"}, 
				{ delay: 601, type : "action", action: "FC", parameter: "#00FF00"}, 
				{ delay: 830, type : "action", action: "FC", parameter: "#76d6da"}, 

				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 9400, type : "action", action: "AC", parameter: "NONE,N,Y-200-2000-50-200,#E62B1E"},
				//{ delay: 666, type : "action", action: "FC", parameter: "#00FF00"}, //
				//{ delay: 666, type : "action", action: "FC", parameter: "#4CAF50"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#8BC34A"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#B1D676"}, 
				//{ delay: 646, type : "action", action: "FC", parameter: "#76d6da"}, 
				//{ delay: 601, type : "action", action: "FC", parameter: "#00FF00"}, 
				//{ delay: 830, type : "action", action: "FC", parameter: "#76d6da"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#00FF00"}, //
				//{ delay: 666, type : "action", action: "FC", parameter: "#4CAF50"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#8BC34A"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#B1D676"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#76d6da"}, 
				//{ delay: 601, type : "action", action: "FC", parameter: "#00FF00"}, 
				//{ delay: 830, type : "action", action: "FC", parameter: "#76d6da"}, 

				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 10084, type : "action", action: "AC", parameter: "NONE,N,Y-200-2000-50-200,#0000FF"},
				//{ delay: 666, type : "action", action: "FC", parameter: "#00FF00"}, //
				//{ delay: 666, type : "action", action: "FC", parameter: "#4CAF50"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#8BC34A"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#B1D676"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#76d6da"}, 
				//{ delay: 801, type : "action", action: "FC", parameter: "#00FF00"}, 
				//{ delay: 859, type : "action", action: "FC", parameter: "#76d6da"}, 
				//{ delay: 666, type : "action", action: "FC", parameter: "#00FF00"}, //
				//{ delay: 666, type : "action", action: "FC", parameter: "#4CAF50"}, 
				//{ delay: 766, type : "action", action: "FC", parameter: "#8BC34A"}, 
				//{ delay: 766, type : "action", action: "FC", parameter: "#B1D676"}, 
				//{ delay: 766, type : "action", action: "FC", parameter: "#76d6da"}, 
				//{ delay: 601, type : "action", action: "FC", parameter: "#00FF00"}, 
				//{ delay: 863, type : "action", action: "FC", parameter: "#76d6da"}, 
				
				// 134000 - 142000
				//{ delay: 8000, type : "action", action: "FC", parameter: "#000000"}, // Plus calme

				{ delay: 100, type : "action", action: "B", parameter: "20"},
				
				{ delay: 1400, type : "action", action: "FC", parameter: "#9C27B0"},
				{ delay: 1300, type : "action", action: "FC", parameter: "#FFEB3B"},
				{ delay: 1500, type : "action", action: "FC", parameter: "#3F51B5"},
				{ delay: 1500, type : "action", action: "FC", parameter: "#8BC34A"},
				{ delay: 1700, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 900, type : "action", action: "FC", parameter: "#75CEDE"},
				

				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1200, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF"}, // Reprise rythmée
				//{ delay: 27000, type : "action", action: "FC", parameter: "#000000"}, // Calme

				
				// Plusieurs couleurs pastel
				// 144000 - 171000 (2'24 - 2'51)
				{ delay: 100, type : "action", action: "FC", parameter: "#9C27B0"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFEB3B"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#3F51B5"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#8BC34A"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#75CEDE"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#9C27B0"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFEB3B"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#3F51B5"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#8BC34A"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1200, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#75CEDE"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#9C27B0"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFEB3B"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#3F51B5"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#8BC34A"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#75CEDE"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#9C27B0"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFEB3B"},
				{ delay: 1300, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#3F51B5"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#8BC34A"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,Y,N-0-500,#9C27B0,#FFEB3B,#3F51B5,#8BC34A,#E62B1E,#75CEDE"},
				
				
				{ delay: 1000, type : "action", action: "VIB", parameter: "0,900"}, // Effet de distortion (Vibreur ?)

				// 172000 - 198500 (2'52 - 3'18.500)
				//{ delay: 26500, type : "action", action: "FC", parameter: "#FFFFFF"}, // Reprise avec écho

				// Couleurs TEDx
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1800, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1000, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
				{ delay: 1100, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1900, type : "action", action: "AC", parameter: "NONE,N,Y-0-0-100-500,#E62B1E,#FFFFFF,#000000"},
								
				
				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"}, // Pause calme

				// 199500 - 227000 (3'19.500 - 3'47 )
				//{ delay: 27500, type : "action", action: "FC", parameter: "#E62B1E"}, // Reprise

				// Toutes les couleurs
				// TODO : 				{ delay: 00, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				
				{ delay: 100, type : "action", action: "FC", parameter: "#FFEB3B"},
				{ delay: 1200, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#3F51B5"},
				{ delay: 2100, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#8BC34A"},
				{ delay: 1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#75CEDE"},
				{ delay: 2300, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFEB3B"},
				{ delay: 1500, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#3F51B5"},
				{ delay: 1300, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#8BC34A"},
				{ delay: 2300, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#E62B1E"},
				{ delay: 2300, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#75CEDE"},
				{ delay: 3100, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#FFEB3B"},
				{ delay: 2300, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#3F51B5"},
				{ delay: 3300, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ delay: 100, type : "action", action: "FC", parameter: "#8BC34A"},
				{ delay: 100, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				
				// -100

				// 227000 - 229000 I GOT YOU
				{ delay: 100, type : "action", action: "FC", parameter: "#FFFFFF"},
			
				{ delay: 2000, type : "action", action: "VIB", parameter: "0,500,100,400,100,700"}, // I Got you en paroles seules (2 secondes)

				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 10000, type : "action", action: "FLASH", parameter: "500,500,10"},
				{ delay: 100, type : "action", action: "FLASH", parameter: "0,0,0"},

				{ delay: 3000, type : "action", action: "FC", parameter: "#000000"},

				// MERCI POUR VOTRE PARTICIPATION
				{ delay: 2000000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Merci pour votre participation au<br/><font color=red><b>TEDx</b></font> Avignon<br/><br/>avec<br/>Light4Events</font></CENTER></h1></BODY>"},
				{ delay: 1000000, type : "action", action: "FC", parameter: "#000000"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#automode_rct").click(function(){

	var jsonObj = {
			show_id : current_show_id,
			timedActionList: [
				{ delay: 100, type : "action", action: "B", parameter: "100"},
				{ delay: 100, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 7000, type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_rct.png"},
				{ delay: 2000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Parce que TOULON</font></CENTER></h1></BODY>"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#FF0000"},
				{ delay: 1000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Parce que TOULON</font></CENTER></h1></BODY>"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 1000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Parce que TOULON</font></CENTER></h1></BODY>"},
				{ delay: 1000, type : "action", action: "FC", parameter: "#FF0000"},
				{ delay: 3000, type : "action", action: "FC", parameter: "#000000"},
				{ delay: 5000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><h1><CENTER><font color=white>Dimanche soir au moment de la mi-temps, nous avons fait scintiller tout le stade.</font></CENTER></h1></BODY>"},
				{ delay: 6000, type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><h1><CENTER><font color=white>Un grand merci à tous ceux qui nous ont aidé.</font></CENTER></h1></BODY>"},
				{ delay: 6000, type : "action", action: "FLASH", parameter: "300,300,10"},
				{ delay: 100, type : "action", action: "FLASH", parameter: "0,0,0"},
			]
		};
    
	socket.emit('automode', jsonObj);
	return false;
});


//##################################################
//# SOUND ACTIONS
//##################################################
$("#soundActionRed").click(function(){

	 var jsonObj = {
		    	show_id : current_show_id,
		        action: 'ASC',
		        value: "#000000,#FF0000",
	    };
	    socket.emit('action', jsonObj);
	return false;
});

$("#soundActionGreen").click(function(){

	 var jsonObj = {
		    	show_id : current_show_id,
		        action: 'ASC',
		        value: "#000000,#00FF00",
	    };
	    socket.emit('action', jsonObj);
	return false;
});

$("#soundActionBlue").click(function(){

	 var jsonObj = {
		    	show_id : current_show_id,
		        action: 'ASC',
		        value: "#000000,#0000FF",
	    };
	    socket.emit('action', jsonObj);
	return false;
});

$("#soundActionRedBlue").click(function(){

	 var jsonObj = {
		    	show_id : current_show_id,
		        action: 'ASC',
		        value: "#FF0000,#0000FF",
	    };
	    socket.emit('action', jsonObj);
	return false;
});


$("#soundActionWhite").click(function(){

	 var jsonObj = {
		    	show_id : current_show_id,
		        action: 'ASC',
		        value: "#000000,#FFFFFF",
	    };
	    socket.emit('action', jsonObj);
	return false;
});


$("#soundActionWhiteRed").click(function(){

	 var jsonObj = {
		    	show_id : current_show_id,
		        action: 'ASC',
		        value: "#FFFFFF,#FF0000",
	    };
	    socket.emit('action', jsonObj);
	return false;
});


$("#soundActionRedWhite").click(function(){

	 var jsonObj = {
		    	show_id : current_show_id,
		        action: 'ASC',
		        value: "#FF0000,#FFFFFF",
	    };
	    socket.emit('action', jsonObj);
	return false;
});


$("#soundActionWhiteBlue").click(function(){

	 var jsonObj = {
		    	show_id : current_show_id,
		        action: 'ASC',
		        value: "#FFFFFF,#0000FF",
	    };
	    socket.emit('action', jsonObj);
	return false;
});


//##################################################
//# BULK ACTIONS
//##################################################
$("#bulk_hyperconnexion").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#FFFFFF"},
				{ type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/hyperconnexion/content/imgs/xenia.jpg"},
				{ type : "action", action: "FLASH", parameter: "0,100,1"},
				{ type : "action", action: "VIB", parameter: "0,100,200,100"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

//##################################################
//# BULK ACTIONS
//##################################################
$("#bulk_flash100").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "AC", parameter: "NONE,N,N-100-100,#000000,#FFFFFF"},
				{ type : "action", action: "FLASH", parameter: "100,100,-1"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

//##################################################
//# BULK RCT
//##################################################
$("#bulk_RCT1").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "IMG", parameter: "http://tristan-salaun.com/l4e/content/imgs/logo_rct.png"},
				{ type : "action", action: "FLASH", parameter: "500,500,-1"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#bulk_RCT2").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "AC", parameter: "NONE,N,N-1000-1000,#FF0000"},
				{ type : "action", action: "FLASH", parameter: "1000,1000,-1"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#bulk_RCT3").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>Vous êtes en train de faire scintiller le stade :-D</font></CENTER></h1></BODY>"},
				{ type : "action", action: "FLASH", parameter: "200,200,-1"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});


$("#bulk_RCT4").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "HTML", parameter: "<BODY BGCOLOR=#000000><BR/><BR/><BR/><BR/><h1><CENTER><font color=white>MERCI DE VOTRE PARTICIPATION.<br/><br/>On recommence au coup d'envoi de la reprise ? ;-)</font></CENTER></h1></BODY>"},
				{ type : "action", action: "FLASH", parameter: "200,1000,-1"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});


//##################################################
//# DEMO 2016_09_26
//##################################################

$("#demo1_01").click(function(){
/*
	var jsonObj = {
				show_id : current_show_id,
				timedActionList: [
					{ delay: 100, type : "action", action: "B", parameter: "100"},
					{ delay: 100, type : "action", action: "FC", parameter: "#a20353"},
					{ delay:1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
					{ delay: 100, type : "action", action: "FC", parameter: "#fc6303"},
					{ delay:1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
					{ delay: 100, type : "action", action: "FC", parameter: "#8cd50a"},
					{ delay:1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
					{ delay: 100, type : "action", action: "FC", parameter: "#0cb7bf"},
					{ delay:1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
					{ delay: 100, type : "action", action: "FC", parameter: "#02575e"},
					{ delay:400, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
					{ delay: 100, type : "action", action: "FC", parameter: "#a20353"},
					{ delay:1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
					{ delay: 100, type : "action", action: "FC", parameter: "#fc6303"},
					{ delay:1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
					{ delay: 100, type : "action", action: "FC", parameter: "#8cd50a"},
					{ delay:1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
					{ delay: 100, type : "action", action: "FC", parameter: "#0cb7bf"},
					{ delay:1900, type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				]
			};
*/
var jsonObj = {
		show_id : current_show_id,
		timedActionList: [
			{ delay: 1000, type : "action", action: "FC", parameter: "#000000"},
			{ delay:5000, type : "bulk", parameter: {actionList: [{ type : "action", action: "B", parameter: "100"},{ type : "action", action: "FC", parameter: "#a20353"},{ type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},{ type : "action", action: "FLASH", parameter: "200,300,16"}]} },
			{ delay: 1000, type : "action", action: "FC", parameter: "#FFFFFF"},
		]
	};
    
	socket.emit('automode', jsonObj);
	return false;
});

$("#demo1_step0_01").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#a20353"},
				{ type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ type : "action", action: "FLASH", parameter: "200,300,16"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step0_02").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#a20353"},
				{ type : "action", action: "AC", parameter: "NONE,N,N-0-2000,#4CAF50,#8BC34A,#FFEB3B,#FF9800,#FF5722,#795548,#9E9E9E,#9E9E9E"},
				{ type : "action", action: "FLASH", parameter: "200,800,16"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});



$("#demo1_step1_01").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#a20353"},
				{ type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step1_02").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#fc6303"},
				{ type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step1_03").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#0cb7bf"},
				{ type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step1_04").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#8cd50a"},
				{ type : "action", action: "AC", parameter: "NONE,Y,N-0-200"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});


$("#demo1_step2_01").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#02575e"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step2_02").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#1358b5"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step2_03").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#5734FF"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step2_04").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#F5276F"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step2_05").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#97C345"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step2_06").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#6512A3"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step2_07").click(function(){

	var jsonObj = {
			actionList: [
				{ type : "action", action: "B", parameter: "100"},
				{ type : "action", action: "FC", parameter: "#2497D6"},
				{ type : "action", action: "FLASH", parameter: "200,800,2"}
			]
		};
	socket.emit('bulk', jsonObj);
	return false;
});

$("#demo1_step3_01").click(function(){

	var actionACMessage = {
			show_id : current_show_id,
		action: 'AC',
		value: "NONE,Y,N-0-200,#fff600,#ffbe00,#ff6600,#ff3900,#ff0e00,#FF0000",
	};

	socket.emit('action', actionACMessage);

	return false;
});


$("#demo1_step3_02").click(function(){

	var actionACMessage = {
			show_id : current_show_id,
		action: 'AC',
		value: "NONE,Y,N-0-200,#b21fbf,#851fbf,#5c3dbf,#3e90ff,#3ed8ff,#10f3db,#2de5a6",
	};

	socket.emit('action', actionACMessage);

	return false;
});



// ##################################################
// # FORMATION COACHING
// ##################################################

$("#coaching_q1").click(function(){

	var questionOption1 = {title: "How", value:"q1_1"};
	var questionOption2 = {title: "What", value:"q1_2"};
	var questionOption3 = {title: "Which", value:"q1_3"};

	var questionOptionsList = [questionOption1, questionOption2, questionOption3];

	var questionRequest = {
		show_id : current_show_id,
		id : "coaching1",
		title: "Complétez la phrase : ??? did you do that for ?",
		options: questionOptionsList
	};
	socket.emit('question', questionRequest);
	return false;
});

 $("#coaching_r1").click(function(){

	var actionDiff1 = {
		action: 'FC',
		value: "#FF0000",
	};
	var actionDiff2 = {
		action: 'FC',
		value: "#00FF00",
	};
	var actionDiff3 = {
		action: 'FC',
		value: "#FF0000",
	};

	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'q1_1', command: 'action', valueCommand: actionDiff1}, {value: 'q1_2',  command: 'action', valueCommand: actionDiff2}, {value: 'q1_3',  command: 'action', valueCommand: actionDiff3} ]
			};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});

$("#coaching_q2").click(function(){

	var questionOption1 = {title: "whatever", value:"q2_1"};
	var questionOption2 = {title: "however", value:"q2_2"};
	var questionOption3 = {title: "whichever", value:"q2_3"};

	var questionOptionsList = [questionOption1, questionOption2, questionOption3];

	var questionRequest = {
		show_id : current_show_id,
		id : "coaching2",
		title: "Complétez la phrase : You have to go on, ??? difficulties you meet.",
		options: questionOptionsList
	};
	socket.emit('question', questionRequest);
	return false;
});

 $("#coaching_r2").click(function(){

	var actionDiffOK = {
		action: 'FC',
		value: "#00FF00",
	};
	var actionDiffKO = {
		action: 'FC',
		value: "#FF0000",
	};
	
	var actionDiffMessage = {
			show_id : current_show_id,
			actionDiff : [ {value: 'q2_1', command: 'action', valueCommand: actionDiffOK}, {value: 'q2_2',  command: 'action', valueCommand: actionDiffKO}, {value: 'q2_3',  command: 'action', valueCommand: actionDiffKO} ]
			};

	socket.emit('action_diff', actionDiffMessage);

	return false;
});



// ##################################################
// # PSG
// ##################################################

$("#question_psg").click(function(){

	var questionOption1 = {title: "A. Rabiot", value:"a_rabiot"};
	var questionOption2 = {title: "S. Aurier", value:"s_aurier"};
	var questionOption3 = {title: "E. Cavani", value:"e_cavani"};
	var questionOption4 = {title: "P. Kimpembe", value:"p_kimpembe"};
	var questionOption5 = {title: "M. Verratti", value:"m_verratti"};

	var questionOptionsList = [questionOption1, questionOption2, questionOption3, questionOption4, questionOption5];

	var questionRequest = {
		show_id : current_show_id,
		id : "qpsg",
		title: "Quel est l'homme du match selon vous ?",
		options: questionOptionsList
	};
	socket.emit('question', questionRequest);
	return false;
});

// ##################################################
// # Advanced Sound
// ##################################################
$("#asound_tonerre_3fois").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "N,N,3000-3000,3,http://tristan-salaun.com/l4e/content/sound/tonerre.mp3",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#asound_tonerre_pause_avant").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "N,Y,3000-10000,1,http://tristan-salaun.com/l4e/content/sound/tonerre.mp3",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#asound_tonerre_grillon_sequence").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "N,N,5000-5000,5,http://tristan-salaun.com/l4e/content/sound/tonerre.mp3,http://tristan-salaun.com/l4e/content/sound/grillons.mp3",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#asound_tonerre_grillon_aleatoire").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "Y,N,5000-5000,5,http://tristan-salaun.com/l4e/content/sound/tonerre.mp3,http://tristan-salaun.com/l4e/content/sound/grillons.mp3",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#asound_tonerre_un_coup_sur_4").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "Y,N,0-0,1,http://tristan-salaun.com/l4e/content/sound/tonerre.mp3,,,",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#asound_chien_random").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "Y,N,1000-5000,10,http://tristan-salaun.com/l4e/content/sound/chien_01.wav,http://tristan-salaun.com/l4e/content/sound/chien_02.mp3,http://tristan-salaun.com/l4e/content/sound/chien_03.mp3,http://tristan-salaun.com/l4e/content/sound/chien_04.mp3",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#asound_city").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "Y,N,1000-5000,10,http://tristan-salaun.com/l4e/content/sound/city/ambulance.mp3,http://tristan-salaun.com/l4e/content/sound/city/ambulance2.mp3,http://tristan-salaun.com/l4e/content/sound/city/carrbrake.mp3,http://tristan-salaun.com/l4e/content/sound/city/car_door.mp3,http://tristan-salaun.com/l4e/content/sound/city/construction.mp3,http://tristan-salaun.com/l4e/content/sound/city/jackhammer1.mp3,http://tristan-salaun.com/l4e/content/sound/city/police.mp3,http://tristan-salaun.com/l4e/content/sound/city/traffic.mp3,http://tristan-salaun.com/l4e/content/sound/city/traffichorns.mp3,http://tristan-salaun.com/l4e/content/sound/city/trafficjam.mp3,http://tristan-salaun.com/l4e/content/sound/city/truckhorn.mp3",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#asound_dogs").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "Y,N,1000-5000,10,http://tristan-salaun.com/l4e/content/sound/dogs/dog.mp3,http://tristan-salaun.com/l4e/content/sound/dogs/dog2.mp3,http://tristan-salaun.com/l4e/content/sound/dogs/dog3.mp3,http://tristan-salaun.com/l4e/content/sound/dogs/dogbark5.mp3,http://tristan-salaun.com/l4e/content/sound/dogs/dogbrk.mp3,http://tristan-salaun.com/l4e/content/sound/dogs/dogs.mp3",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#asound_forest").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "Y,N,1000-5000,10,http://tristan-salaun.com/l4e/content/sound/forest_night/bat1.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/coyote2.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/frogs.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/howl.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/mex.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/rainforestambience.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/swamp1.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/wolf2.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/wolf3.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/wolf5.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/wolf6.mp3,http://tristan-salaun.com/l4e/content/sound/forest_night/wolf7.mp3",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#asound_jungle").click(function(){

	var actionJson = {
		show_id : current_show_id,
		action: 'ASOUND',
		value: "Y,N,1000-5000,10,http://tristan-salaun.com/l4e/content/sound/jungle/baboon1.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/baligator3.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/bob_cat.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/cheetah2.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/cougar.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/cougar7.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/hyena1.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/jaguar2.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/jaguarrors.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/jungle.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/jungle2.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/junglebird.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/lioncub2.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/monkey1.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/monkeypatas.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/panther6.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/panther7.mp3,http://tristan-salaun.com/l4e/content/sound/jungle/summer.mp3",
	};

	socket.emit('action', actionJson);

	return false;
});

$("#clean_watermark").click(function(){

	var action = {
	    		show_id : current_show_id,
		        action: 'WM',
		        value: '',
	    };
	    socket.emit('action', action);

	return false;
});


// ##################################################
// # Orientation
// ##################################################
$("#orientation_FULL_SENSOR").click(function(){

	var action = {
	    		show_id : current_show_id,
		        action: 'ORI',
		        value: 'FULL_SENSOR',
	    };
	    socket.emit('action', action);

	return false;
});

$("#orientation_LANDSCAPE").click(function(){

	var action = {
	    		show_id : current_show_id,
		        action: 'ORI',
		        value: 'LANDSCAPE',
	    };
	    socket.emit('action', action);

	return false;
});

$("#orientation_PORTRAIT").click(function(){

	var action = {
	    		show_id : current_show_id,
		        action: 'ORI',
		        value: 'PORTRAIT',
	    };
	    socket.emit('action', action);

	return false;
});

$("#orientation_REVERSE_LANDSCAPE").click(function(){

	var action = {
	    		show_id : current_show_id,
		        action: 'ORI',
		        value: 'REVERSE_LANDSCAPE',
	    };
	    socket.emit('action', action);

	return false;
});

$("#orientation_REVERSE_PORTRAIT").click(function(){

	var action = {
	    		show_id : current_show_id,
		        action: 'ORI',
		        value: 'REVERSE_PORTRAIT',
	    };
	    socket.emit('action', action);

	return false;
});

$("#orientation_SENSOR_LANDSCAPE").click(function(){

	var action = {
	    		show_id : current_show_id,
		        action: 'ORI',
		        value: 'SENSOR_LANDSCAPE',
	    };
	    socket.emit('action', action);

	return false;
});

$("#orientation_SENSOR_PORTRAIT").click(function(){

	var action = {
	    		show_id : current_show_id,
		        action: 'ORI',
		        value: 'SENSOR_PORTRAIT',
	    };
	    socket.emit('action', action);

	return false;
});

// ##################################################
// # MATRIX
// ##################################################

$("#matrix").click(function(){

	var action = {
	    		show_id : current_show_id,
		        x: 3,
		        y: 3,
	    };
	    socket.emit('matrix', action);

	return false;
});

$("#pos").click(function(){

	    socket.emit('pos', null);

	return false;
});
$("#pos2").click(function(){

	    socket.emit('pos', null);

	return false;
});


// ##################################################
// # Reactions
// ##################################################

/*
socket.on('pong', function(msg){
	var action = JSON.parse(msg);
	var d = new Date();
	alert(action.server + " " + action.client + " " + d.getTime() + " " + (d.getTime() - action.client) );
});
*/


socket.on('nb_users', function(msg){
	
	if(msg > maxConnected){
		maxConnected = msg;
	}
	
	$('#nb_users').text( msg + " (" + maxConnected + ")" );
});

});
