const WebSocketServer = require("ws").Server;
const shortid = require("shortid");
const http = require("http");
const express = require("express");
const app = express();
const port = process.env.PORT || 5000;
const fs = require('fs') // To delete files

var request = require('request'); //To post request


// TODO : Get the last action stored (to display it on the admin pannel)
// TODO : AUTO Mode
// TODO : Stop automode when no more user connecteds to the event
// TODO : Launch again the auto mode when a user connect to the event
// TODO : Implement the admin mode
// TODO : Implement sending stats of the votes to the admin
// TODO : Implement auto mode relaunch auto

//File persistence
const jsonFile = require('jsonfile');
// const util = require('util');
const lastActionLaunchedForShowFileName = 'data_last_action.json';
const lastActionSoundLevelLaunchedForShowFileName = 'data_last_sound_level.json';
const lastActionBrightnessLaunchedForShowFileName = 'data_last_brightness.json';
const lastActionOrientationLaunchedForShowFileName = 'data_last_orientation.json';
const lastActionWatermarkLaunchedForShowFileName = 'data_last_watermark.json';
const lastActionStickyQuestionForShowFileName = 'data_last_sticky_question.json';

const actionDiffFileName = 'data_action_diff.json';
const lastAutoModeFileName = 'data_last_auto.json';

// Store the last actions sent
let lastActionLaunchedForShow = {};
let lastActionSoundLevelLaunchedForShow = {};
let lastActionBrightnessLaunchedForShow = {};
let lastActionOrientationLaunchedForShow = {};
let lastActionWatermarkLaunchedForShow = {};
let lastActionStickyQuestionForShow = {};

//Handle automatic loop 
let loopStep = {};
let loopSequence = {};
let loopMethod = {};
// Auto trig automode after an amount of time
let loopWatchDog = {};


// Statistics on users connected
let nbreOfUsersConnected = {};

// Used to loop on user admin more efficiently
let userAdminList = {};

// Handle Matrix demo
let matrix;

// Handle automatic reaction to answers
let actionDiff = {};

// Handle statics
let statsUsers = {};
let statsUsersAlreadyRecorded = {};
let statsOpenQuestions = {};


// TODO : restart all the init methods
// process.on('uncaughtException', function (err) {
//     console.error(err);
//     console.log("Reset all the all the application ...");
//
//     // ####################
//     // # Delete the files #
//     // ####################
//     try {
//         fs.unlinkSync(lastActionLaunchedForShowFileName)
//     } catch (err) {
//         console.error(err)
//     }
//     try {
//         fs.unlinkSync(lastActionSoundLevelLaunchedForShowFileName)
//     } catch (err) {
//         console.error(err)
//     }
//     try {
//         fs.unlinkSync(lastActionBrightnessLaunchedForShowFileName)
//     } catch (err) {
//         console.error(err)
//     }
//     try {
//         fs.unlinkSync(lastActionOrientationLaunchedForShowFileName)
//     } catch (err) {
//         console.error(err)
//     }
//     try {
//         fs.unlinkSync(lastActionWatermarkLaunchedForShowFileName)
//     } catch (err) {
//         console.error(err)
//     }
//     try {
//         fs.unlinkSync(actionDiffFileName)
//     } catch (err) {
//         console.error(err)
//     }
//     try {
//         fs.unlinkSync(lastAutoModeFileName)
//     } catch (err) {
//         console.error(err)
//     }
//
//     // RESET the last actions sent
//     lastActionLaunchedForShow = {};
//     lastActionSoundLevelLaunchedForShow = {};
//     lastActionBrightnessLaunchedForShow = {};
//     lastActionOrientationLaunchedForShow = {};
//     lastActionWatermarkLaunchedForShow = {};
//
//     // RESET the automatic loop
//     loopStep = {};
//     loopSequence = {};
//     loopMethod = {};
//     loopWatchDog = {};
//
//     // RESET Statistics on users connected
//     nbreOfUsersConnected = {};
//
//     // RESET user admin list
//     userAdminList = {};
//
//     // Handle Matrix demo
//     // TODO let matrix;
//
//     // RESET Handle automatic reaction to answers
//     actionDiff = {};
//
//     // RESET Handle statics
//     statsUsers = {};
//     statsUsersAlreadyRecorded = {};
// });


app.use(express.static(__dirname + "/"));

const server = http.createServer(app);
server.listen(port);

console.log("http server listening on %d", port);


// ADD THE SOCKET IO BRIDGE
const bridge_socket_io = require('socket.io-client');
const socketIO_serverUrl = 'http://light4events.herokuapp.com/';

console.log("Try to connect to " + socketIO_serverUrl);
socketIO_socket = bridge_socket_io.connect(socketIO_serverUrl);

// FIXME FOR PROD
//socketIO_socket = undefined;

socketIO_socket.on('connect', function () {
    console.log("socket IO connected");

    var actionUserType = {id: "admin", value: "admin"};
    socketIO_socket.emit('user_type', actionUserType);
});
socketIO_socket.on('nb_users', function (msg) {
    console.log("socket IO nb_users " + msg);
});

socketIO_socket.on('question', function (question) {
    // if( !(question.id in questionsList) ){
    //     questionsList[question.id] = question;
    //     console.log('on question Recorded : ' + question.id );
    // }else{
    //     console.log('on question Already known : ' + question.id );
    // }
    console.log("socket IO question " + question);
});
socketIO_socket.on('stats', function (msg) {

    // for testing
    //msg = {"open_q1":{"Ma question de IOS":1,"Une autre question IOS":1}}
    //{"open_q1":{"aaaaa":0,"rrrrrrtttr":1}}

    console.log("socket IO stats " + JSON.stringify(msg));
    for (let type in msg) {
        if (type != "undefined" && type == "open_q1") {

            for (let value in msg[type]) {
                if (msg[type][value] != 0) {
                    manageStatsOpenQuestions("/light4events", type, value);
                } else {
                    console.log("socket IO stats ignore empty value" + type + " - " + value);
                }
            }
            broadcastToAdmin("/light4events", JSON.stringify(statsOpenQuestions));
        }
        if (type != "undefined" && type == "open_q2") {

            for (let value in msg[type]) {
                if (msg[type][value] != 0) {
                    manageStatsOpenQuestions("/light4events", type, value);
                } else {
                    console.log("socket IO stats ignore empty value" + type + " - " + value);
                }
            }
            broadcastToAdmin("/light4events", JSON.stringify(statsOpenQuestions));
        }
        //un petit test de commentaire
        // if(type != "admin" && type != "undefined"){
        //
        //     // If Canvas do not exist, then create it
        //     if( !(type in chartArray) ){
        //         //consdole.log('Create missing chart type ' + type);
        //         chartArray[type] = createChart(type, msg[type]);
        //     }x
        //
        //     var counter = 0;
        //
        //     //console.log('type ' + type);
        //     //console.log('chartArray[type] ' + chartArray[type]);
        //     //console.log('chartArray[type].datasets[0] ' + chartArray[type].datasets[0]);
        //
        //     for (var value in msg[type]) {
        //         //console.log('counter ' + counter);
        //         //console.log('chartArray[type].datasets[0].bars[counter] ' + chartArray[type].datasets[0].bars[counter]);
        //         //console.log('chartArray[type].datasets[0].bars[counter].value ' + chartArray[type].datasets[0].bars[counter].value);
        //         chartArray[type].datasets[0].bars[counter].value = msg[type][value];
        //         chartArray[type].update();
        //         counter++;
        //     }
        // }
    }
});

// socketIO_socket.on('action', function(action) {
//     console.log('What is he saying ? |' + action.action + '| ' + action.value);
// });

// socketIO_socket.on('bulk', function(action) {
//     console.log('bulk');
// });

// socketIO_socket.on('pong', function(pongMessage) {
//     console.log('PONG ' + pongMessage);
// });

// socketIO_socket.on('start_delay', function(startDelayMessage) {
//     console.log('START DELAY ' + startDelayMessage);
// });

// socketIO_socket.on('loading', function(loadingMessage) {
//     console.log('LOADING ' + loadingMessage);
// });
// END SOCKET IO BRIDGE

//SETUP THE SERVER
//File persistence : Last action
jsonFile.readFile(lastActionLaunchedForShowFileName, function (err, obj) {
    console.log('READ LAST ACTION: ' + JSON.stringify(obj));
    if (typeof obj != 'undefined' && obj != null) {
        lastActionLaunchedForShow = obj;
    }
});
//File persistence : Last sound level
jsonFile.readFile(lastActionSoundLevelLaunchedForShowFileName, function (err, obj) {
    console.log('READ LAST SOUND LEVEL: ' + JSON.stringify(obj));
    if (typeof obj != 'undefined' && obj != null) {
        lastActionSoundLevelLaunchedForShow = obj;
    }
});
//File persistence : Last brightness
jsonFile.readFile(lastActionBrightnessLaunchedForShowFileName, function (err, obj) {
    console.log('READ LAST BRIGHTNESS: ' + JSON.stringify(obj));
    if (typeof obj != 'undefined' && obj != null) {
        lastActionBrightnessLaunchedForShow = obj;
    }
});
//File persistence : Last orientation
jsonFile.readFile(lastActionOrientationLaunchedForShowFileName, function (err, obj) {
    console.log('READ LAST ORIENTATION: ' + JSON.stringify(obj));
    if (typeof obj != 'undefined' && obj != null) {
        lastActionOrientationLaunchedForShow = obj;
    }
});
//File persistence : Last watermark
jsonFile.readFile(lastActionWatermarkLaunchedForShowFileName, function (err, obj) {
    console.log('READ LAST WATERMARK: ' + JSON.stringify(obj));
    if (typeof obj != 'undefined' && obj != null) {
        lastActionWatermarkLaunchedForShow = obj;
    }
});
//File persistence : Last sticky Question
jsonFile.readFile(lastActionStickyQuestionForShowFileName, function (err, obj) {
    console.log('READ LAST STICKY QUESTION: ' + JSON.stringify(obj));
    if (typeof obj != 'undefined' && obj != null) {
        lastActionStickyQuestionForShow = obj;
    }
});

//File persistence : Last action diff
jsonFile.readFile(actionDiffFileName, function (err, obj) {
    console.log('READ ACTION DIFF: ' + JSON.stringify(obj));
    if (typeof obj != 'undefined' && obj != null) {
        actionDiff = obj;
    }
});


//File persistence : Last auto mode
jsonFile.readFile(lastAutoModeFileName, function (err, obj) {
    console.log('READ LAST AUTO MODE: ' + JSON.stringify(obj));

    if (typeof obj != 'undefined' && obj != null) {
        loopSequence = obj;

        for (let key in loopSequence) {
            if (loopSequence.hasOwnProperty(key)) {
                console.log(`RESTART AUTO MODE  : ${key}`);
                loopStep[key] = 0;
                loopFunction(key);
            }
        }
    } else {
        console.log('RESTART AUTO MODE EMPTY');
    }
});
//END SETUP THE SERVER


// Handle closed sockets
function noop() {
}

function heartbeat() {
    this.isAlive = true;
}

// END Handle closed sockets

// START BRUCE BRIDGE
// var currentRed = 0, currentGreen = 0, currentBlue = 0;
// 
// function handleBruceValue(valueParam){
// 	var currentValue = Math.trunc(valueParam * 255);
// 	if(currentValue > 255) {
// 		currentValue = 255;
// 	}
// 	if(currentValue < 0) {
// 		currentValue = 0;
// 	}
// 	return currentValue;
// }
// 
// function rgbToHex(R,G,B) {return toHex(R)+toHex(G)+toHex(B)}
// function toHex(n) {
//  n = parseInt(n,10);
//  if (isNaN(n)) return "00";
//  n = Math.max(0,Math.min(n,255));
//  return "0123456789ABCDEF".charAt((n-n%16)/16)
//       + "0123456789ABCDEF".charAt(n%16);
// }
// 
// function handleBruceCommand(message){
// 	// {"params" :[{ "name":1,"value":0.669291}]}
// 	// name : 1 => Red
// 	// name : 2 => Green
// 	// name : 3 => Blue
// 	try {
// 		var obj = JSON.parse(message);
// 		
// 		var nameParam = obj.params[0].name;
// 		var valueParam = obj.params[0].value;
// 		
// 		if(nameParam == '1'){
// 			currentRed = handleBruceValue(valueParam);
// 		} else if(nameParam == '2'){
// 			currentGreen = handleBruceValue(valueParam);
// 		} else if(nameParam == '3'){
// 			currentBlue = handleBruceValue(valueParam);
// 		}
// 		
// 		console.log("BRUCE0 " + currentRed + "|" + currentGreen + "|" + currentBlue);
// 		
// 		var colorValue = "#" + rgbToHex(currentRed,currentGreen,currentBlue);
// 		var messageValue = {
// 		type : 'action',
// 		parameters : {
// 					name: 'FC',
// 					parameters: {color:colorValue,fading:'RIEN'}
// 			}
// 		};
// 		
// 		console.log("BRUCE " + JSON.stringify(messageValue));
// 		
// 		return JSON.stringify(messageValue);
// 	
// 	}
// 	catch(error) {
// 	  console.error(error);
// 	}
// }
// function testBruceCommand(message){
// 	return message.startsWith('{"params" :[{');
//	 }
// END BRUCE BRIDGE

function broadcast(wssParam, showId, socketId, msgParam) {
    let count = 0;
    // broadcast message to all connected clients in the room
    wssParam.clients.forEach(function (c) {

        // console.log(`LOOP ${c.upgradeReq.url} | ${c.id}`);
        // console.log(`LOOP ${showId} | ${socketId}`);
        if (c.upgradeReq.url === showId && c.id !== socketId) {
            //FIXME : if (c && c.readyState === WebSocket.OPEN) {
            count++;
            c.send(msgParam);
            //}
        }
    });
    console.log(`broadcast send (${msgParam}) to COUNT = ${count}`);
}

function broadcastFiltered(wssParam, wsParam, msgParam, typeParam, valueParam) {
    console.log(`broadcastFiltered ${msgParam} ${typeParam} ${valueParam}`);

    let count = 0;
    // broadcast message to all connected clients in the room
    wssParam.clients.forEach(function (c) {

        //console.log("LOOP " + c.upgradeReq.url + " " + c.id);
        //console.log("LOOP " + ws.upgradeReq.url + " " + ws.id);

        if (c.upgradeReq.url === wsParam.upgradeReq.url && c.id !== wsParam.id) {
            //FIXME : if (c && c.readyState === WebSocket.OPEN) {
            console.log("broadcastFiltered: " + c.upgradeReq.url);
            console.log("broadcastFiltered: " + c.id);
            if (c.groupValue !== undefined) {
                console.log("broadcastFiltered: groupValue is defined to " + c.groupValue);

                // DEBUG message
                for (let [key, value] of Object.entries(c.groupValue)) {
                    console.log("DEBUG broadcastFiltered " + `${key}: ${value}`);
                }

                if (c.groupValue[typeParam] !== undefined) {
                    console.log("broadcastFiltered: groupValue[" + typeParam + "] is defined to: " + c.groupValue[typeParam]);
                    if (valueParam == "*" || c.groupValue[typeParam] === valueParam) { // Added the wildcard support (*)
                        console.log("broadcastFiltered: groupValue[" + typeParam + "] equals: " + valueParam);
                    } else {
                        console.log("broadcastFiltered: groupValue[" + typeParam + "] = " + c.groupValue[typeParam] + " !=" + valueParam);
                    }
                }
            }


            if (c.groupValue !== undefined && c.groupValue[typeParam] !== undefined && c.groupValue[typeParam] === valueParam) {
                c.send(msgParam);
                count++;
            }
        }
    });
    console.log(`COUNT = ${count}`);
}

function broadcastToAdmin(paramUrl, paramMsg) {
    console.log(`broadcastToAdmin ${paramUrl} ${paramMsg}`);

    let count = 0;
    // broadcast message to all connected admins in the room

    if (userAdminList[paramUrl] !== undefined) {
        for (let [adminSocketId] of Object.entries(userAdminList[paramUrl])) {
            count++;
            userAdminList[paramUrl][adminSocketId].send(paramMsg);
        }
        console.log("ADMIN COUNT = " + count);
    } else {
        console.log("WARNING: broadcastToAdmin not available: NO admin connected for " + paramUrl);
        console.log("WARNING: ADMIN LIST: " + userAdminList);
    }
}


function sendConnexionsStats(ws) {
    let messageValue = {
        type: 'nb_users',
        parameters: {
            value: nbreOfUsersConnected[ws.upgradeReq.url]
        }
    };
    broadcastToAdmin(ws.upgradeReq.url, JSON.stringify(messageValue));
}

//##############################
//# Handle stats
//##############################
function manageStats(paramUrl, paramUUID, paramId, paramValue, paramIncValue) {
    // TODO : check the undefined parameters

    // Do not store the admin stats
    if (paramId === 'admin') {
        return;
    }

    // Do not record a vote twice (in case of closing and opening back the app)
    if (!(paramUrl in statsUsersAlreadyRecorded)) {
        console.log("paramUrl " + paramUrl + " is NOT already in statsUsersAlreadyRecorded\n");
        statsUsersAlreadyRecorded[paramUrl] = {};
    } else {
        console.log("paramUrl " + paramUrl + " is already in statsUsersAlreadyRecorded\n");
    }
    if (!(paramId in statsUsersAlreadyRecorded[paramUrl])) {
        console.log("paramId " + paramId + " is NOT in statsUsersAlreadyRecorded[paramUrl]\n");
        statsUsersAlreadyRecorded[paramUrl][paramId] = {};
    }
    if (paramUUID in statsUsersAlreadyRecorded[paramUrl][paramId]) {
        console.log("paramUUID " + paramUUID + " is already in statsUsersAlreadyRecorded[paramUrl][paramId]");
        console.log("WARNING : vote already recorded for " + paramUUID);
        console.log("export " + JSON.stringify(statsUsersAlreadyRecorded));
        return;
    }

    statsUsersAlreadyRecorded[paramUrl][paramId][paramUUID] = paramUUID;

    if (!(paramUrl in statsUsers)) {
        statsUsers[paramUrl] = {};
    }

    if (!(paramId in statsUsers[paramUrl])) {
        statsUsers[paramUrl][paramId] = {};
    }

    if (!(paramValue in statsUsers[paramUrl][paramId])) {
        statsUsers[paramUrl][paramId][paramValue] = 0;
    }

    statsUsers[paramUrl][paramId][paramValue] = statsUsers[paramUrl][paramId][paramValue] + paramIncValue;
    // Avoid negative values
    if (statsUsers[paramUrl][paramId][paramValue] < 0) {
        statsUsers[paramUrl][paramId][paramValue] = 0;
    }

    console.log('Stat ' + paramUrl + ' ' + paramId + "[" + paramValue + "] = " + statsUsers[paramUrl][paramId][paramValue]);
}

function manageStatsOpenQuestions(paramUrl, paramId, paramValue) {
    // TODO : check the undefined parameters

    if (!(paramUrl in statsOpenQuestions)) {
        console.log("paramUrl " + paramUrl + " is NOT already in statsOpenQuestions\n");
        statsOpenQuestions[paramUrl] = {};
    } else {
        console.log("paramUrl " + paramUrl + " is already in statsOpenQuestions\n");
    }
    if (!(paramId in statsOpenQuestions[paramUrl])) {
        console.log("paramId " + paramId + " is NOT in statsUsersAlreadyRecorded[paramUrl]\n");
        statsOpenQuestions[paramUrl][paramId] = {};
    }

    // Put the word clouds into lowercase if it has a value.
    if (paramId.startsWith("wordcloud") && paramValue) {
        paramValue = paramValue.toLowerCase();
    }

    if (paramValue in statsOpenQuestions[paramUrl][paramId]) {
        statsOpenQuestions[paramUrl][paramId][paramValue] = statsOpenQuestions[paramUrl][paramId][paramValue] + 1
    } else {
        statsOpenQuestions[paramUrl][paramId][paramValue] = 1;
    }

    console.log('Stat ' + paramUrl + ' ' + paramValue + " " + paramId + " = " + JSON.stringify(statsOpenQuestions[paramUrl][paramId]));
}


const wss = new WebSocketServer({server: server});
console.log("websocket server created");

wss.on("connection", function (ws, req) {
    // PUT THE method back
    // https://github.com/websockets/ws/pull/1099
    ws.upgradeReq = req;
    console.log("URL connected client " + ws.upgradeReq.url);

    // Handle static on connected users
    if (typeof nbreOfUsersConnected[ws.upgradeReq.url] == 'undefined') {
        nbreOfUsersConnected[ws.upgradeReq.url] = 0;
    }
    nbreOfUsersConnected[ws.upgradeReq.url] = nbreOfUsersConnected[ws.upgradeReq.url] + 1;

    sendConnexionsStats(ws);

    // Set uniq id to client (to avoid sending it's own messages).
    ws.id = shortid();

    // Handle closed sockets
    ws.isAlive = true;
    ws.on('pong', heartbeat);
    // END Handle closed sockets


    const ip = req.connection.remoteAddress;
    // If under NGNX server
    // const ip = client.headers['x-forwarded-for'].split(/\s*,\s*/)[0];
    console.log("STORE DB websocket id: " + ws.id + " connection received from ip = " + ip);


    // Send the last action to the connected device
    // Timer to wait for the app to start properly
    setTimeout(function () {
        // Handle the last action sent
        if (typeof lastActionLaunchedForShow[ws.upgradeReq.url] != 'undefined' && lastActionLaunchedForShow[ws.upgradeReq.url] != null) {
            console.log('AUTO SEND LAST ACTION ' + JSON.stringify(lastActionLaunchedForShow[ws.upgradeReq.url]));
            try {
                ws.send(lastActionLaunchedForShow[ws.upgradeReq.url]);
            } catch (err) {
                console.error(err)
            }
        } else {
            if (ws.upgradeReq.url === "/") {
                console.log('NO ROOT SHOW');
            } else {
                console.log('join_show NO AUTO SEND LAST ACTION FOR SHOW : ' + ws.upgradeReq.url);
                console.log('join_show NO AUTO SEND LAST ACTION VAR lastActionLaunchedForShow[ws.upgradeReq.url] : ' + JSON.stringify(lastActionLaunchedForShow[ws.upgradeReq.url]));
                console.log('join_show NO AUTO SEND LAST ACTION VAR typeof : ' + (typeof lastActionLaunchedForShow[ws.upgradeReq.url]));
                console.log('join_show NO AUTO SEND LAST ACTION VAR (lastActionLaunchedForShow[ws.upgradeReq.url] != null) : ' + (lastActionLaunchedForShow[ws.upgradeReq.url] != null));
            }
        }
        // Do the same for the last settings
        // Sound level
        if (typeof lastActionSoundLevelLaunchedForShow[ws.upgradeReq.url] != 'undefined' && lastActionSoundLevelLaunchedForShow[ws.upgradeReq.url] != null) {
            // console.log('AUTO SEND LAST SOUND LEVEL ACTION ' + JSON.stringify(lastActionSoundLevelLaunchedForShow[ws.upgradeReq.url]));
            ws.send(lastActionSoundLevelLaunchedForShow[ws.upgradeReq.url]);
        }
        // Brightness
        if (typeof lastActionBrightnessLaunchedForShow[ws.upgradeReq.url] != 'undefined' && lastActionBrightnessLaunchedForShow[ws.upgradeReq.url] != null) {
            // console.log('AUTO SEND LAST BRIGHTNESS ACTION ' + JSON.stringify(lastActionBrightnessLaunchedForShow[ws.upgradeReq.url]));
            ws.send(lastActionBrightnessLaunchedForShow[ws.upgradeReq.url]);
        }
        // Orientation
        if (typeof lastActionOrientationLaunchedForShow[ws.upgradeReq.url] != 'undefined' && lastActionOrientationLaunchedForShow[ws.upgradeReq.url] != null) {
            // console.log('AUTO SEND LAST ORIENTATION ACTION ' + JSON.stringify(lastActionOrientationLaunchedForShow[ws.upgradeReq.url]));
            ws.send(lastActionOrientationLaunchedForShow[ws.upgradeReq.url]);
        }
        // Watermark
        if (typeof lastActionWatermarkLaunchedForShow[ws.upgradeReq.url] != 'undefined' && lastActionWatermarkLaunchedForShow[ws.upgradeReq.url] != null) {
            // console.log('AUTO SEND LAST WATERMARK ACTION ' + JSON.stringify(lastActionWatermarkLaunchedForShow[ws.upgradeReq.url]));
            ws.send(lastActionWatermarkLaunchedForShow[ws.upgradeReq.url]);
        }
        // Sticky Question
        if (typeof lastActionStickyQuestionForShow[ws.upgradeReq.url] != 'undefined' && lastActionStickyQuestionForShow[ws.upgradeReq.url] != null) {
            // console.log('AUTO SEND LAST STICKY QUESTION ACTION ' + JSON.stringify(lastActionStickyQuestionForShow[ws.upgradeReq.url]));
            ws.send(lastActionStickyQuestionForShow[ws.upgradeReq.url]);
        }
    }, 1000);

    ws.on("open", function () {
        console.log('connected');
    });

    ws.on('message', function incoming(msg) {
        console.log("< message " + msg);
        console.log("< URL " + ws.upgradeReq.url);

        let show_id_value = ws.upgradeReq.url;

        let obj = {};
        try {
            obj = JSON.parse(msg);

            // Handle bruce messages
            //	if(testBruceCommand(msg)){
            //		msg = handleBruceCommand(msg);
            //	}


            // Handle message from AUTOMODE
            if (obj.automode === true) {
                if (obj.show_id === undefined) {
                    console.error("AUTOMODE ERROR : no show_id !");
                    return;
                }
                show_id_value = obj.show_id;
                // console.log("AUTOMODE : show_id " + show_id_value);
            } else {

                // If there is an auto mode defined, then handle the auto mode features.
                if (typeof loopSequence[show_id_value] != 'undefined' && loopSequence[show_id_value] != null) {

                    if (obj.type === 'action' || obj.type === 'question') { // FIXME : handle bulk, ....
                        //console.log("AUTOMODE : STOP show show_id " + show_id_value);
                        if (typeof loopMethod[show_id_value] != 'undefined' && loopMethod[show_id_value] != null) {
                            clearTimeout(loopMethod[show_id_value]);
                        }

                        // arm again the timer to autolaunch the auto mode after the timeout.
                        // Reset the timer if it has not beed triggered
                        if (typeof loopWatchDog[show_id_value] !== undefined && loopWatchDog[show_id_value] != null) {
                            //console.log("AUTOMODE : clear watchdog " + show_id_value);
                            clearTimeout(loopWatchDog[show_id_value]);
                        }

                        console.log('AUTOMODE : Will try to restart the automode for ' + show_id_value + " in " + loopSequence[show_id_value].autotrigDelay);
                        // Set the timeout if not -1
                        if (loopSequence[show_id_value].autotrigDelay >= 0) {
                            loopWatchDog[show_id_value] = setTimeout(function () {
                                // Restart the automode
                                console.log('AUTOMODE : Restart the automode ' + show_id_value + " => " + JSON.stringify(loopSequence[show_id_value]));
                                loopStep[show_id_value] = 0;
                                loopFunction(show_id_value);
                            }, loopSequence[show_id_value].autotrigDelay);
                        }
                    }
                }
            }

            // ##### HANDLE MATRIX DEMO #####
            // From admin
            if (obj.type === 'matrix') {
                console.log('< matrix ' + JSON.stringify(msg));

                let matrixData = {};
                matrixData.sizex = obj.parameters.size_x;
                matrixData.sizey = obj.parameters.size_y;
                matrixData.currentx = 0;
                matrixData.currenty = 0;

                //FIXME: handle multiple events matrix[msg.show_id] = matrixData;
                matrix = matrixData;

                let messageValue = {
                    type: 'pos'
                };

                broadcast(wss, show_id_value, ws.id, JSON.stringify(messageValue));
            } else if (obj.type === 'pos') {
                console.log('< pos');

                let messageValue = {
                    type: 'pos',
                    parameters: {
                        position_x: matrix.currentx,
                        position_y: matrix.currenty,
                    }
                };

                console.log('> pos Send ' + matrix.currentx + ' - ' + matrix.currenty);
                ws.send(JSON.stringify(messageValue));

                // Update the position value
                matrix.currentx++;
                if (matrix.currentx === matrix.sizex) {
                    matrix.currentx = 0;
                    matrix.currenty++;
                    console.log('pos New line');
                }

                if (matrix.currenty === matrix.sizey) {
                    matrix.currentx = 0;
                    matrix.currenty = 0;
                    console.log('pos Finished');
                }
            } else
            // ##### END HANDLE MATRIX DEMO #####


            // TODO : HANDLE AUTO MODE
            if (obj.type === 'automode') {
                console.log('automode: ' + JSON.stringify(obj) + " from " + show_id_value);

                if (typeof loopMethod[show_id_value] != 'undefined' && loopMethod[show_id_value] != null) {
                    clearTimeout(loopMethod[show_id_value]);
                }

                loopStep[show_id_value] = 0;
                loopSequence[show_id_value] = obj.parameters;

                console.log('automode loopStep: ' + JSON.stringify(loopStep));
                console.log('automode loopSequence: ' + JSON.stringify(loopSequence));

                loopFunction(show_id_value);

                // File persistence
                jsonFile.writeFile(lastAutoModeFileName, loopSequence, function (err) {
                    if (err !== undefined && err != null) {
                        console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                    }
                });
            } else

            // When answer : add a value to the socket : groupValue {type:value}
            if (obj.type === 'user_type') {
                console.log('< user_type');

                if (ws.groupValue === undefined) {
                    ws.groupValue = [];
                }
                if (obj.parameters !== undefined) {

                    if (obj.parameters.id.startsWith('open') || obj.parameters.id.startsWith('wordcloud')) {
                        console.log('OPEN QUESTION');
                        manageStatsOpenQuestions(show_id_value, obj.parameters.id, obj.parameters.value);
                        broadcastToAdmin(show_id_value, JSON.stringify(statsOpenQuestions));
                        ws.groupValue[obj.parameters.id] = "*";
                    } else {
                        // The socket already has the type value, remove the old one
                        // FIX cause in case of reset, the WS has the value, but not the stats !!!
                        // if (ws.groupValue[obj.parameters.id] !== undefined) {
                        //     manageStats(show_id_value, ws.uuid, obj.parameters.id, ws.groupValue[obj.parameters.id], -1);
                        //     console.log('STATS -1 : ' + JSON.stringify(statsUsers));
                        // }
                        // Add the new value
                        manageStats(show_id_value, ws.uuid, obj.parameters.id, obj.parameters.value, +1);
                        console.log('STATS +1 : ' + JSON.stringify(statsUsers));

                        // TODO : format stats
                        // Send the stats
                        broadcastToAdmin(show_id_value, JSON.stringify(statsUsers));

                        ws.groupValue[obj.parameters.id] = obj.parameters.value;
                        // FIXME manageStats(obj.parameters.id, ws.groupValue[obj.parameters.id], 1);
                        // console.log('Send stats 3 : ' +  JSON.stringify(statsUsers));
                        // socket.broadcast.to('admin').emit('stats', statsUsers );
                    }

                    // Automatic reaction to the answers
                    // If value is known in actionDiff, then send it back right now to the client
                    if (typeof actionDiff[obj.parameters.id] != 'undefined' && typeof actionDiff[obj.parameters.id][obj.parameters.value] != 'undefined') {
                        console.log('+++ FOUND AUTO ACTION FOR : ' + obj.parameters.id + " " + obj.parameters.value + "|");
                        console.log('Send AUTO Action Diff answer : ' + JSON.stringify(actionDiff[obj.parameters.id][obj.parameters.value]));
                        ws.send(JSON.stringify(actionDiff[obj.parameters.id][obj.parameters.value]));
                    } else if (typeof actionDiff[obj.parameters.id] != 'undefined' && typeof actionDiff[obj.parameters.id]["*"] != 'undefined') {
                        console.log('+++ FOUND GENERIC AUTO ACTION FOR : ' + obj.parameters.id);
                        console.log('Send AUTO Action Diff answer : ' + JSON.stringify(actionDiff[obj.parameters.id]["*"]));
                        ws.send(JSON.stringify(actionDiff[obj.parameters.id]["*"]));
                    } else {
                        console.log('+++ NO AUTO ACTION FOR : ' + obj.parameters.id + "[" + obj.parameters.value + "]\n" + JSON.stringify(actionDiff));
                    }

                    // USER ADMIN : Handle the special case of admin user.
                    if (obj.parameters.id === 'admin') {
                        if (userAdminList[show_id_value] === undefined) {
                            userAdminList[show_id_value] = {};
                        }
                        userAdminList[show_id_value][ws.id] = ws;

                        // SEND STATS TO ADMIN
                        // FIXME : Send only the stats of the channel
                        ws.send(JSON.stringify(statsUsers));
                        ws.send(JSON.stringify(statsOpenQuestions));

                        let messageValue = {
                            type: 'nb_users',
                            parameters: {
                                value: nbreOfUsersConnected[ws.upgradeReq.url]
                            }
                        };
                        ws.send(JSON.stringify(messageValue));
                    }
                    // END USER ADMIN : Handle the special case of admin user.

                } else {
                    console.log("user_type : parameters is NULL !!!");
                }

                // FIXME : Debug only
                // Display the groupValue values
                //for (let [key, value] of Object.entries(ws.groupValue)) {
                //    console.log(`${key}: ${value}`);
                //}
            } else if (obj.type === 'action_diff') {
                console.log("< action diff");

                obj.parameters.forEach(function (element) {
                    console.log(element.value + " " + element.type + " " + element.parameters);
                    broadcastFiltered(wss, ws, JSON.stringify(element), obj.group, element.value);

                    if (typeof actionDiff[obj.group] == 'undefined') {
                        actionDiff[obj.group] = {};
                    }
                    actionDiff[obj.group][element.value] = element;
                });

                // File persistence
                jsonFile.writeFile(actionDiffFileName, actionDiff, function (err) {
                    if (err !== undefined && err != null) {
                        console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                    }
                });

            } else if (obj.type === 'uuid') {
                // Check undefined values
                if (obj.parameters !== undefined && obj.parameters.uuid !== undefined) {
                    ws.uuid = obj.parameters.uuid;
                    console.log("STORE DB websocket id: " + ws.id + " User UUID = " + ws.uuid);
                } else {
                    console.error("ERROR UUID MESSAGE " + JSON.stringify(obj));
                }
            } else if (obj.type === 'action') {
                broadcast(wss, show_id_value, ws.id, msg);

                // If automode activated, do not write the file
                if (obj.automode === undefined || obj.automode === false) {
                    console.log("Store the action");
                    // Handle the last action recording
                    if (obj.parameters.name === 'VOL') {
                        lastActionSoundLevelLaunchedForShow[show_id_value] = msg;

                        // File persistence
                        jsonFile.writeFile(lastActionSoundLevelLaunchedForShowFileName, lastActionSoundLevelLaunchedForShow, function (err) {
                            if (err !== undefined && err != null) {
                                console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                            }
                        });

                    } else if (obj.parameters.name === 'B') {
                        lastActionBrightnessLaunchedForShow[show_id_value] = msg;

                        // File persistence
                        jsonFile.writeFile(lastActionBrightnessLaunchedForShowFileName, lastActionBrightnessLaunchedForShow, function (err) {
                            if (err !== undefined && err != null) {
                                console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                            }
                        });

                    } else if (obj.parameters.name === 'ORI') {
                        lastActionOrientationLaunchedForShow[show_id_value] = msg;

                        // File persistence
                        jsonFile.writeFile(lastActionOrientationLaunchedForShowFileName, lastActionOrientationLaunchedForShow, function (err) {
                            if (err !== undefined && err != null) {
                                console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                            }
                        });

                    } else if (obj.parameters.name === 'WM') {
                        // If the URL is empty, then remove the item of the list
                        if (obj.parameters.parameters.url === undefined) {
                            console.log('DELETE the WM entry');
                            delete lastActionWatermarkLaunchedForShow[show_id_value];
                        } else {
                            lastActionWatermarkLaunchedForShow[show_id_value] = msg;
                        }

                        // File persistence
                        jsonFile.writeFile(lastActionWatermarkLaunchedForShowFileName, lastActionWatermarkLaunchedForShow, function (err) {
                            if (err !== undefined && err != null) {
                                console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                            }
                        });

                    } else if (obj.parameters.name === 'EXIT') {
                        // DO NOT STORE THIS ACTION !
                    } else {
                        lastActionLaunchedForShow[show_id_value] = msg;

                        // FIXME : Do not write file each time, but maybe each XX times
                        // File persistence
                        jsonFile.writeFile(lastActionLaunchedForShowFileName, lastActionLaunchedForShow, function (err) {
                            if (err !== undefined && err != null) {
                                console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                            }
                        });

                    }
                }
            } else if (obj.type === 'question') {
                broadcast(wss, show_id_value, ws.id, msg);

                // If it's a sticky question, then record it.
                // But do not record it as last action done.
                if (typeof obj.parameters != 'undefined' && typeof obj.parameters.isSticky != 'undefined' && obj.parameters.isSticky == true) {
                    console.log('STICKY QUESTION FOUND');

                    if (typeof obj.parameters.id == 'undefined') {
                        console.log('STICKY REMOVE');
                        delete lastActionStickyQuestionForShow[show_id_value];
                    } else {
                        console.log('STICKY ADD');
                        lastActionStickyQuestionForShow[show_id_value] = msg;
                    }

                    // File persistence
                    jsonFile.writeFile(lastActionStickyQuestionForShowFileName, lastActionStickyQuestionForShow, function (err) {
                        if (err !== undefined && err != null) {
                            console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                        }
                    });
                } else {
                    lastActionLaunchedForShow[show_id_value] = msg;
                }

                // FIXME : Do not write file each time, but maybe each XX times
                // File persistence
                jsonFile.writeFile(lastActionLaunchedForShowFileName, lastActionLaunchedForShow, function (err) {
                    if (err !== undefined && err != null) {
                        console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                    }
                });

                // Reset stats for the question
                console.log('clean statsUsers[' + show_id_value + '][' + obj.parameters.id + ']');
                console.log(JSON.stringify(statsUsers));
                if (typeof statsUsers[show_id_value] != 'undefined' && typeof statsUsers[show_id_value][obj.parameters.id] != 'undefined') {
                    delete statsUsers[show_id_value][obj.parameters.id];
                }
                console.log(JSON.stringify(statsUsers));
                if (typeof statsUsersAlreadyRecorded[show_id_value] != 'undefined' && typeof statsUsersAlreadyRecorded[show_id_value][obj.parameters.id] != 'undefined') {
                    delete statsUsersAlreadyRecorded[show_id_value][obj.parameters.id];
                }
            }

            // ####### RESET PART
            else if (obj.type === 'reset_stats') {
                console.log('Resetting STATS');
                // FIXME : reset for chan only
                statsUsers = {};
                statsUsersAlreadyRecorded = {};
                statsOpenQuestions = {};
                console.log("export " + JSON.stringify(statsUsersAlreadyRecorded));

                // SEND STATS TO ADMIN
                broadcastToAdmin(show_id_value, JSON.stringify(statsUsers));
                broadcastToAdmin(show_id_value, JSON.stringify(statsOpenQuestions));

                console.log('DONE');
            } else if (obj.type === 'reset_action_diff') {
                console.log('reset_action_diff');
                try {
                    fs.unlinkSync(actionDiffFileName)
                } catch (err) {
                    console.error(err)
                }
                actionDiff = {};
            } else if (obj.type === 'export_stats') {
                console.log('export_stats');

                let stats = {"statsUsers": statsUsers, "statsOpenQuestions": statsOpenQuestions};

                request.post(
                    'http://tristan-salaun.com/l4e/stats.php',
                    {form: {result: stats}}
                );
                console.log('POSTED');
            } else if (obj.type === 'display_questions') {
                console.log('display_questions');
                broadcastToAdmin(show_id_value, JSON.stringify(obj));
            } else if (obj.type === 'device_infos') {
                console.log('STORE DB device_infos ' + JSON.stringify(obj));
                // FIXME : store the stats
            } else if (obj.type === 'ping') {
                console.log('ping');

                // Check the parameters to avoid crash
                if (obj.parameters !== undefined && obj.parameters.client !== undefined) {

                    let currentDate = new Date();
                    let messageValue = {
                        type: 'pong',
                        server: currentDate.getTime(),
                        client: obj.parameters.client
                    };

                    ws.send(JSON.stringify(messageValue));
                } else {
                    console.error("PING message badly formated : " + JSON.stringify(obj));
                }

            } else if (obj.type === 'start_delay') {
                console.log('start_delay');

                let currentDate = new Date();
                let timeToLaunch = new Date(currentDate.getTime() + obj.parameters.delay * 1000);

                let actionParameters = {
                    server: currentDate.getTime(),
                    timeToLaunch: timeToLaunch.getTime(),
                    id: obj.parameters.sequence_id
                }
                let parameters = {
                    name: "SEQ_START",
                    parameters: actionParameters
                }
                let msg = {
                    type: 'action',
                    parameters: parameters
                };

                broadcast(wss, show_id_value, ws.id, JSON.stringify(msg));

                lastActionLaunchedForShow[show_id_value] = JSON.stringify(msg);

                // FIXME : Do not write file each time, but maybe each XX times
                // File persistence
                jsonFile.writeFile(lastActionLaunchedForShowFileName, lastActionLaunchedForShow, function (err) {
                    if (err !== undefined && err != null) {
                        console.error(err.stack || err); // e.stack || e to handle old (<6) and new version of Node.JS
                    }
                });
            }

            // SEND TO SOCKET IO SERVER
            let show_id_value_socket_io = show_id_value;
            if (show_id_value.startsWith('/')) {
                show_id_value_socket_io = show_id_value.substring(1);
            }

            try {
                console.log("SOCKET IO : Type " + obj.type);

                if (obj.type === 'action') {
                    console.log("SOCKET IO : Action " + JSON.stringify(obj.parameters));

                    if (obj.parameters.name === 'FC') {

                        let color = obj.parameters.parameters.color;
                        if (color.length === 9) {
                            color = "#" + color.substring(3);
                        }
                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: color
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'IMG') {

                        const urlValue = obj.parameters.parameters.url;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: urlValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'AC' || obj.parameters.name === 'ABGC') {

                        const fading = obj.parameters.parameters.fading;
                        const isRandomColor = obj.parameters.parameters.is_random_colors;
                        const isRandomTime = obj.parameters.parameters.is_random_time;
                        // Check if available
                        const colorsList = obj.parameters.parameters.colors;

                        let valueValue = "";
                        if (isRandomTime === "Y") {

                            const minTimeOff = obj.parameters.parameters.min_time_off;
                            const maxTimeOff = obj.parameters.parameters.max_time_off;
                            const minTimeOn = obj.parameters.parameters.min_time_on;
                            const maxTimeOn = obj.parameters.parameters.max_time_on;

                            valueValue = fading + "," + isRandomColor + "," + isRandomTime + "-" + minTimeOff + "-" + maxTimeOff + "-" + minTimeOn + "-" + maxTimeOn;
                        } else {
                            const timeOff = obj.parameters.parameters.time_off;
                            const timeOn = obj.parameters.parameters.time_on;
                            valueValue = fading + "," + isRandomColor + "," + isRandomTime + "-" + timeOff + "-" + timeOn;
                        }
                        if (colorsList !== undefined) {
                            valueValue = valueValue + "," + colorsList.join();
                        }

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: 'AC',
                            value: valueValue,
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'B') {

                        const brightnessValue = obj.parameters.parameters.brightness;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: brightnessValue.toString()
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'BGC') {

                        let color = obj.parameters.parameters.color;
                        if (color.length === 9) {
                            color = "#" + color.substring(3);
                        }
                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: color
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'EXIT') {

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: ""
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'FLASH') {

                        const timeOffValue = obj.parameters.parameters.time_off;
                        const timeOnValue = obj.parameters.parameters.time_on;
                        const repeatValue = obj.parameters.parameters.repeat;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: timeOffValue + "," + timeOnValue + "," + repeatValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'HTML') {

                        const contentValue = obj.parameters.parameters.content;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: contentValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'ORI') {

                        const orientationValue = obj.parameters.parameters.orientation;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: orientationValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'PLAYSOUND') {

                        var urlValue = obj.parameters.parameters.url;

                        var action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: urlValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'TEXT') {

                        const contentValue = obj.parameters.parameters.text;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: contentValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'URL') {

                        const contentValue = obj.parameters.parameters.url;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: contentValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'VIB') {

                        const patternValue = obj.parameters.parameters.pattern;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: patternValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'VOL') {

                        const volumeValue = obj.parameters.parameters.volume;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: volumeValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    } else if (obj.parameters.name === 'WM') {

                        const urlValue = obj.parameters.parameters.url;

                        const action = {
                            show_id: show_id_value_socket_io,
                            action: obj.parameters.name,
                            value: urlValue
                        };
                        if (socketIO_socket !== undefined) {
                            socketIO_socket.emit('action', action);
                        }

                    }
                } // END if(obj.type == 'action')
                else if (obj.type === 'question') {

                    const idValue = obj.parameters.id;
                    const titleValue = obj.parameters.title;
                    const optionsValue = obj.parameters.options;
                    const isAutoAnswerModeValue = obj.parameters.isAutoAnswerMode;
                    const isRandomModeValue = obj.parameters.isRandomMode;
                    const typeValue = obj.parameters.type;
                    const isStickyValue = obj.parameters.isSticky;

                    const questionRequest = {
                        show_id: show_id_value_socket_io,
                        id: idValue,
                        title: titleValue,
                        options: optionsValue,
                        isAutoAnswerMode: isAutoAnswerModeValue,
                        isRandomMode: isRandomModeValue,
                        type: typeValue
                    };
                    if (socketIO_socket !== undefined) {
                        socketIO_socket.emit('question', questionRequest);
                    }
                } else if (obj.type === 'action_diff') {

                    console.log("SOCKET IO : action_diff : " + JSON.stringify(obj));

                    const idValue = obj.group;
                    const actionsValue = obj.parameters;

                    console.log("SOCKET IO : action_diff : idValue = " + JSON.stringify(idValue));
                    console.log("SOCKET IO : action_diff : actionsValue = " + JSON.stringify(actionsValue));

                    // Loop to change the message format
                    // From : {value: 'r', type: 'action', parameters: actionDiffR}
                    // To : {value: 'r', command: 'action', valueCommand: actionDiff1}
                    let newFormat = [];

                    for (let actionValue of actionsValue) {
                        console.log("SOCKET IO : action_diff : actionValue = " + JSON.stringify(actionValue));

                        // Handle other action types.
                        // AAAA Handle HTML
                        if (actionValue.parameters !== undefined && actionValue.parameters.parameters !== undefined && actionValue.parameters.parameters.color !== undefined) {
                            let color = actionValue.parameters.parameters.color;
                            if (color.length === 9) {
                                color = "#" + color.substring(3);
                            }
                            const action = {
                                action: "FC",
                                value: color
                            };

                            newFormat.push({value: actionValue.value, command: actionValue.type, valueCommand: action})
                        }
                        else if (actionValue.parameters !== undefined && actionValue.parameters.name !== undefined && actionValue.parameters.name === 'HTML') {

                            const contentValue = actionValue.parameters.parameters.content;

                            const action = {
                                show_id: show_id_value_socket_io,
                                action: actionValue.parameters.name,
                                value: contentValue
                            };
                            if (socketIO_socket !== undefined) {
                                socketIO_socket.emit('action', action);
                            }

                        }
                        else if (actionValue.type !== undefined && actionValue.type == "question") {

                            const convertidValue = actionValue.parameters.id;
                            const converttitleValue = actionValue.parameters.title;
                            let convertoptionsValue = actionValue.parameters.options;
                            const convertisAutoAnswerModeValue = actionValue.parameters.isAutoAnswerMode;
                            const convertisRandomModeValue = actionValue.parameters.isRandomMode;
                            const converttypeValue = actionValue.parameters.type;
                            // const convertisStickyValue = actionValue.parameters.parameters.isSticky;

                            if (convertoptionsValue === undefined) {
                                convertoptionsValue = []
                            }

                            const questionRequest = {
                                show_id: show_id_value_socket_io,
                                id: convertidValue,
                                title: converttitleValue,
                                options: convertoptionsValue,
                                isAutoAnswerMode: convertisAutoAnswerModeValue,
                                isRandomMode: convertisRandomModeValue,
                                type: converttypeValue
                            };
                            newFormat.push({value: idValue, command: actionValue.type, valueCommand: questionRequest})
                        }
                    }

                    const questionRequest = {
                        show_id: show_id_value_socket_io,
                        actionDiff: newFormat,
                    };
                    console.log("SOCKET IO : action_diff => " + JSON.stringify(newFormat));
                    if (socketIO_socket !== undefined) {
                        socketIO_socket.emit('action_diff', questionRequest);
                    }

                } else if (obj.type === 'reset_stats') {
                    socketIO_socket.emit('reset_stats', '');
                }
                // TODO : HANDLE bulk, ....
            } catch (error) {
                console.error(error.stack || error); // e.stack || e to handle old (<6) and new version of Node.JS
            }

            // END BRIDGE

        } catch (e) {
            console.log("< ERROR IN MESSAGE $msg " + e);
            console.error(e.stack || e); // e.stack || e to handle old (<6) and new version of Node.JS
            return;
        }
    }); // WS on message


    ws.on("close", function () {
        console.log("websocket connection close " + ws.uuid);

        // Handle static on connected users
        if (typeof [ws.upgradeReq.url] != 'undefined') {
            nbreOfUsersConnected[ws.upgradeReq.url] = nbreOfUsersConnected[ws.upgradeReq.url] - 1;
            if (nbreOfUsersConnected[ws.upgradeReq.url] <= 0) {
                delete nbreOfUsersConnected[ws.upgradeReq.url];
            }
            sendConnexionsStats(ws);
        }

        // DEBUG : log
        //for (let [key, value] of Object.entries(nbreOfUsersConnected)) {
        //	console.log(`${key}: ${value}`);
        //}

        // USER ADMIN : Handle the special case of admin user : remove it from the admin list
        console.log('Handle admin disconnect' + ws.upgradeReq.url);
        if (ws.groupValue !== undefined && ws.groupValue['admin'] !== undefined) {
            console.log('Current user is admin');
            if (userAdminList[ws.upgradeReq.url] !== undefined && userAdminList[ws.upgradeReq.url][ws.id] !== undefined) {
                delete userAdminList[ws.upgradeReq.url][ws.id];
                console.log('Deleted ' + ws.id);
            } else {
                console.log('ERROR deleting the admin ws');
            }

            // if the list of admin is empty, remove the entry
            if (Object.keys(userAdminList[ws.upgradeReq.url]).length === 0) {
                delete userAdminList[ws.upgradeReq.url];
                console.log('no more admin for ' + ws.upgradeReq.url);
            } else {
                //console.log('Admin list is not empty for ' + ws.upgradeReq.url + ' ' + Object.keys(userAdminList[ws.upgradeReq.url]).length );

                //for (let [key, value] of Object.entries(userAdminList[ws.upgradeReq.url])) {
                //	console.log(`${key}: ${value}`);
                //}
            }
        }

    });
});


setInterval(function ping() {
    let socketsCount = 0;
    let socketsClosedCount = 0;
    wss.clients.forEach(function each(ws) {
        socketsCount++;
        if (ws.isAlive === false) {
            socketsClosedCount++;
            return ws.terminate();
        }

        ws.isAlive = false;
        ws.ping(noop);
    });

    // Display the message only if something changed
    if (socketsClosedCount !== 0) {
        console.log("socketsCount " + socketsCount);
        console.log("socketsClosedCount " + socketsClosedCount);
    }
}, 30000);


//AUTOMATIC MODE
console.log("AUTO Start");
const WebSocket = require('ws');
const demo_serverUrl = 'ws://127.0.0.1:' + port;
let isAutoModeConnected = false;

console.log("AUTO Try to connect to " + demo_serverUrl);

automode_socket = new WebSocket(demo_serverUrl);


automode_socket.on('open', function open() {
    console.log("AUTO socket connected");
    isAutoModeConnected = true;
});


function loopFunction(current_show_id) {

    if (current_show_id === undefined) {
        console.error('loopFunction current_show_id is undefined');
    }
    //console.log("loopFunction current_show_id=" + current_show_id);
    //console.log("loopFunction loopSequence[current_show_id]=" + JSON.stringify(loopSequence[current_show_id]));
    //console.log("loopFunction loopSequence[current_show_id].loop=" + loopSequence[current_show_id].loop);
    //console.log("loopFunction loopSequence[current_show_id].timedActionList=" + JSON.stringify(loopSequence[current_show_id].timedActionList));
    //console.log("loopFunction loopStep[current_show_id]=" + loopStep[current_show_id]);
    //console.log("loopFunction loopSequence[current_show_id].timedActionList[loopStep[current_show_id]]=" + JSON.stringify(loopSequence[current_show_id].timedActionList[loopStep[current_show_id]]));
    //console.log("loopFunction loopSequence[current_show_id].timedActionList[loopStep[current_show_id]].delay)=" + loopSequence[current_show_id].timedActionList[loopStep[current_show_id]].delay);

    if (loopSequence[current_show_id] === undefined) {
        console.error("loopFunction NO loopSequence available for current_show_id=" + current_show_id);
        console.log("loopFunction loopSequence[current_show_id]=" + JSON.stringify(loopSequence[current_show_id]));
        return;
    }

    loopMethod[current_show_id] = setTimeout(function () {

        // If loop has not been reseted
        if (typeof loopSequence[current_show_id] != 'undefined' && loopSequence[current_show_id] != null) {
            // console.log('automode current_show_id : ' + current_show_id);
            // console.log('automode loopStep : ' + loopStep[current_show_id]);
            // console.log('automode loopSequence : ' +  JSON.stringify(loopSequence[current_show_id]));
            // console.log('automode action : ' + JSON.stringify(loopSequence[current_show_id].timedActionList[loopStep[current_show_id]]));

            // Add the needed values
            loopSequence[current_show_id].timedActionList[loopStep[current_show_id]].show_id = current_show_id;
            loopSequence[current_show_id].timedActionList[loopStep[current_show_id]].automode = true;

            if (isAutoModeConnected) {
                console.log('automode emit : ' + loopSequence[current_show_id].timedActionList[loopStep[current_show_id]].type + " => " + JSON.stringify(loopSequence[current_show_id].timedActionList[loopStep[current_show_id]].parameters));
                try {
                    automode_socket.send(JSON.stringify(loopSequence[current_show_id].timedActionList[loopStep[current_show_id]]));
                } catch (e) {
                    console.log('AUTOMODE ERROR sending message');
                }
            } else {
                console.log('automode NOT CONNECTED');
            }

            // If it's the end of loop
            // console.log("Is end of loop ?");
            // console.log(loopStep[current_show_id] + " >= " + ((loopSequence[current_show_id].timedActionList.length) - 1));
            if (loopStep[current_show_id] >= loopSequence[current_show_id].timedActionList.length - 1) {
                // console.log("End of loop");
                // console.log("Test 1 " + (typeof loopSequence[current_show_id].loop !== 'undefined') );
                // console.log("Test 2 " + (loopSequence[current_show_id].loop != null) );
                // console.log("Test 3 " + loopSequence[current_show_id].loop);

                if (typeof loopSequence[current_show_id].loop != 'undefined' && loopSequence[current_show_id].loop != null && loopSequence[current_show_id].loop) {
                    console.log("Auto loop activated");
                    loopFunction(current_show_id);
                    loopStep[current_show_id] = 0;
                }
            } else { // Not end of loop, then loop
                loopFunction(current_show_id);
                loopStep[current_show_id]++;
                loopStep[current_show_id] = loopStep[current_show_id] % loopSequence[current_show_id].timedActionList.length;
                // console.log("Looping : " + loopStep[current_show_id]);
            }
        }

    }, loopSequence[current_show_id].timedActionList[loopStep[current_show_id]].delay);
}
