package fr.mondomaine.android.monappli.ex13;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.content.Intent;
import android.text.format.Time;
import android.widget.RemoteViews;
import android.widget.Toast;
import fr.mondomaine.android.monappli.MonActivitePrincipale;
import fr.mondomaine.android.monappli.R;

public class MonAppWidget extends AppWidgetProvider {
  @Override
  public void onEnabled(Context context) {
    super.onEnabled(context);
    Toast.makeText(context, "onEnabled", Toast.LENGTH_SHORT)
      .show();
  }

  @Override
  public void onDisabled(Context context) {
    super.onDisabled(context);
    Toast.makeText(context, "onDisabled", Toast.LENGTH_SHORT)
      .show();
  }

  @Override
  public void onUpdate(Context context, AppWidgetManager appWidgetManager,
    int[] appWidgetIds) {
    super.onUpdate(context, appWidgetManager, appWidgetIds);
    Toast.makeText(
                   context,
                   context.getString(R.string.ex13_appwidget_maj,
                                     appWidgetIds.length), Toast.LENGTH_SHORT)
      .show();

    for (final int appWidgetId : appWidgetIds)
      Toast.makeText(context, "AppWidget Id= " + appWidgetId,
                     Toast.LENGTH_SHORT)
        .show();
    final Time t = new Time();
    t.setToNow();
    final RemoteViews views =
      new RemoteViews(context.getPackageName(), R.layout.ex13_appwidget);
    views.setTextViewText(
                          R.id.appwidget_titre,
                          t.format(context.getString(R.string.ex13_appwidget_format_heure)));

    final Intent intent = new Intent(context, MonActivitePrincipale.class);
    final PendingIntent pIntent =
      PendingIntent.getActivity(context, 0, intent, 0);
    views.setOnClickPendingIntent(R.id.appwidget_img, pIntent);

    appWidgetManager.updateAppWidget(appWidgetIds, views);
  }

  @Override
  public void onDeleted(Context context, int[] appWidgetIds) {
    super.onDeleted(context, appWidgetIds);
    Toast.makeText(context, "onDeleted", Toast.LENGTH_SHORT)
      .show();
  }

}
