package fr.mondomaine.android.monappli.ex13;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings.Secure;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

import com.google.android.vending.licensing.AESObfuscator;
import com.google.android.vending.licensing.LicenseChecker;
import com.google.android.vending.licensing.LicenseCheckerCallback;
import com.google.android.vending.licensing.ServerManagedPolicy;

import fr.mondomaine.android.monappli.R;

public class LicenceActivite extends Activity {
  // Remplacez la cl par celle de votre compte diteur AndroidMarket
  private static final String CLE_PUBLIQUE_BASE64 =
    "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAmX/oXOP4MVdLpMk407Ks8fuoTnyk7Ym/jkiQEj2QCg9qyhFE7yWwOkFOu5JloWwfXP3Jk5juWmpi2ksxeJCBBTYLXORGShfqzh4j2SvGTj+LslBBtY5igieipF8yatx/BXFIyML39oUbIeVwQs9UpS3P/5VRyfA2D2WCKl6nF66XWgnN6mXbGePByDhrrStYGVtmhrHMZB39oYuuS/n411/+9iN1wr/1zpeqGhbQUregrfOMKZN4wik52BaEjxGkNcWaaPxiIZLKjV2cI7z2DuCXZ1bjeMcRaAh58EPVvcnF5OiG7sEaYmVeDsa6J/VgNaotv7iBcy2Wo1Ye/hRS9QIDAQAB";

  // Remplacez les octets suivants par ceux de votre choix
  private static final byte[] SALT =
    new byte[] { -42, 13, -37, 5, 86, 45, -123, 102, -15, -3, 123, 5, 42, -115,
      2, 110, 25, 53, 5, -128 };

  private TextView mStatutTextView;
  private Button mBouton;

  private ResultatsLicence mLicenceResultats;
  private LicenseChecker mLicVerificateur;
  private Handler mHandler;

  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
    setContentView(R.layout.ex13_licence);
    setProgressBarIndeterminateVisibility(false);

    mHandler = new Handler();
    mStatutTextView = (TextView) findViewById(R.id.ex13_statut_licence);
    mBouton = (Button) findViewById(R.id.ex13_bouton_verif_licence);

    final String deviceId =
      Secure.getString(getContentResolver(), Secure.ANDROID_ID);
    final AESObfuscator obf =
      new AESObfuscator(SALT, getPackageName(), deviceId);
    final ServerManagedPolicy politique = new ServerManagedPolicy(this, obf);
    mLicVerificateur = new LicenseChecker(this, politique, CLE_PUBLIQUE_BASE64);

    mLicenceResultats = new ResultatsLicence();
  }

  // A partir de Android 2.2, il faut implmenter  la place la mthode
  // protected Dialog onCreateDdialogd(int id, Bundle args)
  @Override
  protected Dialog onCreateDialog(int id) {
    return new AlertDialog.Builder(this).setTitle(R.string.ex13_dialogue_titre)
      .setMessage(R.string.ex13_dialogue_message)
      .setPositiveButton(R.string.ex13_dialogue_acheter,
                         new DialogInterface.OnClickListener() {
                           public void onClick(DialogInterface dialog, int which) {
                             final Intent marketIntent =
                               new Intent(
                                 Intent.ACTION_VIEW,
                                 Uri.parse("http://market.android.com/details?id="
                                   + getPackageName()));
                             startActivity(marketIntent);
                           }
                         })
      .setNegativeButton(R.string.ex13_dialogue_quitter,
                         new DialogInterface.OnClickListener() {
                           public void onClick(DialogInterface dialog, int which) {
                             finish();
                           }
                         })
      .create();
  }

  public void onButtonVerification(View v) {
    setProgressBarIndeterminateVisibility(true);
    mBouton.setEnabled(false);
    mStatutTextView.setText(R.string.ex13_statut_licence_cours);
    mLicVerificateur.checkAccess(mLicenceResultats);
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();
    mLicVerificateur.onDestroy();
  }

  private void afficheStatut(final String message) {
    mHandler.post(new Runnable() {
      public void run() {
        setProgressBarIndeterminateVisibility(false);
        mStatutTextView.setText(message);
        mBouton.setEnabled(true);
      }
    });
  }

  private class ResultatsLicence implements LicenseCheckerCallback {
    @Override
    public void allow(int reason) {
      if (isFinishing())
        return;
      afficheStatut(getString(R.string.ex13_statut_licence_ok));
    }

    @Override
    public void applicationError(int errorCode) {
      if (isFinishing())
        return;
      final String msg =
        String.format(getString(R.string.ex13_erreur_appli), errorCode);
      afficheStatut(msg);
    }

    @Override
    public void dontAllow(int reason) {
      if (isFinishing())
        return;
      afficheStatut(getString(R.string.ex13_statut_licence_ko));
      showDialog(0);
    }
  }

}
