package fr.mondomaine.android.monappli.ex12;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.os.Bundle;
import android.provider.Settings;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class DecouverteNFCActivite extends Activity{

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.ex12_principale_nfc);
		Button lireTag = (Button)findViewById(R.id.ex12_lire_tag);
		lireTag.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				startActivity(new Intent(DecouverteNFCActivite.this,LireNFCActivite.class));
			}
		});
		Button ecrireTag = (Button)findViewById(R.id.ex12_ecrire_tag);
		ecrireTag.setOnClickListener(new OnClickListener() {
			
			@Override
			public void onClick(View v) {
				startActivity(new Intent(DecouverteNFCActivite.this,EcrireNFCActivity.class));
			}
		});
	}
	
	@Override
	public void onResume() {
		super.onResume();
		hasNFC();
	}
	@SuppressLint({ "InlinedApi", "NewApi" })
	private void hasNFC() {
		NfcAdapter nfcAdapter= NfcAdapter.getDefaultAdapter(getApplicationContext());
		if(nfcAdapter ==null) {
			Toast.makeText(this, "Technologie NFC non disponible", Toast.LENGTH_SHORT).show();
			return;
		}
		Toast.makeText(this, "Bienvenue dans le monde du NFC", Toast.LENGTH_SHORT).show();
		if(!nfcAdapter.isEnabled()) {
			Intent intent;
			 if (android.os.Build.VERSION.SDK_INT >= 10) 
			       intent = new Intent("android.settings.NFC_SETTINGS");
			     else 
			        intent = new Intent(Settings.ACTION_WIRELESS_SETTINGS);
		        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		        this.startActivity(intent);

		}
		
	}
	
}
