package fr.mondomaine.android.monappli.ex11;

import android.app.Activity;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.ToggleButton;
import fr.mondomaine.android.monappli.R;

public class GeolocActivite extends Activity {

  private LocationManager mLocManageur;
  private ToggleButton mBoutonMajRegulieres;
  private EditText mInfos;
  private Criteria mCriteres;

  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex11_geoloc);

    // Voir le chapitre 'Publier une application' pour les features
    // FEATURE_LOCATION n'est disponible qu' partir d'Android 2.2.
    // On consid?re donc par dfaut qu'un dispositif de localisation est
    // prsent.
    // final boolean locPresent =
    // getPackageManager().hasSystemFeature(PackageManager.FEATURE_LOCATION);
    // if (locPresent == false) {
    // Toast.makeText(this, getString(R.string.ex09_geoloc_pas_de_materiel),
    // Toast.LENGTH_LONG);
    // finish();
    // return;
    // }

    mBoutonMajRegulieres =
      (ToggleButton) findViewById(R.id.ex11_geoloc_maj_regulieres);
    mInfos = (EditText) findViewById(R.id.ex11_geoloc_textview);
    mLocManageur = (LocationManager) getSystemService(Context.LOCATION_SERVICE);

    mCriteres = new Criteria();
    mCriteres.setAccuracy(Criteria.ACCURACY_COARSE);
  }

  public void onClickButtonCache(View v) {
    final LocationManager locManager =
      (LocationManager) getSystemService(Context.LOCATION_SERVICE);
    Location loc =
      locManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
    afficheLocalisation(R.string.ex11_geoloc_cache_reseau, loc);
    loc = locManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
    afficheLocalisation(R.string.ex11_geoloc_cache_gps, loc);
    // PASSIVE_PROVIDER n'est disponible qu' partir d'Android 2.2
    // loc = locManager.getLastKnownLocation(LocationManager.PASSIVE_PROVIDER);
    // afficheLocalisation(R.string.ex09_geoloc_cache_passif, loc);
  }

  public void onClickButtonMajRegulieres(View v) {
    if (mBoutonMajRegulieres.isChecked())
      try {
        final String provider = mLocManageur.getBestProvider(mCriteres, true);
        mLocManageur.requestLocationUpdates(provider, 0, 0.f, mLocListener);
      } catch (final IllegalArgumentException e) {
        affiche(e.getMessage());
        mBoutonMajRegulieres.setChecked(false);
      }
    else
      mLocManageur.removeUpdates(mLocListener);
  }

  LocationListener mLocListener = new LocationListener() {
    public void onLocationChanged(Location location) {
      afficheLocalisation(R.string.ex11_geoloc_maj_regulieres, location);
    }

    public void onProviderDisabled(String provider) {
      affiche(String.format(getString(R.string.ex11_geoloc_dispositif_off),
                            provider));
    }

    public void onProviderEnabled(String provider) {
      affiche(String.format(getString(R.string.ex11_geoloc_dispositif_on),
                            provider));
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
      String statusTxt = null;
      switch (status) {
      case LocationProvider.AVAILABLE:
        statusTxt = getString(R.string.ex11_geoloc_status_on);
        final Integer nb = (Integer) extras.get("satellites");
        if (nb != null)
          statusTxt +=
            String.format(getString(R.string.ex11_geoloc_status_satellites), nb);
        break;
      case LocationProvider.OUT_OF_SERVICE:
        statusTxt = getString(R.string.ex11_geoloc_status_off);
        break;
      case LocationProvider.TEMPORARILY_UNAVAILABLE:
        statusTxt = getString(R.string.ex11_geoloc_status_ko);
        break;
      default:
        break;
      }
      final String txt =
        String.format(getString(R.string.ex11_geoloc_status_changed), provider,
                      status);
      affiche(txt);
    }
  };

  @Override
  protected void onResume() {
    super.onResume();
    if (mBoutonMajRegulieres.isChecked())
      onClickButtonMajRegulieres(null);
  }

  @Override
  protected void onPause() {
    super.onPause();
    mLocManageur.removeUpdates(mLocListener);
  }

  private void afficheLocalisation(int idInfos, Location loc) {
    final String txt =
      String.format(getString(R.string.ex11_geoloc_loc), getString(idInfos),
                    loc);
    affiche(txt);
  }

  private void affiche(String texte) {
    mInfos.append("\n" + texte);
    mInfos.setSelection(mInfos.getText()
      .length());
  }

}