package fr.mondomaine.android.monappli.ex11;

import android.os.Bundle;
import android.view.Window;
import android.widget.Toast;

import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;

import fr.mondomaine.android.monappli.R;

public class CarteActivite extends MapActivity {

  private MyLocationOverlay mLocUtilisateur;

  @Override
  protected void onCreate(Bundle icicle) {
    super.onCreate(icicle);
    requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
    setContentView(R.layout.ex11_carte);

    final MapView carte = (MapView) findViewById(R.id.ex11_mapview);
    carte.setBuiltInZoomControls(true);
    carte.setSatellite(true);

    // Voir le chapitre 'Publier une application' pour les features
    // FEATURE_LOCATION n'est disponible qu' partir d'Android 2.2.
    // On consid?re donc par dfaut qu'un dispositif de localisation est
    // prsent.
    final boolean locPresent = true;
    // getPackageManager().hasSystemFeature(PackageManager.FEATURE_LOCATION);
    if (locPresent) {
      Toast.makeText(this, getString(R.string.ex11_carte_localisation),
                     Toast.LENGTH_LONG)
        .show();
      setProgressBarIndeterminateVisibility(true);
      mLocUtilisateur = new MyLocationOverlay(this, carte);
      carte.getOverlays()
        .add(mLocUtilisateur);

      mLocUtilisateur.runOnFirstFix(new Runnable() {
        public void run() {
          runOnUiThread(new Runnable() {
            @Override
            public void run() {
              setProgressBarIndeterminateVisibility(false);
            }
          });
          final MapController controleur = carte.getController();
          controleur.animateTo(mLocUtilisateur.getMyLocation());
          controleur.setZoom(15);
        }
      });
    }
  }

  @Override
  protected void onResume() {
    super.onResume();
    if (mLocUtilisateur != null) {
      mLocUtilisateur.enableMyLocation();
      mLocUtilisateur.enableCompass();
    }
  }

  @Override
  protected void onPause() {
    super.onPause();
    if (mLocUtilisateur != null) {
      mLocUtilisateur.disableMyLocation();
      mLocUtilisateur.disableCompass();
    }
  }

  @Override
  protected boolean isRouteDisplayed() {
    return false;
  }

}