package fr.mondomaine.android.monappli.ex07;

import java.math.BigInteger;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.Window;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class ThreadActivite extends Activity {

  private static final int MSG_DEBUT = 1;
  private static final int MSG_FIN = 2;
  private static final int DELAI_MILLIS = 5000;

  private NombresPremiersTache mTache;

  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
    setContentView(R.layout.ex07_thread);

    mTache = new NombresPremiersTache();
  }

  private final Handler mHandler = new Handler() {
    @Override
    public void handleMessage(android.os.Message msg) {
      switch (msg.what) {
      case MSG_DEBUT:
        setProgressBarIndeterminateVisibility(true);
        Toast.makeText(ThreadActivite.this,
                       getString(R.string.ex07_calcul_lance),
                       Toast.LENGTH_SHORT)
          .show();
        break;
      case MSG_FIN:
        setProgressBarIndeterminateVisibility(false);
        Toast.makeText(ThreadActivite.this,
                       getString(R.string.ex07_calcul_resultats, msg.arg1),
                       Toast.LENGTH_SHORT)
          .show();
        break;
      default:
        break;
      }
    };
  };

  final Runnable mInfo = new Runnable() {
    @Override
    public void run() {
      Toast.makeText(ThreadActivite.this,
                     getString(R.string.ex07_thread_5secondes),
                     Toast.LENGTH_SHORT)
        .show();
      mHandler.postDelayed(mInfo, DELAI_MILLIS);
    }
  };

  @Override
  protected void onResume() {
    super.onResume();
    mTache.start();
    mHandler.postDelayed(mInfo, DELAI_MILLIS);
  }

  @Override
  protected void onPause() {
    super.onPause();
    mTache.cancel();
    mHandler.removeCallbacks(mInfo);
  }

  private class NombresPremiersTache extends Thread {

    @Override
    public void run() {
      mHandler.sendEmptyMessage(MSG_DEBUT);

      int n = 0;
      BigInteger nb = BigInteger.ONE;
      while (!isInterrupted()) {
        nb = nb.nextProbablePrime();
        n++;
      }

      final Message msg = mHandler.obtainMessage(MSG_FIN, n, 0);
      mHandler.sendMessage(msg);
    }

    public void cancel() {
      interrupt();
      affiche(getString(R.string.ex07_thread_stop));
    }

    private void affiche(final String message) {
      runOnUiThread(new Runnable() {
        @Override
        public void run() {
          Toast.makeText(ThreadActivite.this, message, Toast.LENGTH_SHORT)
            .show();
        }
      });
    }
  }
}