package fr.mondomaine.android.monappli.ex07;

import android.app.Activity;
import android.os.AsyncTask;
import android.os.Bundle;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class AsyncTaskActivite extends Activity {

  private NombresPremiersTache mTache;

  private ProgressBar mPb;
  private TextView mProgession;

  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex07_asynctask);

    mPb = (ProgressBar) findViewById(R.id.ex07_progressbar);
    mProgession = (TextView) findViewById(R.id.ex07_progress);
  }

  @Override
  protected void onResume() {
    super.onResume();
    mTache = new NombresPremiersTache();
    mTache.execute(0, 10000000);
  }

  @Override
  protected void onPause() {
    super.onPause();
    mTache.cancel(true);
  }

  private class NombresPremiersTache extends
    AsyncTask<Integer, Integer, Integer> {

    @Override
    protected void onPreExecute() {
      super.onPreExecute();
      Toast.makeText(AsyncTaskActivite.this, R.string.ex07_calcul_lance,
                     Toast.LENGTH_SHORT)
        .show();
    }

    @Override
    protected Integer doInBackground(Integer... arg0) {
      int n = 0;
      int niveau = 0;
      final int step = (arg0[1] - arg0[0]) / 100;
      for (int i = arg0[0]; i <= arg0[1]; i++) {
        if (isCancelled()) {
          onCancelled(n);
          return n;
        }
        if (isPrime(i))
          n++;
        if ((i > arg0[0]) && (i % step == 0))
          publishProgress(++niveau);
      }

      return n;
    }

    private void onCancelled(final int nb) {
      runOnUiThread(new Runnable() {
        @Override
        public void run() {
          Toast.makeText(AsyncTaskActivite.this,
                         getString(R.string.ex07_calcul_annule, nb),
                         Toast.LENGTH_LONG)
            .show();
        }
      });
    }

    @Override
    protected void onProgressUpdate(Integer... values) {
      super.onProgressUpdate(values);
      mPb.setProgress(values[0]);
      mProgession.setText(getString(R.string.ex07_calcul_progression, values[0]));
    }

    @Override
    protected void onPostExecute(Integer result) {
      super.onPostExecute(result);

      if (isCancelled())
        return;

      Toast.makeText(AsyncTaskActivite.this,
                     getString(R.string.ex07_calcul_resultats, result),
                     Toast.LENGTH_LONG)
        .show();
    }

    private boolean isPrime(int n) {
      final double racine = Math.sqrt(n);
      int i = 2;

      while ((i <= racine) && (n % i != 0))
        i++;

      return (i > racine);
    }
  }
}