package fr.mondomaine.android.monappli.ex06;


import java.util.ArrayList;
import java.util.List;
import fr.mondomaine.android.monappli.R;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.ActionBarDrawerToggle;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarActivity;
import android.text.Html;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.AdapterView.OnItemClickListener;

public class NavigationDrawerActivite extends ActionBarActivity{

	DrawerLayout drawerLayout;
	ActionBarDrawerToggle actionBarDrawerToggle ;
	ListView list;
	ArrayList<DrawerItem> drawerItems;
	TextView content;
	
 	String dqsdqtexteFictifAcceuil ;//=getString(R.string.ex06_accueil);
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.ex06_navigationdrawer);
		
		drawerLayout = (DrawerLayout)findViewById(R.id.drawer_layout);

		drawerLayout.setDrawerShadow(R.drawable.drawer_shadow, Gravity.START);

		actionBarDrawerToggle = new ActionBarDrawerToggle(this, drawerLayout, R.drawable.ic_drawer, R.string.ex06_ouvert, R.string.ex06_ferme) {
			@Override
			public void onDrawerOpened(View arg0) {
				getSupportActionBar().setTitle(R.string.ex06_menu);
				Toast.makeText(NavigationDrawerActivite.this, getString(R.string.ex06_ouvert), Toast.LENGTH_SHORT).show();
			}

			@Override
			public void onDrawerClosed(View arg0) {
				getSupportActionBar().setTitle(R.string.ex06_contenu);
				Toast.makeText(NavigationDrawerActivite.this, getString(R.string.ex06_ferme), Toast.LENGTH_SHORT).show();
			}
		};
		 
		drawerLayout.setDrawerListener(actionBarDrawerToggle);
		
		getSupportActionBar().setDisplayHomeAsUpEnabled(true);
		
		fillDrawerItems();
		
		list = (ListView)findViewById(R.id.ex06_drawer_content);
		DrawerItemAdapter adapter = new DrawerItemAdapter(this, R.layout.draweritem, drawerItems);
		list.setAdapter(adapter);
		list.setOnItemClickListener(new OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> arg0, View arg1, int arg2,
					long arg3) {
				DrawerItem current = (DrawerItem)arg1.getTag();
				if(current==null)
					return;
				getSupportActionBar().setTitle(current.name);
				drawerLayout.closeDrawer(Gravity.START);
				content.setText(Html.fromHtml(current.description));
			}
		});
		
		content = (TextView)findViewById(R.id.ex06_content);
		content.setText(R.string.ex06_accueil);
		getSupportActionBar().setTitle(R.string.ex06_navigation);
		
	}
	
	private void fillDrawerItems() {
		drawerItems = new ArrayList<DrawerItem>();
		drawerItems.add(null);
		drawerItems.add(new DrawerItem("Nos Nouveauts", R.drawable.nouveautes,"<big>Nos Nouveauts</big>") );
		drawerItems.add(new DrawerItem("Devenez auteur", R.drawable.auteurs,"<big>Devenez auteurs</big>") );
		drawerItems.add(new DrawerItem("Nos collections", R.drawable.collections,"<big>Nos collections</big>") );
		drawerItems.add(new DrawerItem("Meilleures ventes", R.drawable.meilleuresventes,"<big>Meilleures ventes</big>") );
		drawerItems.add(new DrawerItem("Ressources", R.drawable.ressources,"<big>Ressources</big>") );
		drawerItems.add(new DrawerItem("Nos rubriques", R.drawable.rubriques,"<big>Nos rubriques</big>") );
		drawerItems.add(new DrawerItem("Prochaines sorties", R.drawable.sorties,"<big>Sorties</big>") );
	}

	@Override
    public boolean onOptionsItemSelected(MenuItem item) {
		if (actionBarDrawerToggle.onOptionsItemSelected(item)) {
        	return true;
        }
        return super.onOptionsItemSelected(item);
    }
	
   @Override
    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        actionBarDrawerToggle.syncState();
    }
	
   public class DrawerItem {

		public String name;
		public int icon;
		public String description;
		
		public DrawerItem(String _name, int auteurs, String description) {
			this.name = _name;
			this.icon = auteurs;
			this.description = description;
					
		}
		
	}
   
   public class DrawerItemAdapter extends ArrayAdapter<DrawerItem>{

		private Context currentContext;
		public DrawerItemAdapter(Context context, int textViewResourceId, List<DrawerItem> items) {
			super(context, textViewResourceId, items);
			currentContext = context;
		}
		
		@Override
		public View getView(int position, View convertView, ViewGroup parent) {
			
			final Activity currentActivity =(Activity) getContext(); 
			LayoutInflater vi =currentActivity.getLayoutInflater();
			
			View row=vi.inflate(R.layout.draweritem, parent, false);
			
			DrawerItem current = getItem(position);
			row.setTag(current);
			
			if(current==null)
				return row;
			
			TextView name=(TextView)row.findViewById(R.id.text);
			ImageView icon=(ImageView)row.findViewById(R.id.icon);

			name.setText(current.name);
			icon.setImageDrawable(currentContext.getResources().getDrawable(current.icon));
			return row;
		}
		
		
	}
}
