package fr.mondomaine.android.monappli.ex06;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import fr.mondomaine.android.monappli.R;


import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;

public class MonCustomAutoComplete extends AutoCompleteTextView {

	public MonCustomAutoComplete(Context context) {
		super(context);
	}
	
	public MonCustomAutoComplete(Context context, AttributeSet attr) {
		super(context, attr);

 		String attribut_1 = null;

 		// Rcupration de la valeur de l'attribut monAttributCustom_1  partir du xml de layout
 		// L'attribut contient la mthode qui doit tre invoque pour obtenir la liste des mots pour l'autocompltion
		TypedArray customAttributes = context.obtainStyledAttributes(attr, R.styleable.mesAttributsCustoms);
		if(customAttributes!=null) {
			attribut_1 = customAttributes.getString(R.styleable.mesAttributsCustoms_monAttributCustom_1);

			Method m=null;
			String[] datas =null;
		 
			try {
				DataSource ds = new DataSource();
				m = DataSource.class.getMethod(attribut_1, new Class[] {Context.class, String.class, Integer.TYPE});
				datas = (String[]) m.invoke(ds, new Object[]{context,"someData",3});
			} catch (NoSuchMethodException e) {
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		
			if(datas==null)
				return;
		
				this.setAdapter(new ArrayAdapter<String>(context,android.R.layout.select_dialog_item, datas));
		}
		customAttributes.recycle();
 	}
}
