package fr.mondomaine.android.monappli.ex05;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.RadioGroup;
import fr.mondomaine.android.monappli.R;

public class PreferencesActivite extends Activity {

  private static final String PREF_CHOIX = "choix";
  private static final String PREF_TEXTE = "texte";
  private static final int OPTION_A = 0;
  private static final int OPTION_B = 1;

  private RadioGroup mChoixRG;
  private EditText mTexteET;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex05_prefs);

    mChoixRG = (RadioGroup) findViewById(R.id.ex05_prefs_choix);
    mTexteET = (EditText) findViewById(R.id.ex05_prefs_texte);

    restaure();
  }

  public void onClickButtonSauvegarde(View view) {
    sauvegarde();
  }

  public void onClickButtonRestaure(View view) {
    restaure();
  }

  public void sauvegarde() {
    final SharedPreferences.Editor editPrefs =
      getPreferences(Context.MODE_PRIVATE).edit();
    final int choix =
      (mChoixRG.getCheckedRadioButtonId() == R.id.ex05_prefs_option_b)
        ? OPTION_B : OPTION_A;
    editPrefs.putInt(PREF_CHOIX, choix)
      .putString(PREF_TEXTE, mTexteET.getText()
        .toString())
      .commit();
  }

  public void restaure() {
    final SharedPreferences prefs = getPreferences(Context.MODE_PRIVATE);
    final int choix = prefs.getInt(PREF_CHOIX, 0);
    mChoixRG.check((choix == OPTION_B) ? R.id.ex05_prefs_option_b
      : R.id.ex05_prefs_option_a);
    final String texte = prefs.getString(PREF_TEXTE, "");
    mTexteET.setText(texte);
  }
}
