package fr.mondomaine.android.monappli.ex05;

import android.app.Activity;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.view.ViewGroup.LayoutParams;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class FournisseurDeContenusActivite extends Activity {

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex05_fournisseur_de_contenus);

    final Cursor curseur =
      managedQuery(
                   android.provider.MediaStore.Images.Media.EXTERNAL_CONTENT_URI,
                   null, null, null, null);
    final LayoutParams lp = new LayoutParams(200, 200);
    final LinearLayout layout =
      (LinearLayout) findViewById(R.id.ex05_fournisseur_de_contenus);
    if (curseur.isAfterLast()) {
      Toast.makeText(FournisseurDeContenusActivite.this,
                     R.string.ex05_fournisseur_de_contenus_pas_d_images,
                     Toast.LENGTH_LONG)
        .show();
      return;
    }
    int n = 10;
    while ((curseur.moveToNext()) && (n-- > 0)) {
      final int col = curseur.getColumnIndex("_data");
      final String uriStr = curseur.getString(col);
      final ImageView img = new ImageView(FournisseurDeContenusActivite.this);
      img.setImageURI(Uri.parse(uriStr));
      layout.addView(img, lp);
    }
  }

}
