package fr.mondomaine.android.monappli.ex05;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.http.util.ByteArrayBuffer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Environment;
import android.widget.ImageView;
import android.widget.TextView;
import fr.mondomaine.android.monappli.R;

public class FichiersActivite extends Activity {

  private static final int TAILLE_BUFFER = 1024;
  private static final String NOM_FICHIER_LOGO = "logo.jpg";

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex05_fichiers);

    ecritureFichierStockageInterne();
    lectureFichierStockageInterne();
    chemins();
  }

  public void ecritureFichierStockageInterne() {
    final Bitmap logo =
      BitmapFactory.decodeResource(getResources(), R.drawable.icone);
    final ByteArrayOutputStream fluxImg = new ByteArrayOutputStream();
    logo.compress(Bitmap.CompressFormat.JPEG, 100, fluxImg);
    final byte[] buffer = fluxImg.toByteArray();

    try {
      final FileOutputStream flux =
        openFileOutput(NOM_FICHIER_LOGO, Context.MODE_PRIVATE);
      flux.write(buffer);
      flux.close();
    } catch (final FileNotFoundException e) {
      e.printStackTrace();
    } catch (final IOException e) {
      e.printStackTrace();
    }
  }

  public void lectureFichierStockageInterne() {
    // Pour l'exemple, on lit et dcode le fichier image " la main".
    // On pourra utiliser d'autres mthodes faites directement
    // faites pour cela comme BitmapFactory.decodeFile...
    final ByteArrayBuffer bufImg = new ByteArrayBuffer(100);
    try {
      final byte[] buffer = new byte[TAILLE_BUFFER];
      final FileInputStream flux = openFileInput(NOM_FICHIER_LOGO);
      int n = 0;
      while (-1 != (n = flux.read(buffer)))
        bufImg.append(buffer, 0, n);
      flux.close();
      final Bitmap logo =
        BitmapFactory.decodeByteArray(bufImg.buffer(), 0, bufImg.length());
      final ImageView imgView =
        (ImageView) findViewById(R.id.ex05_fichiers_image);
      imgView.setImageBitmap(logo);
    } catch (final FileNotFoundException e) {
      e.printStackTrace();
    } catch (final IOException e) {
      e.printStackTrace();
    }
  }

  public void chemins() {
    final String chemin1 = getFilesDir().getPath();
    final String chemin2 = getCacheDir().getPath();
    final String chemin3 = null;
    final String chemin4 = null;
    final String chemin5 = null;
    final String chemin6 = null;
    final String etatSupportExterne = Environment.getExternalStorageState();
    if (Environment.MEDIA_MOUNTED.equals(etatSupportExterne)) {
      // Code suivant disponible  partir d'Android 2.2.
      // chemin3 = getExternalCacheDir().getPath();
      // chemin4 = getExternalFilesDir(null).getPath();
      // chemin5 =
      // getExternalFilesDir(Environment.DIRECTORY_PICTURES).getPath();
      // chemin6 =
      // Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_MUSIC).getPath();
    }
    final String chemins =
      getString(R.string.ex05_fichiers_chemins, chemin1, chemin2,
                etatSupportExterne, chemin3, chemin4, chemin5, chemin6);
    final TextView cheminsTV =
      (TextView) findViewById(R.id.ex05_fichiers_chemins);
    cheminsTV.setText(chemins);
  }
}
