package fr.mondomaine.android.monappli.ex05;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Bundle;
import android.provider.BaseColumns;
import android.widget.TextView;
import fr.mondomaine.android.monappli.R;

public class BDDActivite extends Activity {

  private class BDDAssistant extends SQLiteOpenHelper {
    private static final int VERSION = 1;
    private static final String NOM_BDD = "maBDD";
    private static final String NOM_TABLE = "maTable";
    private static final String CHAMP_NOM = "nom";

    public BDDAssistant(Context context) {
      super(context, NOM_BDD, null, VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase arg0) {
      arg0.execSQL("CREATE TABLE " + NOM_TABLE + " ( " + BaseColumns._ID
        + " INTEGER PRIMARY KEY AUTOINCREMENT, " + CHAMP_NOM + " TEXT );");
    }

    @Override
    public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {
    }
  }

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex05_bdd);
    creationBdd();
    lectureBdd();
  }

  private void creationBdd() {
    final BDDAssistant bddAss = new BDDAssistant(this);
    final SQLiteDatabase bdd = bddAss.getWritableDatabase();

    ContentValues valeurs = new ContentValues();
    valeurs.put(BDDAssistant.CHAMP_NOM, "Jean_" + System.currentTimeMillis());
    bdd.insertOrThrow(BDDAssistant.NOM_TABLE, null, valeurs);

    valeurs = new ContentValues();
    valeurs.put(BDDAssistant.CHAMP_NOM, "Pierre_" + System.currentTimeMillis());
    bdd.insertOrThrow(BDDAssistant.NOM_TABLE, null, valeurs);

    valeurs = new ContentValues();
    valeurs.put(BDDAssistant.CHAMP_NOM, "Jacques_" + System.currentTimeMillis());
    bdd.insertOrThrow(BDDAssistant.NOM_TABLE, null, valeurs);

    bdd.close();
    bddAss.close();
  }

  private void lectureBdd() {
    final BDDAssistant bddAss = new BDDAssistant(this);
    final SQLiteDatabase bdd = bddAss.getReadableDatabase();

    final StringBuffer noms = new StringBuffer("Noms :\n");
    final Cursor curseur =
      bdd.query(BDDAssistant.NOM_TABLE,
                new String[] { BDDAssistant.CHAMP_NOM }, null, null, null,
                null, BDDAssistant.CHAMP_NOM + " desc");
    while (curseur.moveToNext()) {
      final String nom = curseur.getString(0);
      noms.append(nom + "\n");
    }

    bdd.close();
    bddAss.close();

    final TextView tv = (TextView) findViewById(R.id.ex05_bdd_noms);
    tv.setText(noms);
  }
}
