package fr.mondomaine.android.monappli.ex04;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class ServiceActivite extends Activity {

  private Button mBoutonBindUnbind;
  private Button mBoutonAction;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex04_service);

    mBoutonAction = (Button) findViewById(R.id.ex04_service_bouton_action);
    mBoutonBindUnbind =
      (Button) findViewById(R.id.ex04_service_bouton_bind_unbind);
  }

  public void onClickButtonStartService(View v) {
    final Intent intent = new Intent(this, MonService.class);
    startService(intent);
  }

  public void onClickButtonStopService(View v) {
    final Intent intent = new Intent(this, MonService.class);
    stopService(intent);
  }

  public void onClickButtonStopSelfService(View v) {
    final Intent intent = new Intent(this, MonService.class);
    intent.putExtra(MonService.CLE_STOP, true);
    startService(intent);
  }

  // ////////////////////////////////////////////////////////
  // Ci-dessous ce qui concerne les connexions au service //

  private MonService mService;

  public void onClickButtonBindUnbindService(View v) {
    if (mService == null) {
      final Intent intent = new Intent(this, MonService.class);
      bindService(intent, mConnexion, Context.BIND_AUTO_CREATE);
    } else {
      unbindService(mConnexion);
      mService = null;
      mBoutonAction.setEnabled(false);
      mBoutonBindUnbind.setText(R.string.ex04_service_bouton_bind);
    }
  }

  public void onClickButtonActionService(View v) {
    mService.faisQuelqueChose();
  }

  private final ServiceConnection mConnexion = new ServiceConnection() {

    @Override
    public void onServiceConnected(ComponentName arg0, IBinder arg1) {
      Toast.makeText(ServiceActivite.this, "onServiceConnected",
                     Toast.LENGTH_SHORT)
        .show();
      mService = ((MonService.MonServiceBinder) arg1).getService();
      mBoutonAction.setEnabled(true);
      mBoutonBindUnbind.setText(R.string.ex04_service_bouton_unbind);
    }

    @Override
    public void onServiceDisconnected(ComponentName arg0) {
      Toast.makeText(ServiceActivite.this, "onServiceDisconnected",
                     Toast.LENGTH_SHORT)
        .show();
      mService = null;
      mBoutonAction.setEnabled(false);
      mBoutonBindUnbind.setText(R.string.ex04_service_bouton_bind);
    }

  };

}
