package fr.mondomaine.android.monappli.ex04;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.widget.Toast;
import fr.mondomaine.android.monappli.MonActiviteDestinataire;
import fr.mondomaine.android.monappli.R;

public class MonService extends Service {

  public static final String CLE_STOP = "stop";

  @Override
  public void onCreate() {
    super.onCreate();
    Toast.makeText(this, "onCreate", Toast.LENGTH_SHORT)
      .show();
  }

  @Override
  public int onStartCommand(Intent intent, int flags, int startId) {
    // L'excution de cette mthode se fait dans le thread principal.
    // Pour ne pas bloquer l'application, il est vivement recommand
    // d'excuter tout traitement long dans un thread secondaire.
    // Cf. Chapitre 'Concurrence, scurit et rseau'.

    Toast.makeText(this, "onStartCommand: startId=" + startId,
                   Toast.LENGTH_SHORT)
      .show();

    afficheNotification(startId);

    final boolean stop = intent.getBooleanExtra(CLE_STOP, false);
    if (stop) {
      Toast.makeText(this, "stopSelf", Toast.LENGTH_SHORT)
        .show();
      stopSelf();
    }

    return super.onStartCommand(intent, flags, startId);
  }

  @Override
  public void onDestroy() {
    Toast.makeText(this, "onDestroy", Toast.LENGTH_SHORT)
      .show();
    final NotificationManager notificationManager =
      (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
    notificationManager.cancel(0);
    super.onDestroy();
  }

  private void afficheNotification(final int nb) {
    // La mthode setOngoing ci-dessous permet d'ajouter une notification
    // persistante = qui ne peut tre supprime par l'utilisateur.
    // Cela permet d'indiquer  l'utilisateur qu'un service est en cours...
    final long[] patternVibrations =
      { 0, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50 };

    final Intent notificationIntent =
      new Intent(this, MonActiviteDestinataire.class);
    notificationIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
    final PendingIntent pendingIntent =
      PendingIntent.getActivity(this, 0, notificationIntent, 0);

    final Notification notification =
      new Notification(R.drawable.icone,
        getString(R.string.ex04_notification_ticker),
        System.currentTimeMillis());
    notification.setLatestEventInfo(
                                    this,
                                    getString(R.string.ex04_notification_titre),
                                    getString(R.string.ex04_notification_texte),
                                    pendingIntent);

    notification.defaults |=
      Notification.DEFAULT_VIBRATE | Notification.DEFAULT_LIGHTS;
    notification.flags |= Notification.FLAG_ONGOING_EVENT;
    notification.vibrate = patternVibrations;

    if (notification != null) {
      final NotificationManager notificationManager =
        (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
      notificationManager.notify(0, notification);
    }
  }

  // ////////////////////////////////////////////////////////
  // Ci-dessous ce qui concerne les connexions au service //

  // Cette classe permet de spcialiser la classe Binder
  // en retournant l'instance du service MonService.
  public class MonServiceBinder extends Binder {
    MonService getService() {
      return MonService.this;
    }
  }

  // L'objet mBinder est l'objet qui est fourni au composant
  // via la mthode onBind.
  private final IBinder mBinder = new MonServiceBinder();

  @Override
  public IBinder onBind(Intent intent) {
    Toast.makeText(this, "onBind", Toast.LENGTH_SHORT)
      .show();
    afficheNotification(0);
    return mBinder;
  }

  @Override
  public boolean onUnbind(Intent intent) {
    Toast.makeText(this, "onUnbind", Toast.LENGTH_SHORT)
      .show();
    return super.onUnbind(intent);
    // Remplacez la ligne prcdente par la ligne suivante pour permettre
    // les appels  la mthode onRebind;
    // return true;
  }

  @Override
  public void onRebind(Intent intent) {
    Toast.makeText(this, "onRebind", Toast.LENGTH_SHORT)
      .show();
    super.onRebind(intent);

  }

  public void faisQuelqueChose() {
    Toast.makeText(this, "faisQuelqueChose", Toast.LENGTH_SHORT)
      .show();
  }
}
