package fr.mondomaine.android.monappli.ex04;

import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class ListeSimpleActivite extends ListActivity {

  private String[] mLibelles;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    mLibelles = getResources().getStringArray(R.array.libelles);

    final ArrayAdapter<String> adaptateur =
      new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1,
        mLibelles);

    setListAdapter(adaptateur);
  }

  @Override
  protected void onListItemClick(ListView l, View v, int position, long id) {
    Toast.makeText(this, mLibelles[position], Toast.LENGTH_SHORT)
      .show();
  }

}
