package fr.mondomaine.android.monappli.ex04;

import android.app.ListActivity;
import android.graphics.Color;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.RatingBar;
import android.widget.TextView;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class ListePersonnaliseeActivite extends ListActivity {

  private static final int NB_ELTS = 200;

  private class Element {
    int idDrawable;
    String titre;
    float note;
    String msg;

    public Element(int n) {
      idDrawable = (n % 2 == 0) ? R.drawable.icone : R.drawable.ex13_appwidget;
      titre = "Titre_" + n;
      note = n * 5.f / NB_ELTS;
      msg = "Message_" + n;
    }
  }

  private Element[] mElts;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    mElts = new Element[NB_ELTS];
    for (int i = 0; i < mElts.length; i++)
      mElts[i] = new Element(i);

    final AdaptateurPersonnalise adaptateur = new AdaptateurPersonnalise();

    setListAdapter(adaptateur);
  }

  @Override
  protected void onListItemClick(ListView l, View v, int position, long id) {
    Toast.makeText(this, mElts[position].titre, Toast.LENGTH_SHORT)
      .show();
  }

  private class AdaptateurPersonnalise extends BaseAdapter {

    private class ViewHolder {
      View vue;
      ImageView img;
      TextView titre;
      RatingBar note;
      TextView msg;
    }

    private final LayoutInflater mInflater;

    public AdaptateurPersonnalise() {
      mInflater = LayoutInflater.from(ListePersonnaliseeActivite.this);
    }

    @Override
    public int getCount() {
      return mElts.length;
    }

    @Override
    public Object getItem(int position) {
      return position;
    }

    @Override
    public long getItemId(int position) {
      return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
      ViewHolder holder;

      if (convertView != null)
        holder = (ViewHolder) convertView.getTag();
      else {
        convertView = mInflater.inflate(R.layout.ex04_liste_perso_ligne, null);

        holder = new ViewHolder();
        holder.vue = convertView.findViewById(R.id.ex04_liste_perso_ligne);
        holder.img =
          (ImageView) convertView.findViewById(R.id.ex04_liste_perso_ligne_img);
        holder.titre =
          (TextView) convertView.findViewById(R.id.ex04_liste_perso_ligne_titre);
        holder.note =
          (RatingBar) convertView.findViewById(R.id.ex04_liste_perso_ligne_note);
        holder.msg =
          (TextView) convertView.findViewById(R.id.ex04_liste_perso_ligne_msg);

        convertView.setTag(holder);
      }

      holder.vue.setBackgroundColor((position % 2 == 0) ? Color.DKGRAY
        : Color.GRAY);
      holder.img.setImageResource(mElts[position].idDrawable);
      holder.titre.setText(mElts[position].titre);
      holder.note.setRating(mElts[position].note);
      holder.msg.setText(mElts[position].msg);

      return convertView;
    }
  }

}
