package fr.mondomaine.android.monappli.ex03;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import fr.mondomaine.android.monappli.MonActiviteDestinataire;
import fr.mondomaine.android.monappli.R;

public class NotificationActivite extends Activity {
  private int mId = 0;

  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex03_notification);
  }

  public void onClickButton(View view) {
    mId++;

    final long[] patternVibrations =
      { 0, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50 };

    final Intent notificationIntent =
      new Intent(this, MonActiviteDestinataire.class);
    notificationIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
    final PendingIntent pendingIntent =
      PendingIntent.getActivity(this, 0, notificationIntent, 0);

    final Notification notification =
      new Notification(R.drawable.icone,
        getString(R.string.ex03_notification_ticker),
        System.currentTimeMillis());
    notification.setLatestEventInfo(
                                    this,
                                    getString(R.string.ex03_notification_titre),
                                    getString(R.string.ex03_notification_texte),
                                    pendingIntent);

    notification.defaults |= Notification.DEFAULT_LIGHTS;
    notification.flags |= Notification.FLAG_AUTO_CANCEL;
    notification.vibrate = patternVibrations;

    Toast.makeText(
                   this,
                   (notification == null) ? R.string.ex03_notification_erreur
                     : R.string.ex03_notification_ajoutee, Toast.LENGTH_LONG)
      .show();

    if (notification != null) {
      final NotificationManager notificationManager =
        (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
      notificationManager.notify(mId, notification);
    }
  }
}
