package fr.mondomaine.android.monappli.ex03;

import android.app.Activity;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ContextMenu.ContextMenuInfo;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class MenuContextuelActivite extends Activity {

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    setContentView(R.layout.ex03_menu_contextuel);

    final View vue = findViewById(R.id.ex03_menu_contextuel);
    registerForContextMenu(vue);
  }

  @Override
  public void onCreateContextMenu(ContextMenu menu, View v,
    ContextMenuInfo menuInfo) {
    switch (v.getId()) {
    case R.id.ex03_menu_contextuel:
      final MenuInflater inflater = getMenuInflater();
      inflater.inflate(R.menu.ex03_contextuel, menu);
      break;
    default:
      super.onCreateContextMenu(menu, v, menuInfo);
      break;
    }
  }

  @Override
  public boolean onContextItemSelected(MenuItem item) {
    Toast.makeText(this,
                   getString(R.string.ex03_menu_selection, item.getTitle()),
                   Toast.LENGTH_SHORT)
      .show();
    switch (item.getItemId()) {
    case R.id.menu_contextuel_option3:
    case R.id.menu_contextuel_option4:
    case R.id.menu_contextuel_option5:
    case R.id.menu_contextuel_option6:
      item.setChecked(!item.isChecked());
      return true;
    case R.id.menu_contextuel_option1:
      Toast.makeText(this, getString(R.string.ex03_menu_selection_option1),
                     Toast.LENGTH_SHORT)
        .show();
      return true;
    }
    return super.onContextItemSelected(item);
  }

}
