package fr.mondomaine.android.monappli.ex03;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class DialogueActivite extends Activity {
  private static final int DIALOGUE_ALERTE = 1;
  private static final int DIALOGUE_CHOIX = 2;
  private static final int DIALOGUE_PROGRESSION = 3;
  private static final int DIALOGUE_PROGRESSION_IND = 4;

  private ProgressDialog mDialogueProgress;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    setContentView(R.layout.ex03_dialogue);
  }

  public void onClickButtonAlert(View view) {
    showDialog(DIALOGUE_ALERTE);
  }

  public void onClickButtonChoix(View view) {
    showDialog(DIALOGUE_CHOIX);
  }

  public void onClickButtonProgress(View view) {
    showDialog(DIALOGUE_PROGRESSION);
    final int valeur = (int) (System.currentTimeMillis() % 50) + 1;
    mDialogueProgress.setProgress(valeur);
    mDialogueProgress.setSecondaryProgress(valeur + valeur);
  }

  public void onClickButtonProgressInd(View view) {
    showDialog(DIALOGUE_PROGRESSION_IND);
  }

  // A partir de Android 2.2, il faut implmenter  la place la mthode
  // protected Dialog onCreateDdialogd(int id, Bundle args)
  @Override
  protected Dialog onCreateDialog(int id) {
    switch (id) {
    case DIALOGUE_ALERTE: {
      final AlertDialog.Builder builder = new AlertDialog.Builder(this);
      builder.setTitle(R.string.ex03_dialogue_alerte)
        .setMessage(R.string.ex03_dialogue_alerte_msg)
        .setCancelable(false)
        .setIcon(android.R.drawable.ic_dialog_alert)
        .setPositiveButton(android.R.string.ok,
                           new DialogInterface.OnClickListener() {
                             public void onClick(DialogInterface dialog, int id) {
                               Toast.makeText(DialogueActivite.this,
                                              android.R.string.ok,
                                              Toast.LENGTH_SHORT)
                                 .show();
                             }
                           })
        .setNegativeButton(android.R.string.cancel,
                           new DialogInterface.OnClickListener() {
                             public void onClick(DialogInterface dialog, int id) {
                               Toast.makeText(DialogueActivite.this,
                                              android.R.string.cancel,
                                              Toast.LENGTH_SHORT)
                                 .show();
                             }
                           });
      return builder.create();
    }
    case DIALOGUE_CHOIX: {
      final String[] choix =
        { getString(R.string.ex03_dialogue_choix1),
          getString(R.string.ex03_dialogue_choix2),
          getString(R.string.ex03_dialogue_choix3) };

      final AlertDialog.Builder builder = new AlertDialog.Builder(this);
      builder.setTitle(R.string.ex03_dialogue_alerte)
        .setIcon(android.R.drawable.ic_dialog_alert)
        .setItems(choix, new DialogInterface.OnClickListener() {
          public void onClick(DialogInterface dialog, int item) {
            Toast.makeText(DialogueActivite.this, choix[item],
                           Toast.LENGTH_SHORT)
              .show();
          }
        });
      return builder.create();
    }
    case DIALOGUE_PROGRESSION: {
      final ProgressDialog progressDialog = new ProgressDialog(this);
      progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
      progressDialog.setMessage(getString(R.string.chargement));
      progressDialog.setTitle(R.string.ex03_dialogue_progression);
      progressDialog.setMax(100);
      progressDialog.setProgress(0);
      progressDialog.setIcon(R.drawable.icone);
      mDialogueProgress = progressDialog;
      return progressDialog;
    }
    case DIALOGUE_PROGRESSION_IND: {
      final ProgressDialog progressDialog = new ProgressDialog(this);
      progressDialog.setMessage(getString(R.string.chargement));
      progressDialog.setTitle(R.string.ex03_dialogue_progression_ind);
      progressDialog.setIcon(R.drawable.icone);
      return progressDialog;
    }
    default:
      return null;
    }
  }
}
