package fr.mondomaine.android.monappli.ex02;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import fr.mondomaine.android.monappli.R;

public class ResultatActivite extends Activity {

  private static final int REQ_CODE = 1;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex02_resultat);
  }

  public void onClickButton(View view) {
    final Intent intent = new Intent(this, ResultatDestActivite.class);
    startActivityForResult(intent, REQ_CODE);
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, Intent data) {
    switch (requestCode) {
    case REQ_CODE:
      String texte;
      final String resTxt =
        (resultCode == RESULT_OK) ? "RESULT_OK" : "RESULT_CANCELED";
      if (resultCode == RESULT_OK) {
        final String val1 = data.getStringExtra(ResultatDestActivite.CLE1);
        final boolean val2 =
          data.getBooleanExtra(ResultatDestActivite.CLE2, false);
        texte =
          getString(R.string.ex02_resultat_ok, resTxt,
                    ResultatDestActivite.CLE1, val1, ResultatDestActivite.CLE2,
                    val2);
      } else
        texte = getString(R.string.ex02_resultat_ko, resTxt);
      Toast.makeText(this, texte, Toast.LENGTH_LONG)
        .show();
      break;
    // ...
    default:
      super.onActivityResult(requestCode, resultCode, data);
      break;
    }
  }

}
