package fr.mondomaine.android.monappli.ex02;

import java.util.Random;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.CheckBox;
import fr.mondomaine.android.monappli.R;

public class RestaurationActivite extends Activity {

  private static final String CLE_COULEUR = "couleur";

  private View mLayout;
  private CheckBox mSauvegardeCheckBox;
  private int mCouleur;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex02_restauration);

    mSauvegardeCheckBox =
      (CheckBox) findViewById(R.id.ex02_restauration_checkbox);
    mLayout = findViewById(R.id.ex02_restauration_layout);

    final Random r = new Random(System.currentTimeMillis());
    mCouleur = r.nextInt();
  }

  @Override
  protected void onResume() {
    super.onResume();
    mLayout.setBackgroundColor(mCouleur);
  }

  @Override
  protected void onSaveInstanceState(Bundle outState) {
    super.onSaveInstanceState(outState);
    if (mSauvegardeCheckBox.isChecked())
      outState.putInt(CLE_COULEUR, mCouleur);
  }

  @Override
  protected void onRestoreInstanceState(Bundle savedInstanceState) {
    super.onRestoreInstanceState(savedInstanceState);
    if (mSauvegardeCheckBox.isChecked())
      mCouleur = savedInstanceState.getInt(CLE_COULEUR);
  }

}
