package fr.mondomaine.android.monappli.ex02;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import fr.mondomaine.android.monappli.MonActivitePrincipale;
import fr.mondomaine.android.monappli.R;

public abstract class PileParentActivite extends Activity {
  public static String CLE_PILE = "pile";

  private String mPile;
  private TextView mPileTV;
  private Button mDepilerABouton;
  private Button mDepilerBBouton;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.ex02_pile);

    mPile = getIntent().getStringExtra(CLE_PILE);
    if (mPile == null)
      mPile = getString(R.string.ex02_pile_init) + "A";
    mPileTV = (TextView) findViewById(R.id.ex02_pile_etat);
    mPileTV.setText(mPile);

    mDepilerABouton = (Button) findViewById(R.id.ex02_pile_bouton_depiler_a);
    mDepilerBBouton = (Button) findViewById(R.id.ex02_pile_bouton_depiler_b);
    majBoutons();
  }

  public void onClickButtonEmpilerA(View view) {
    final Intent intent = new Intent(this, PileAActivite.class);
    intent.putExtra(CLE_PILE, mPile + "A");
    startActivity(intent);
    majBoutons();
  }

  public void onClickButtonEmpilerB(View view) {
    final Intent intent = new Intent(this, PileBActivite.class);
    intent.putExtra(CLE_PILE, mPile + "B");
    startActivity(intent);
    majBoutons();
  }

  // Le drapeau FLAG_ACTIVITY_CLEAR_TOP dpile les activits jusqu' rencontrer
  // la premire activit du type dsign, ici PileAActivite.
  // Le drapeau FLAG_ACTIVITY_SINGLE_TOP permet de rutiliser l'activit
  // PileAActivite destinataire sans la recrer.
  public void onClickButtonDepilerJusquaA(View view) {
    final Intent intent = new Intent(this, PileAActivite.class);
    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
    intent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
    startActivity(intent);
    majBoutons();
  }

  // Le drapeau FLAG_ACTIVITY_CLEAR_TOP dpile les activits jusqu' rencontrer
  // la premire activit du type dsign, ici PileBActivite.
  // Le drapeau FLAG_ACTIVITY_SINGLE_TOP permet de rutiliser l'activit
  // PileBActivite destinataire sans la recrer.
  public void onClickButtonDepilerJusquaB(View view) {
    final Intent intent = new Intent(this, PileBActivite.class);
    intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
    intent.addFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
    startActivity(intent);
    majBoutons();
  }

  // Pour dpiler toutes les activits jusqu' l'activit d'accueil
  // MonActivitePrincipale, celle-ci doit spcifier l'attribut
  // android:launchMode="singleTask" dans sa balise activity.
  public void onClickButtonDepilerTout(View view) {
    final Intent intent = new Intent(this, MonActivitePrincipale.class);
    startActivity(intent);
  }

  private void majBoutons() {
    mDepilerABouton.setEnabled(mPile.matches(".*AB+$"));
    mDepilerBBouton.setEnabled(mPile.matches(".*BA+$"));
  }

}
