package fr.mondomaine.android.monappli.ex01;

import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.RelativeLayout.LayoutParams;
import fr.mondomaine.android.monappli.R;

public class ModeProgrammatiqueActivite extends Activity {

  private RelativeLayout mLayout;
  private TextView mTexte;

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    mLayout = new RelativeLayout(this);
    // A partir de Android 2.2, FILL_PARENT doit tre remplac par MATCH_PARENT
    final LayoutParams lp =
      new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT);
    mLayout.setLayoutParams(lp);

    mTexte = new TextView(this);
    final LayoutParams lpTv =
      new LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
    mLayout.addView(mTexte, lpTv);

    final int orientationEcran = getResources().getConfiguration().orientation;
    setValeursSelonOrientationEcran(orientationEcran);

    setContentView(mLayout);
  }

  @Override
  public void onConfigurationChanged(Configuration newConfig) {
    super.onConfigurationChanged(newConfig);
    setValeursSelonOrientationEcran(newConfig.orientation);
  }

  private void setValeursSelonOrientationEcran(int orientationEcran) {
    if (orientationEcran == Configuration.ORIENTATION_LANDSCAPE) {
      mLayout.setBackgroundColor(Color.BLACK);
      mTexte.setText(R.string.ex01_message_paysage);
    } else {
      mLayout.setBackgroundColor(Color.BLUE);
      mTexte.setText(R.string.ex01_message_portrait);
    }
  }
}