package fr.mondomaine.android.monappli;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;

public class MonActivitePrincipale extends ListActivity {

  private static final String CHEMIN = "%1$s.ex%2$02d.%3$s";

  private static final String[][] ACTIVITES_PAR_CHAPITRE =
    {
    // Exemples 01 - Dcouverte de l'interface utilisateur
      { "MesuresEcranActivite", "ModeDeclaratifActivite",
        "ModeProgrammatiqueActivite", "TextViewActivite", "EditTextActivite",
        "Button1Activite", "Button2Activite", "AutresWidgetsActivite" },
      // Exemples 02 - Les fondations
      { "IntentionExpliciteActivite", "IntentionImpliciteActivite",
        "PortraitActivite", "PaysageActivite", "CycleDeVieActivite",
        "ResultatActivite", "RestaurationActivite", "PileAActivite" },
      // Exemples 03 - Complter l'interface utilisateur
      { "StylesThemesActivite", "MenuActivite", "MenuContextuelActivite",
        "ToastActivite", "DialogueActivite", "NotificationActivite" },
      // Exemples 04 - Composants applicatifs principaux
      { "ServiceActivite", "RecepteurEvenementsActivite",
        "ListeSimpleActivite", "ListePersonnaliseeActivite" },
      // Exemples 05
      { "PreferencesActivite", "FichiersActivite", "BDDActivite",
        "FournisseurDeContenusActivite"},
        // Exemple 06 - Construire des interfaces complexe
        {"ComposantPersonnaliseActivite","NavigationDrawerActivite",
        	"ImagesRedimensionnablesActivite"},
        //
      // Exemples 07 - Concurrence, scurit et rseau
      { "ProcessusActivite", "AsyncTaskActivite", "ThreadActivite",
        "HTTPActivite", "ANRActivite" },
        // Exemples 08 - rseaux sociaux
        {"ReseauxSociauxActivite"},
      // Exemples 09 - Tracer, deboguer et tester
      { "JournalEvenementsActivite", "TestsUnitairesActivite",
        "TestsFonctionnelsActivite", "TestDuSingeActivite" },
      // Exemples 10 - Publier une application
      { "PublicationActivite" },
      // Exemples 11 - Cartes et localisation gographique
      { "GeolocActivite", "CarteActivite" },
      // Exemples 12 - La technologie NFC
      {"DecouverteNFCActivite"},
      // Exemples 13 - Fonctionnalits avances
      { "AppWidgetActivite", "LicenceActivite" } };

  @Override
  public void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    final String[] chapitres = getResources().getStringArray(R.array.chapitres);

    setListAdapter(new ArrayAdapter<String>(this,
      android.R.layout.simple_list_item_1, chapitres));
  }

  @Override
  protected void onListItemClick(ListView l, View v, final int position, long id) {
    final int nChap = position + 1;

    if (ACTIVITES_PAR_CHAPITRE[position].length ==1) {
      lanceActivite(nChap, position, 0);
      return;
    }

    final AlertDialog.Builder builder = new AlertDialog.Builder(this);
    builder.setItems(ACTIVITES_PAR_CHAPITRE[position],
                     new DialogInterface.OnClickListener() {
                       public void onClick(DialogInterface dialog, int item) {
                         lanceActivite(nChap, position, item);
                       }
                     });
    builder.create()
      .show();
  }

  private void lanceActivite(final int nChap, final int position, final int elt) {
    try {
      final String chemin =
        String.format(CHEMIN, getPackageName(), nChap,
                      ACTIVITES_PAR_CHAPITRE[position][elt]);
      final Intent intent =
        new Intent(MonActivitePrincipale.this, Class.forName(chemin));
      startActivity(intent);
    } catch (final ClassNotFoundException e) {
      e.printStackTrace();
    }
  }
}