package com.eni.android.viewpager;

import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.TextView;

public class ViewPagerExempleActivity extends Activity {

	private ViewPager myViewPager;
	private static int NUMBER_OF_PAGES = 5;
	private ViewPagerAdapter viewAdapter;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		
		 viewAdapter = new ViewPagerAdapter();
		 myViewPager = (ViewPager) findViewById(R.id.viewPager);
		 myViewPager.setAdapter(viewAdapter);

	}

	private class ViewPagerAdapter extends PagerAdapter {

		@Override
		public int getCount() {
			return NUMBER_OF_PAGES;
		}

		@Override
		public Object instantiateItem(View collection, int position) {
			TextView tv = new TextView(ViewPagerExempleActivity.this);
			tv.setText(R.string.page_numero_ + position);
			tv.setTextColor(Color.BLACK);
			tv.setTextSize(30);

			((ViewPager) collection).addView(tv, 0);

			return tv;
		}
		
		 @Override
         public void destroyItem(View collection, int position, Object view) {
                 ((ViewPager) collection).removeView((TextView) view);
         }

         
         
         @Override
         public boolean isViewFromObject(View view, Object object) {
                 return view==((TextView)object);
         }
         
         @Override
         public void finishUpdate(View arg0) {}
         

         @Override
         public void restoreState(Parcelable arg0, ClassLoader arg1) {}

         @Override
         public Parcelable saveState() {
                 return null;
         }

         @Override
         public void startUpdate(View arg0) {}

	}
}