package com.eni.android.textwatcher;

import android.app.Activity;
import android.graphics.Color;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class Ch7_TextWatcherExempleActivity extends Activity implements
		TextWatcher {

	private EditText msg;
	private TextView textIndicator;
	private Button send;

	private final static int NBMAXCHAR = 20;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		msg = (EditText) findViewById(R.id.msg);
		msg.addTextChangedListener(this);
		textIndicator = (TextView) findViewById(R.id.indicator);
		send = (Button) findViewById(R.id.send);
	}

	@Override
	public void afterTextChanged(Editable s) {
		int nbChar = msg.getText().toString().length();
		int leftChar = NBMAXCHAR - nbChar;
		if (leftChar >= 0) {
			textIndicator.setText(Integer.toString(leftChar)
					+ R.string._caract_res_restants);
			textIndicator.setTextColor(Color.GREEN);
			send.setEnabled(true);
		} else {
			textIndicator.setTextColor(Color.RED);
			textIndicator.setText(Integer.toString(Math.abs(leftChar))
					+ R.string._caract_res_en_trop);
			send.setEnabled(false);
		}

	}

	@Override
	public void beforeTextChanged(CharSequence s, int start, int count,
			int after) {
	}

	@Override
	public void onTextChanged(CharSequence s, int start, int before, int count) {
	}
}