package com.eni.android.rotation;

import android.app.Activity;
import android.os.Bundle;
import android.widget.EditText;

public class Ch7_RotationManuelleExempleActivity extends Activity {

	private static final String EMAIL = "EMAIL";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		EditText email = (EditText) findViewById(R.id.email);
		String emailTxt = email.getText().toString();
		outState.putString(EMAIL, emailTxt);
	}

	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);
		EditText email = (EditText) findViewById(R.id.email);
		email.setText(savedInstanceState.getString(EMAIL));
	}

}