package com.eni.android.notifications;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class MainActivity extends Activity {

	private static int NOTIFICATION_ID = 0;
	private final static int REQUEST_CODE = 0;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		Button notification = (Button) findViewById(R.id.launch_notification);
		notification.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				createNotification();
			}
		});

	}

	protected void createNotification() {
		final NotificationManager mNotification = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);

		final Intent launchNotifiactionIntent = new Intent(this,
				MainActivity.class);
		final PendingIntent pendingIntent = PendingIntent.getActivity(this,
				REQUEST_CODE, launchNotifiactionIntent,
				PendingIntent.FLAG_ONE_SHOT);

		Notification.Builder builder = new Notification.Builder(this)
				.setWhen(System.currentTimeMillis())
				.setTicker(
						getResources().getString(
								R.string.notification_launching_title))
				.setSmallIcon(R.drawable.ic_launcher)
				.setContentTitle(
						getResources().getString(R.string.notification_title))
				.setContentText(
						getResources().getString(R.string.notification_desc))
				.setContentIntent(pendingIntent)
				.addAction(
						R.drawable.play,
						"Play",
						PendingIntent.getActivity(getApplicationContext(), 0,
								getIntent(), 0, null))
				.addAction(
						R.drawable.pause,
						"Pause",
						PendingIntent.getActivity(getApplicationContext(), 0,
								getIntent(), 0, null));

		Notification notification = new Notification.BigPictureStyle(builder)
				.bigPicture(
						BitmapFactory.decodeResource(getResources(),
								R.drawable.android_logo)).build();

		mNotification.notify(NOTIFICATION_ID, notification);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.activity_main, menu);
		return true;
	}

}
