package com.eni.android.clickListener;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class Ch6_ClickListenerMethod1Activity extends Activity implements
		OnClickListener {

	private static final String CLICK_LISTENER = "ClickListener";

	/**
	 * La classe implemente l'interface OnClickListener
	 */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button btn1 = (Button) findViewById(R.id.btn1);
		btn1.setOnClickListener(this);

		Button btn2 = (Button) findViewById(R.id.btn2);
		btn2.setOnClickListener(this);
	}

	@Override
	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.btn1:
			Log.v(CLICK_LISTENER, getString(R.string.interaction_avec_le_bouton_1));
			break;
		case R.id.btn2:
			Log.v(CLICK_LISTENER, getString(R.string.interaction_avec_le_bouton_2));
			break;
		default:
			break;
		}
	}
}